/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */
package cn.smarthse.modules.health.service.work.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.Company;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.supervise.service.keyFactory.IApprovalDataSourceService;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;


/**
 * ipersonal保护装备记录服务
 *
 * @author zhangxu
 * @date 2023-05-10
 *///TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IProtectEquipIssueRecordService extends IBaseService<ProtectEquipIssueRecord>, IApprovalDataSourceService {


    /**
     * 查询个人防护用品列表
     *
     * @param searchModel 搜索模式
     * @return {@code List<ProtectEquipIssueRecord> }
     * @author zhangxu
     * @date 2023-05-10
     */
    List<ProtectEquipIssueRecord> getListIssueRecordBySearchModel(ProtectEquipIssueRecord searchModel);
    PageInfo<ProtectEquipIssueRecord> getPagesIssueRecordBySearchModel(JqGridParam jqGridParam, ProtectEquipIssueRecord searchModel);

    /**
     * 通过id删除个人防护用品记录
     * 逻辑删除
     *
     * @param ids           ids
     * @param loginStaffId 登录员工id
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer deleteByIds(List<Long> ids, Long loginStaffId);

    /**
     * 通过id删除个人防护用品记录
     * 物理删除
     *
     * @param ids           ids
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 克隆记录
     *
     * @param id           id
     * @param loginStaffId 登录员工id
     * @return {@code ProtectEquipIssueRecord }
     * @author zhangxu
     * @date 2023-05-11
     */
    ProtectEquipIssueRecord cloneRecord(Long id,Long loginStaffId);

    /**
     * 保存或提交记录
     *
     * @param record       记录
     * @param changeState  改变状态
     * @return {@code ProtectEquipIssueRecord }
     * @author zhangxu
     * @date 2023-05-11
     */
    ProtectEquipIssueRecord saveOrSubmitRecord(ProtectEquipIssueRecord record,Integer changeState);

    /**
     * 变更记录类型，会清空数据
     *
     * @param id           id
     * @param reportType   报告类型
     * @param loginStaffId 登录员工id
     * @return {@code Integer }  1成功，0失败 ,-1重复操作
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer changeRecordReportType(Long id, Integer reportType, Long loginStaffId);

    /**
     * 获取某企业或所有，有记录的年份
     *
     * @param cid 登录公司员工id  为空是查询所有
     * @return {@code List<Integer> }
     * @author zhangxu
     * @date 2023-05-12
     */
    List<Integer> getAllRecordYearBySearch(Long cid);

    /**
     * 通过最新一次检测生成添加记录
     *
     * @param param 参数
     * @return {@link ProtectEquipIssueRecord }
     * @author zhangxu
     * @date 2023-05-14
     */
    ProtectEquipIssueRecord addRecordByCheck(ProtectEquipIssueRecord param);

    public List<ProtectEquipIssueRecord> getFullData(ProtectEquipIssueRecord searchModel);

    /**
     * 获取该企业最近两年已审核、无需审核的数量
     *
     * @param cid cid
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-19
     */
    public Integer getLastTwoYearsCompletedNum(Long cid);

    /**
     * 验证数据
     *
     * @param searchModel 搜索模式
     * @return {@code String }
     * @author zhangxu
     * @date 2023-05-26
     */
    public String verifyData(ProtectEquipIssueRecord searchModel);

    /**
     * 设置为终止状态
     *
     * @param record         记录
     * @param loginStaffId   登录员工id
     * @param currentCompany 目前公司
     * @author zhangxu
     * @date 2023-06-19
     */
    Long setTermination(ProtectEquipIssueRecord record, Long loginStaffId, Company currentCompany);

    /**
     * 获本年度取防护用品
     * @param cidList
     * @param param
     * @return {@code List<ProtectEquipIssueRecord> }
     * @author zhangxu
     * @date 2024-04-25
     */
    List<ProtectEquipIssueRecord> getProtectNum(List<Long> cidList,List<Integer> reportStatelist, Map<String,Object> param);
}
