/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecordDetail;
import cn.smarthse.modules.health.vo.archive.Doc4042WorkRoleHarmFactorShieldEquipVO;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;


//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IProtectEquipIssueRecordDetailService extends IBaseService<ProtectEquipIssueRecordDetail> {


    /**
     * 添加(这个方法全是手动添加的，不是检测来的)
     * 或更新
     *
     * @param recordDetail 记录详细信息
     * @param loginStaffId 登录员工id
     * @return {@code ProtectEquipIssueRecordDetail }
     * @author zhangxu
     * @date 2023-05-12
     */
    ProtectEquipIssueRecordDetail addOrUpdate(ProtectEquipIssueRecordDetail recordDetail, Long loginStaffId);

    /**
     * 根据主表id查询详情
     *
     * @param id id
     * @return {@code List<ProtectEquipIssueRecordDetail> }
     * @author zhangxu
     * @date 2023-05-11
     */
    List<ProtectEquipIssueRecordDetail> getRecordDetailListByRecordId(Long id);

    /**
     * 按条件查询详情
     *
     * @param searchModel 搜索模式
     * @return {@code List<ProtectEquipIssueRecordDetail> }
     * @author zhangxu
     * @date 2023-05-11
     */
    List<ProtectEquipIssueRecordDetail> getRecordDetailListBySearchModel(ProtectEquipIssueRecordDetail searchModel);

    PageInfo<ProtectEquipIssueRecordDetail> getPageRecordDetailListBySearchModel(JqGridParam jqGridParam, ProtectEquipIssueRecordDetail searchModel);

    /**
     * 通过主表id删除个人防护用品记录详情
     * 逻辑删除
     *
     * @param equipIssueRecordIds equipIssueRecordIds
     * @param loginStaffId        登录员工id
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer deleteByEquipIssueRecordIds(List<Long> equipIssueRecordIds, Long loginStaffId);

    /**
     * 通过主表id删除个人防护用品记录详情
     * 物理删除
     *
     * @param equipIssueRecordIds equipIssueRecordIds
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer deleteByEquipIssueRecordIds(List<Long> equipIssueRecordIds);

    /**
     * 提供给档案4
     *
     * @param cid
     * @param maxLimitDate
     * @return {@link ProtectEquipIssueRecord}
     * @author ShenZQ
     * @since 2023/5/31 15:24
     */
    ProtectEquipIssueRecord getDataTypeForArchive(Long cid, Date maxLimitDate);

    /**
     * 提供给档案4
     *
     * @param equipIssueRecordId
     * @return {@link List<Doc4042WorkRoleHarmFactorShieldEquipVO>}
     * @author ShenZQ
     * @since 2023/5/22 15:05
     */
    List<Doc4042WorkRoleHarmFactorShieldEquipVO> getDataListForArchive(Long equipIssueRecordId);

}
