/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.scene;

import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTable;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableCurrent;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableFeatures;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustom;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustomCurrent;


 /**
 * 
 * 《SceneInspectionTableService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 01:30
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ISceneInspectionTableService extends IBaseService<SceneInspectionTable>{


	/**
	 * 获取所有的检查表特征
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月5日-下午12:09:45
	 * @return
	 */
	List<SceneInspectionTableFeatures> getInspectionTableFeaturesAll(Long cid);
	
	/**
	 * 获取系统自带检查表的特征
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月27日-下午6:18:00
	 * @return
	 */
	List<SceneInspectionTableFeatures> getInspectionTableFeaturesSystemBring();
	
	/**
	 * 保存自定义特侦
	 * @param feature
	 * @return
	 */
	SceneInspectionTableFeatures saveCustomerFeature(SceneInspectionTableFeatures feature,Long loginStaffId,Long cid);
	
	/**
	 * 根据检查表id，获取检查表信息及检查内容信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月23日-下午4:41:37
	 * @param tableId
	 * @return
	 */
	SceneInspectionTable getTableAndItemById(Long tableId,Long cid);
	
	/**
	 * 获取检查表的导出数据。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月23日-下午4:59:23
	 * @param tableId
	 * @param cid
	 * @return
	 */
	Map<String,Object> getExportDataById(Long tableId,Long cid);
	
	/**
	 * 获取检查表的分页列表信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月6日-上午11:14:29
	 * @param cid 企业ID
	 * @param param 分页参数，包括查询条件
	 * @param keyword 
	 * @return
	 */
	PageInfo<SceneInspectionTable> getInspectionTablePageInfo(Long cid,JqGridParam param);
	
	/**
	 * 
	 * 获取检查表的分页列表信息(已完成）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月4日-下午5:51:39
	 * @param cid
	 * @param param
	 * @return
	 */
	PageInfo<SceneInspectionTable> getInspectionTableCompletePageInfo(Long cid,JqGridParam param);
	
	/**
	 * 克隆检查表到当前检查表，参与业务(包括所有的检查项)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月5日-下午5:08:02
	 * @param tableId 原始检查表ID（检查模板表）
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	SceneInspectionTableCurrent cloneTableToCurrent(Long tableId,Long loginStaffId,Long cid);
	
	/**
	 * 保存检查表信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月17日-下午1:33:50
	 * @param entity
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	SceneInspectionTable saveSceneInspectionTableInfo(SceneInspectionTable entity,String deleteItemIds,Long loginStaffId,Long cid);
	
	/**
	 * 获取自定义检查表内容
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月30日-上午9:22:49
	 * @param tableId 检查表ID
	 * @return
	 */
	SceneInspectionTable getTableItemCustom(Long tableId,Long cid);
	
	/**
	 * 
	 * 从检查表文件中获取检查内容信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月31日-下午1:27:11
	 * @param fileUrlPath
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	public List<SceneInspectionTableItemCustom> getTableItemByUrlPath(String fileUrlPath,Long loginStaffId,Long cid);
	
	/**
	 * 添加检查表项
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月1日-下午8:53:00
	 * @param list
	 * @return
	 */
	void addTableItems(List<SceneInspectionTableItemCustom> list,Long loginStaffId,Long cid);
	
	/**
	 * 是否存在已编辑完成的检查表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月4日-下午3:16:38
	 * @param cid 企业ID
	 * @return
	 */
	boolean hasTables(Long cid);
	
	/**
	 * 获取检查表的检查项分页信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月5日-下午2:06:25
	 * @param tableId 检查表ID
	 * @param isHideNoHiddenDenger 是否隐藏无隐患的检查项
	 * @return
	 */
	PageInfo<SceneInspectionTableItemCustomCurrent> getCurrentItemList(Long tableId,Boolean isHideNoHiddenDenger,int pageNum,int pageSize);
	
	/**
	 * 获取模板表的检查检查项信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月6日-下午4:00:55
	 * @param tableId
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	PageInfo<SceneInspectionTableItemCustom> getTemplateItemList(Long tableId,int pageNum,int pageSize,Long cid);
	
	/**
	 * 根据ID，获取当前检查表信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月6日-下午4:08:37
	 * @param tableId
	 * @return
	 */
	SceneInspectionTableCurrent  getCurrentTableById(Long tableId);
	
	/**
	 * 获取检查表及检查项I西宁西
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年10月19日-下午4:10:20
	 * @param tableId
	 * @return
	 */
	SceneInspectionTableCurrent  getCurrentTableAndItemsById(Long tableId,Boolean isHideNoHiddenDenger,int pageNum, int pageSize);
	
	/**
	 * 保存当前检查表检查项信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月10日-上午11:46:24
	 * @param entity
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	SceneInspectionTableItemCustomCurrent saveCurrentTableItem(SceneInspectionTableItemCustomCurrent entity,Long loginStaffId,Long cid);
	
	/**
	 * 删除当前检查表的检查项
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月10日-下午2:14:54
	 * @param itemId
	 * @param loginStaffId
	 */
	void delCurrentTableItem(Long itemId,Long loginStaffId);
}
