/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.scene;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.scene.SceneInspection;
import cn.smarthse.modules.health.enums.scene.InspectionTableTypeEnum;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.summary.InspectionAndReformMonthCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.InspectionTypeCountSummaryVo;
import cn.smarthse.modules.health.vo.work.sceneInspection.SceneInspectionTodolistVO;


 /**
 * 
 * 《SceneInspectionService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 01:30
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ISceneInspectionService extends IBaseService<SceneInspection>,IPlanYearWorkService{


	/**
	 * 未完成列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月29日-下午2:36:08
	 * @param cid
	 * @param year 检查年份 （可以为null）
	 * @return
	 */
	List<SceneInspection> getUnfinishedList(Long cid, Integer year);
	
	/**
	 * 上级监督检查未完成类表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月20日-下午4:17:23
	 * @param cid
	 * @return
	 */
	List<SceneInspection> getUnfinishedSuperiorsList(Long cid);
	
	/**
	 * 已完成列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月29日-下午2:36:48
	 * @param cid
	 * @return
	 */
	List<SceneInspection> getFinishedList(Long cid,JqGridParam param, Integer year);
	
	/**
	 * 获取待办事项的提示信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月29日-下午4:30:07
	 * @param cid
	 * @return
	 */
	SceneInspectionTodolistVO getTodolistVo(Long cid);
	
	/**
	 * 获取指定年份内完成的检查数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月1日-下午3:23:43
	 * @param cid
	 * @param year
	 * @return
	 */
	int getFinishedCount(Long cid,Integer year);
	
	/**
	 * 获取指定年份，进行中的数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月1日-下午3:24:17
	 * @param cid
	 * @param year
	 * @return
	 */
	int getGoingCount(Long cid ,Integer year);
	
	/**
	 * 保存现场检查信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月6日-上午11:22:02
	 * @param entity 现场检查对象
	 * @param loginStaffId 当前登录用户
	 * @param cid 企业ID
	 * @return
	 */
	SceneInspection saveInspection(SceneInspection entity,Long loginStaffId,Long cid);
	
	/**
	 * 获取未完成检查分页信息(非上级监督检查)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月6日-下午2:16:05
	 * @param cid
	 * @param param
	 * @param year inspectionActualTime 检查年份
	 * @return
	 */
	PageInfo<SceneInspection> getPageUnfinishedInspection(Long cid,JqGridParam param, Integer year);
	
	/**
	 *  获取未完成检查分页信息(上级监督检查)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月20日-下午4:20:50
	 * @param cid
	 * @param param
	 * @return
	 */
	PageInfo<SceneInspection> getPageUnfinishedInspectionSuperiors(Long cid,JqGridParam param);
	
	/**
	 * 获取已完成的检查分页信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月10日-下午2:58:52
	 * @param cid
	 * @param param
	 * @param year 检查年份
	 * @return
	 */
	PageInfo<SceneInspection> getPagefinishedInspection(Long cid,JqGridParam param, Integer year);
	
	/**
	 * 用人单位职业卫生检查和处理记录 （检查类型有：职业卫生，的都取出来。）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月7日-上午10:12:33
	 * @param cid
	 * @return
	 */
	List<SceneInspection> getListCompanyInspection(Long cid,int year);
	
	/**
	 * 职业卫生监管意见和落实情况资料(档案）（检查类型有：职业卫生，的都取出来。）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月7日-上午10:39:37
	 * @param cid
	 * @param year
	 * @return
	 */
	List<SceneInspection> getSupperInspectionInfo(Long cid,int year);
	
	/**
	 * 保存上级监督检查信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月8日-下午6:39:14
	 * @param entity
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	SceneInspection saveInspectionSuperiors(SceneInspection entity,Long loginStaffId,Long cid);
	
	/**
	 * 获取指定年份内检查的列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月26日-上午11:18:37
	 * @param year 检查年份
	 * @param cid 企业ID
	 * @param typeList 检查类型列表，不能为空
	 * @return
	 */
	List<SceneInspection> getInspectionListByYear(Integer year,Long cid,List<InspectionTableTypeEnum> typeList);
	
	/**
	 * 获取指定年份的每月检查数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月26日-下午1:58:12
	 * @param yearStr 年份字符串
	 * @param cid 企业ID
	 * @return
	 */
	InspectionAndReformMonthCountSummaryVo getMonthSummaryByYear(String yearStr,Long cid,List<InspectionTableTypeEnum> typeList);
	
	/**
	 * 根据年度字符串，获取企业的检查类型数量统计
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月29日-下午4:58:28
	 * @param yearStr
	 * @param cid
	 * @return
	 */
	InspectionTypeCountSummaryVo getInspectionTypeCountSummaryByYear(String yearStr,Long cid,List<InspectionTableTypeEnum> typeList);
	
	/**
	 * 业务数据作废
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年4月10日-下午5:13:19
	 * @param id
	 * @param loginStaffId
	 */
	void toVoid(Long id,Long loginStaffId);
	
	/**
	 * 根据当前检查表id，获取隐患排查信息
	 * @param tableId 当前检查表ID
	 * @return
	 */
	SceneInspection getSceneInspectionByTableId(Long tableId);
	
	/**
	 * 隐患排查已完成界面（21-015）中类型为职业卫生和上级监督检查记录条数。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月4日-下午2:39:08
	 * @param cid 企业ID
	 * @param year 年份，如果未空，则是所有年份
	 * @return
	 */
	int getSuperSceneInspectionNum(Long cid,Integer year);
	
	/**
	 * 更新隐患排查进行中，检查内容里面的整改项检查表。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月29日-下午1:49:47
	 * @param reformBasicId 隐患治理Id
	 * @param reformStatus 隐患治理状态，标识是否已经完成，见枚举：statuEnum，如果已完成，将该隐患治理从整改项检查表里面删除，未完成：更新隐患治理的相应信息到所有的隐患排查检查表里面去。
	 */
	void updateInspectionContentReform(Long reformBasicId,Byte reformStatus);
	
}
