package cn.smarthse.modules.health.service.work.reform;


import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.reform.RiskResolutionSource;
import cn.smarthse.modules.health.model.riskResolution.RiskSourceModel;

import java.util.List;

/**
 * 风险化解-来源子表(RiskResolutionSource)表服务接口
 *
 * @author Supw
 * @since 2024-01-29 09:26:02
 */
public interface IRiskResolutionSourceService extends IBaseService<RiskResolutionSource> {

    /**
     * 不存在就新增 根据主键 或者 (riskId+Source)
     * 不能返回主键
     * @param riskResolutionSource
     */
    void saveIfNotExist(RiskResolutionSource riskResolutionSource);

    /**
     * 批量新增
     * @param list
     */
    void saveBatchIfNotExist(List<RiskResolutionSource> list);

    /**
     * 查询风险来源
     * @param riskBasicId
     * @return
     */
    List<RiskSourceModel> getSourceByRiskBasicId(Long riskBasicId);
}

