package cn.smarthse.modules.health.service.work.reform;


import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.reform.RiskResolutionBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;

import java.util.Date;
import java.util.List;

/**
 * 风险化解-基础信息表(RiskResolutionBasic)表服务接口
 *
 * @author Supw
 * @since 2024-01-29 09:25:49
 */
public interface IRiskResolutionBasicService extends IBaseService<RiskResolutionBasic> {


    /**
     *  生成单个风险
     * @param cid                   企业id
     * @param orgId                 机构id
     * @param areaId                区域id
     * @param type                  风险类型
     * @param businessId            业务id
     * @param riskName              风险名称
     * @param reformMeasures        整改措施
     * @param finder                发现人
     * @param findName              发现人名称
     * @param findTime              发现时间
     * @param source                来源
     */
    void generateSingleRisk(Long cid, Long orgId, Long areaId, ReformGenerationSourceEnum type, Long businessId, String riskName, String reformMeasures,
                            Long finder,String findName, Date findTime, ReformSourceLiteEnum source);

    /**
     * 查询单个风险
     * @param cid
     * @param findTime
     * @param sourceEnum
     * @return
     */
    RiskResolutionBasic getByCidAndGenerationSource(Long cid, Date findTime, ReformGenerationSourceEnum sourceEnum);


    /**
     * 是否存在当前风险
     * @param cid
     * @param findTime
     * @param sourceEnum
     * @return
     */
    Boolean existRisk(Long cid,Date findTime,ReformGenerationSourceEnum sourceEnum);

}

