/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.reform;

import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.common.model.TrainCompanyStaffModel;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeTermV308;
import cn.smarthse.modules.health.entity.work.reform.*;
import cn.smarthse.modules.health.entity.work.reform.param.ReformRecordAcceptanceParam;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.*;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.param.KeyFactoryScoreParam;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.pojo.*;
import cn.smarthse.modules.health.vo.riskResolve.*;
import cn.smarthse.modules.health.vo.summary.*;
import cn.smarthse.modules.health.vo.work.keyFactory.HealthManagementArchiveVo;
import cn.smarthse.modules.health.vo.work.keyFactory.KeyFactoryStateVo;
import cn.smarthse.modules.health.vo.work.keyFactory.ThreeTimeDetailVo;
import cn.smarthse.modules.health.vo.work.reform.*;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoParam;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 《ReformItemBasicService》
 *
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-06-13 01:30
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IReformItemBasicService extends IBaseService<ReformItemBasic> {


    /**
     * 保存隐患治理基本信息，如果id为null则新增，如果id不为null，则根据内容更新
     *
     * @param entity       隐患基本信息
     * @param cid          企业ID
     * @param loginStaffId 当前登录用户的员工ID
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月9日-下午3:43:51
     */
    ReformItemBasic saveReformItemBasic(ReformItemBasic entity, Long cid, Long loginStaffId);


    /**
     * 保存隐患治理信息（危害因素检测接口）
     *
     * @param entity       隐患信息
     * @param cid          企业ID
     * @param loginStaffId 当前登录用户信息。
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月16日-下午5:28:14
     */
    ReformItemBasicHarmFactor saveReformItemBasicFromHarmFactor(ReformItemBasicHarmFactor entity, Long cid, Long loginStaffId);


    /**
     * 根据整改项ID，查找整改项信息，（危害因素检测相关）
     *
     * @param reformId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月22日-下午2:32:13
     */
    ReformItemBasicHarmFactor getReformItemBasicForHarmFactorByReformId(Long reformId);


    /**
     * 根据整改验收id，获取整改及验收信息
     *
     * @param id
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月10日-下午2:50:03
     */
    ReformItemAcceptanceRecord getAcceptanceRecordById(Long id);


    /**
     * 删除整改与验收信息
     *
     * @param id           整改与验收ID
     * @param loginStaffId 登录用户ID
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月14日-上午11:57:26
     */
    void deleteAcceptanceRecord(Long id, Long loginStaffId);

    /**
     * 保存整改与验收结果信息
     *
     * @param entity 整改与验收结果
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月11日-下午4:31:52
     */
    ReformItemAcceptanceRecord saveReformItemAcceptanceRecord(ReformItemAcceptanceRecord entity, Long loginStaffId, Long cid, String status);

    /**
     * 仅仅保存整改验收信息，不做其他的相关也无处理，消息通知等。一半只有超级管理员编辑完成后的业务调用。
     *
     * @param entity
     * @param loginStaffId
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年12月29日-上午11:11:35
     */
    ReformItemAcceptanceRecord saveAcceptanceRecordOnly(ReformItemAcceptanceRecord entity, Long loginStaffId, Long cid, String statusType);


    PageInfo<ReformItemListVo> getUnfinishedReformItemPageByParam(JqGridParam param, ReformItemFinishedSeniorSearch search);

    PageInfo<ReformItemListVo> getFinishedReformItemPageByParam(JqGridParam param, ReformItemFinishedSeniorSearch search);

    /**
     * @ Description: <获取第三方机构整改列表>
     * @ Author XiaoYi
     * @ Date  2022/4/9  10:32
     * @ param
     * @ return
     **/
    PageInfo<ReformItemListVo> getReformItemPageByParamForThirdOrg(JqGridParam param, ReformItemThirdSearchVo search);
    /**
     * 机构端：管家风险列表（分页）
     * @param param 综合查询参数
     * @return {@link JqGridData<RiskReformGjListVo>}
     * @author liaoly
     * @date 2023/7/6 9:44
     */
    JqGridData<RiskReformGjListVo> getGjReformListDataForThirdOrg(RiskReformGjSearch param);

    /**
     * 其他模块业务完成的时候，更新整改项状态（显示在整改模块里面）
     *
     * @param businessId
     * @param loginStaffId
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年10月24日-下午3:16:26
     */
    void businessCompleteToUpdateReform(Long businessId, Long loginStaffId);


    /**
     * 根据整改项来源ID，获取分页信息
     *
     * @param cid
     * @param param
     * @param sourceId 来源ID
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月7日-上午11:29:58
     */
    PageInfo<ReformItemListVo> getReformItemPageBySourceId(Long cid, JqGridParam param, Long sourceId);

    /**
     * 高级查询已完成的隐患列表(分页)
     *
     * @param cid
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月16日-下午4:00:24
     */
    PageInfo<ReformItemListVo> getReformItemFinishedPageSenior(Long cid, JqGridParam param);


    /**
     * 高级查询已完成的隐患列表
     *
     * @param cid
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月5日-下午5:45:34
     */
    List<ReformItemBasic> getReformItemFinishedListSenior(Long cid, JqGridParam param);

    /**
     * 高级查询已完成的隐患列表——返回转换过后的列表
     *
     * @param cid
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年11月14日-下午3:27:46
     */
    List<ReformItemListVo> getReformItemFinishedListSeniorForVo(Long cid, JqGridParam param);

    /**
     * 获取完成整改的整改项列表（隐患排查检查表），包含整改及验收信息(获取整改项检查表内容，采用方法：getReformItemUnFinishedListForInspectionTable，2018年6月20)
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年10月18日-下午2:00:46
     */
    List<ReformItemBasic> getReformItemFinishedListForInspectionTable(Long cid);

    /**
     * 获取未完成整改的整改项列表（隐患排查检查表），包含整改及验收信息（2018年6月20日，晶晶要求修改）
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年6月20日-下午4:34:36
     */
    List<ReformItemBasic> getReformItemUnFinishedListForInspectionTable(Long cid);

    /**
     * 获取来源为危害因素的整改项列表
     *
     * @param cid      企业ID
     * @param pageNum  页码
     * @param pageSize 每页条数
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月15日-下午1:42:21
     */
    PageInfo<ReformItemListVo> getReformItemPageForHarmFactor(Long cid, Integer pageNum, Integer pageSize);

    /**
     * 获取完成整改的整改项数目（来源是危害因素检测, 不包括忽略的和已经复测的）
     *
     * @param cid 企业ID
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月22日-上午9:12:21
     */
    int getReformItemFinishedForHarmFactor(Long cid);

    /**
     * 获取关键工作待办事项VO信息
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月29日-上午10:27:20
     */
    ReformItemTodolistVO getTodoListVo(Long cid);

    /**
     * 根据年度查询汇总结果接口
     *
     * @param cid
     * @param year
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-9-1-上午10:09:17
     */
    BaseSummaryVO getSummaryData(Long cid, String year);


    /**
     * 根据来源ID，获取整改项数量
     *
     * @param sourceId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月29日-下午4:28:37
     */
    int getCountBySourceId(Long sourceId);

    /**
     * 方法描述:  根据风险来源统计风险数
     *
     * @param source ReformSourceLiteEnum.value
     * @return int
     * @author wuxq
     * @date 2023/4/6
     */
    int getCountBySource(Long source);

    /**
     * 获取指定年份，每月的整改项数量
     *
     * @param year
     * @param month
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年3月2日-上午11:58:29
     */
    ReformMonthCountSummaryVo getMonthCountByYear(int year, Long cid);

    /**
     * 获取现场检查对应的整改项列表
     *
     * @param sourceId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月7日-上午10:18:44
     */
    List<ReformItemBasic> getReformListBySourceId(Long sourceId);

    /**
     * 整改项进行复测后调用，在完成待复测列表中消失。
     *
     * @param reformId
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月16日-下午5:06:12
     */
    void reformItemRetest(Long reformId, Long loginStaffId);

    /**
     * 整改项进行复测的时候，忽略（不进行复测）。
     *
     * @param reformId     整改项ID
     * @param loginStaffId 当前登录用户
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月20日-上午9:50:12
     */
    void reformItemRetestIgnore(Long reformId, Long loginStaffId);

    /**
     * 整改项进行复测的时候，恢复。
     *
     * @param reformId
     * @param loginStaffId
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月20日-上午10:51:21
     */
    void reformItemRetestRecovery(Long reformId, Long loginStaffId);


    /**
     * 检测完成，添加整改项，待整改整改项数量（在危害因素检测模块存草稿的数据，危害因素检测里面点完成，已经到整改模块里面去了。不计算）
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月27日-上午10:35:50
     */
    int getReformCountHarmFactorDraff(Long cid);

    /**
     * 根据id，业务模块删除整改项信息
     *
     * @param id
     * @param loginStaffId
     * @param businessType
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年10月24日-上午10:47:59
     */
    void deleteByIdAndBusinessType(Long id, Long loginStaffId, BusinessTypeEnum businessType);

    /**
     * 根据年度字符串，获取企业的整改各等级的数量。
     *
     * @param yearStr
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月29日-下午5:30:38
     */
    ReformLevelCountSummaryVo getReformLevelCountSummaryByYear(String yearStr, Long cid);

    /**
     * 根据指定年份，获取企业的整改项的类型统计
     *
     * @param yearStr
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月30日-上午9:00:03
     */
    ReformTypeCountSummaryVo getReformTypeCountSummaryByYear(String yearStr, Long cid);

    /**
     * 根据指定年份，获取企业的隐患治理的来源统计
     *
     * @param yearStr
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月30日-下午1:27:19
     */
    ReformSourceCountSummaryVo getReformSourceCountSummaryByYear(String yearStr, Long cid);

    /**
     * 获取指定年份内，指定部门的每月整改完成数量、隐患数量
     *
     * @param yearStr 年份
     * @param cid     企业ID
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月30日-下午3:26:52
     */
    ReformMonthSummaryVo getReformMonthSummaryByYear(String yearStr, Long cid);

    /**
     * 部门隐患汇总信息（指定年份内，隐患发现时间，整改负责人所属的部门为指定部门）
     *
     * @param yearStr
     * @param cid
     * @param orgIds
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月31日-下午2:10:35
     */
    List<ReformOrgCountSummaryVo> getReformOrgCountSummaryByYear(String yearStr, Long cid, String orgIds);

    /**
     * 历年隐患趋势数汇总
     *
     * @param yearStartStr
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年1月31日-下午4:38:52
     */
    List<ReformTrendByYearSummaryVo> getReformTrendSummaryByYear(String yearStartStr, String yearEndStr, Long cid);

    /**
     * 获取统计查询的整改项分页信息
     *
     * @param search
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年2月1日-下午2:02:54
     */
    PageInfo<ReformItemListVo> getReformItemPageForSummary(ReformSearchVo search);

    /**
     * 来源ID的整改信息是否填写完成。
     *
     * @param sourceId
     * @param isAllowedEmpty 是否允许整改列表为空
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年3月5日-下午12:24:01
     */
    boolean isCompleteForSource(Long sourceId, boolean isAllowedEmpty);

    /**
     * 统计个数
     *
     * @param reformIds
     * @param finished
     * @return
     */
    Integer countByIdAndStatus(List<Long> reformIds, StatusEnum finished);

    //todo 2024.2.26已废弃
    ReformItemBasic generationReformFormOther(ReformGenerationSourceEnum source, Long businessId, String businessName, String reformMeasures,
                                              String location, String findName, Date findTime, Long cid, Long orgId, String fileIds, ReformSourceLiteEnum reformSourceLiteEnum);
    /**
     * 机构端单个生成整改项
     */
    ReformItemBasic generationReformToThirdPhysical(ReformGenerationSourceEnum source, Long businessId, String businessName, String reformMeasures,
                                                    String location, String findName, Date findTime, Long cid, Long orgId, String fileIds,
                                                    ReformSourceLiteEnum reformSourceLiteEnum, Byte dataSource, String tjBusinessId);

    /**
     * 万达仓批量生成整改项（无返回值）
     */
    void autoGenerationReform(List<ReformItemBasic> basicList, List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList,
                              ReformGenerationSourceEnum source, Long businessId, String businessName, String reformMeasures,
                              String location, String findName, Date findTime, Long cid, Long orgId, String fileIds,
                              ReformSourceLiteEnum reformSourceLiteEnum, Byte dataSource, String tjBusinessId);


    //todo 2024.2.26已废弃   服务管家的
    ReformItemBasic generationReformFormOther(ReformItemBasic param);


    //todo 2024.2.26已废弃 乡镇协管的
    Integer addXzxgReform(List<ReformAddParamXzxg> xzxgParam);

    Integer addSelfJudgeReform(List<OccupationalSelfJudgeTermV308> terms, Long businessId, String findName, Date findTime, Long cid);

    /**
     * @ Description: <根据整改项来源业务id获取整改结果>
     * @ Author XiaoYi
     * @ Date  2021/12/17  9:14
     * @ param
     * @ return 结果 1：整改中2被退回3已上报
     **/
    List<Map<Long, Byte>> getReformResultBySourceIds(List<Long> sourceIds);


    /**
     * @ Description: <根据整改项来源业务id查询职业禁忌症患者是否入职>
     * @ Author XiaoYi
     * @ Date  2021/12/17  9:14
     * @ param
     * @ return true 已入职
     **/
    List<Map<Long, Boolean>> getIsInductionBySourceIds(List<Long> sourceIds);

    /**
     * 获取整改结果
     *
     * @param sourceIds
     * @return soureceId -> 结果 1：整改中2被退回3已上报
     */
    Map<Long, Byte> getResult(List<Long> sourceIds);

    /**
     * @ Description: <获取待处置的整改项数量>
     * @ Author XiaoYi
     * @ Date  2021/12/17  9:46
     * @ param type参考 ReformGenerationSourceEnum
     * @ return
     **/
    Integer getUnFinishedNum(Long cid, Byte type);

    /**
     * @ Description: <获取已上报的整改项数量>
     * @ Author XiaoYi
     * @ Date  2021/12/17  9:46
     * @ param type参考 ReformGenerationSourceEnum
     * @ return
     **/
    Integer getFinishedNum(Long cid, Byte type);

    Map<Integer, Integer> getFinishedNumByGenerationSource(Long cid);


    Map<Integer, Integer> getUnFinishedNumByGenerationSource(Long cid);

    /**
     * @ Description: <获取整改超时数量>
     * @ Author XiaoYi
     * @ Date  2022/2/28  11:04
     * @ param
     * @ return
     **/
    Integer getReformTimeOutNum(Long cid);


    /**
     * @ Description: <小程序整改列表>
     * @ Author XiaoYi
     * @ Date  2022/3/25  15:34
     * @ param
     * @ return
     **/
    PageInfo<AppReformItemListVo> getReformItemPageInfoForApp(PageParamModel param);


    /**
     * @ Description: <整改未到位，新增整改项>
     * @ Author XiaoYi
     * @ Date  2022/3/4  12:10
     * @ param
     * @ return
     **/
    ReformItemBasic addReformInfoNotInPlace(Long reformId);

    /**
     * @ Description: <机构端验收>
     * @ Author XiaoYi
     * @ Date  2022/4/15  14:39
     * @ param
     * @ return
     **/
    void thirdOrgAcceptance(ReformItemBasic reform, Long userId, String userName, String orgName);

    /**
     * @ Description: <获取机构整改超期数量>
     * @ Author XiaoYi
     * @ Date  2022/4/13  9:17
     * @ param
     * @ return
     **/
    Integer getReformOverdueNum(Long orgId);


    /**
     * @ Description: <获取机构待验收数量>
     * @ Author XiaoYi
     * @ Date  2022/4/13  9:17
     * @ param
     * @ return
     **/
    Integer getTobeAcceptanceNum(Long orgId);

    List<MobileReformItemListVo> getReformOverdueList(Long orgId, String name);

    PageInfo<MobileReformItemListVo> getReformOverduePage(PageParamModel param, Long orgId, String name);

    List<MobileReformItemListVo> getTobeAcceptanceList(Long orgId, String name);

    PageInfo<MobileReformItemListVo> getTobeAcceptancePage(PageParamModel param, Long orgId, String name);

    PageInfo<MobileReformItemListVo> getTrustInfoReformList(PageParamModel gparam, TrusteeshipInfoParam param);

    /**
     * @ Description: <根据托管排查id获取隐患列表>
     * @ Author XiaoYi
     * @ Date  2022/4/14  10:49
     * @ param
     * @ return
     **/
    List<MobileReformItemListVo> getReformListByTrusteeshipId(Long trusteeshipId);

    /**
     * @ Description: <获取机构发现隐患数量>
     * @ Author XiaoYi
     * @ Date  2022/4/19  15:12
     * @ param
     * @ return
     **/
    Integer getFindReformNumByOrg(Long orgId, Integer year, Integer quarter);

    /**
     * @ Description: <获取机构验收隐患数量>
     * @ Author XiaoYi
     * @ Date  2022/4/19  15:12
     * @ param
     * @ return
     **/
    Integer getAcceptanceReformNumByOrg(Long orgId, Integer year, Integer quarter);

    /**
     * @ Description: <获取企业整改未完成的最小整改期限时间：判断整改超期>
     * @ Author XiaoYi
     * @ Date  2022/4/13  14:45
     * @ param
     * @ return
     **/
    Date getMinAcceptanceTime(Long cid);

    void deleteReformInfoBySourceId(Long sourceId);

    void subReformByTrusteeshipId(Long trusteeshipId);

    /**
     * 根据sourceId删除整改项
     *
     * @param sourceId
     */
    void removeReformBySourceId(Long sourceId);


    //================================================================================================================

    /**
     * 方法描述:  根据风险整改id查询详情（企业信息、风险详情、风险整改验收记录）
     *
     * @param id ReformItemBasic.id
     * @return ReformItemDetailVo
     * @author wuxq
     * @date 2023/3/9
     */
    ReformItemDetailVo getReformItemDetailVoById(Long id);

    /**
     * 监管端风险详情页 根据风险整改id获取表格栏
     *
     * @param reformId
     * @return
     */
    List<ReformTableListVo> getTabList(Long reformId);

    /**
     * 方法描述:  根据企业id查 简要企业基础信息
     *
     * @param cid 企业id
     * @return SimpleCompanyInfoVo
     * @author wuxq
     * @date 2023/3/13
     */
    SimpleCompanyInfoVo getSimpleCompanyInfoVoById(Long cid);

    /**
     * 巡查整改管理
     */
    PageInfo<RiskListItemDataVo> getTownShipRiskListData(JqGridParam param, RiskListSearch search);

    ReformItemBasic getRiskListDataToArchive(JqGridParam param, RiskListSearch search, Boolean count);

    /**
     * 方法描述:  风险化解率统计（查当前账号区域下级）
     *
     * @param param 查询参数对象
     * @return PageInfo<RiskSolveRateStatisticVo>
     * @author wuxq
     * @date 2023/3/14
     */
    PageInfo<RiskSolveRateStatisticVo> riskSolveRateListData(RiskSolveRateSearchParam param);

    /**
     * 方法描述:  风险化解率统计（查当前账号区域）
     *
     * @param param 查询参数对象
     * @return RiskSolveRateStatisticVo
     * @author wuxq
     * @date 2023/3/14
     */
    RiskSolveRateStatisticVo riskSolveRateTotalData(RiskSolveRateSearchParam param);

    /**
     * 方法描述:  乡镇协管巡查整改率（查当前账号区域）
     *
     * @param param 查询参数对象
     * @return RiskSolveRateStatisticVo
     * @author wuxq
     * @date 2023/3/14
     */
    ReformRateStatisticVo reformRateTotalData(RiskSolveRateSearchParam param);
    ReformRateStatisticVo reformRateTotalDataBackup(RiskSolveRateSearchParam param);

    /**
     * 方法描述:  乡镇协管巡查整改率
     *
     * @param param 查询参数对象
     * @return PageInfo<RiskSolveRateStatisticVo>
     * @author wuxq
     * @date 2023/4/6
     */
    List<ReformRateStatisticVo> reformRateStatisticListData(RiskSolveRateSearchParam param);
    List<ReformRateStatisticVo> reformRateStatisticListDataBackup(RiskSolveRateSearchParam param);

    /**
     * 根据ID获取整改基础信息
     *
     * @param search
     * @return
     */
    RiskInfoDataVo getRiskInfo(RiskListSearch search);

    /**
     * 监管端-风险整改列表数据
     *
     * @param jParam   j参数
     * @param searchVo 搜索
     * @return {@code PageInfo<RiskReformVo> }
     * @author zhangxu
     * @date 2023-03-15
     */
    PageInfo<RiskReformVo> getRiskReformListData(JqGridParam jParam, RiskReformSearchVo searchVo);
    PageInfo<RiskReformVo> getPageRiskReform(JqGridParam jParam, RiskReformSearchVo searchVo);
    List<RiskReformVo> getListRiskReform(RiskReformSearchVo searchVo);
    Integer getCountRiskReform(RiskReformSearchVo searchVo);


    /**
     * 按条件获取发现年份
     *
     * @param searchVo
     * @return {@code List<Integer> }
     * @author zhangxu
     * @date 2023-03-23
     */
    List<Integer> getFindYearBySearchVo(RiskReformSearchVo searchVo);

    /**
     * 查询企业是否有未整改的整改项
     *
     * @param cid
     * @param source ReformSourceLiteEnum
     * @return
     */
    Boolean hasNotReformItem(Long cid, Byte source);

    /**
     * 根据cid获取所有整改的整改来源数据
     *
     * @param cidList
     * @return
     */
    List<RiskSource> getAllReformItemByCid(List<String> cidList);

    /**
     * @description: 获取三同时 需要整改的cid列表
     * @version: 3.2.2.2
     * @date: 2023/6/26 13:54
     * @param: cidList 企业id列表
     * @return: {@link List<Long>}
     * @author: DengJia 18402894534@163.com
     */
    List<Long> getThreeTimeReformByCid(List<Long> cidList);

    /**
     * 根据ID获取多个数据源的整改信息
     *
     * @param search
     * @return
     */
    ReformItemBasic getMultipleDataSourceBySearch(RiskListSearch search);


    /**
     * 根据某个整改项获取该批次的所有数据来源
     * 获取多种数据源整改数据（生成整改个审核时可以调用）
     *
     * 多数据来源的多条：同一个数据来源且类型相同，未完成的最多只有一条，不同数据来源类型可以多条
     * 多数据来源的单条：可以生成多个相同来源和类型的
     * @param reform
     * @param type 0 获取所有风险来源数据，不做过滤
     *             1 获取除乡镇协管外所有风险来源的数据，乡镇协管只取最新一条数据
     *             2 只获取乡镇协管这条数据
     * @return
     */
    List<ReformItemBasic> getReformItemSourceList(ReformItemBasic reform, Integer type);

    /**
     * 根据年份统计整改数量（暂时不统计乡镇协管，只查八项）
     *
     * @param year
     * @return
     */
    int countNumByYear(Long cid,int year);

    /**
     * 分页 获取 cid 和status
     *
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<ReformItemBasic> getCidAndStatusListPage(int pageNum, int pageSize, int year);


    List<ReformItemBasic> getCidAndStatusList(Long cid, int year);


    /**
     * 风险化解清单导出
     * @param searchParam
     * @return
     */
    List<RiskResolveResInfoVo> exportListData(RiskResolveResSearch searchParam);

    /**
     * @description: 各行政区划风险数量统计
     * @version: VERSION
     * @date: 2023/9/6 15:45
     * @param: searchParam
     * @return: {@link PageInfo<RegionRiskNumInfoVo>}
     * @author: DengJia 18402894534@163.com
     */
    PageInfo<RegionRiskStatisticsVo> areaRiskNumCountListDataOptimize(RiskResolveResSearch searchParam);

    /**
     * @description: 用人单位负责人培训，数据统计表。
     * @version: V1
     * @date: 2025-03-25 14:52
     * @param: 传参说明：
     * 		pageParam -> 分页参数
     * 		searchParam -> 条件入参
     * @return: {@link JqGridData<TrainCompanyStaffModel>} 用人单位负责人培训，数据统计表，分页数据。
     * @author: DengJia 18402894534@163.com
     */
    PageInfo<Map<Long, List<TrainCompanyStaffModel>>> getRegionTrainCompanyStaffPage(JqGridParam page, TrainCompanyStaffModel param);

    /**
     * @description: 行政区划风险数量 结果导出
     * @version: VERSION
     * @date: 2023/9/6 20:04
     * @param: searchParam
     * @return: {@link List<RegionRiskNumInfoVo>}
     * @author: DengJia 18402894534@163.com
     */
    List<RegionRiskNumInfoVo> exportAreaRiskNumCountListData(RiskResolveResSearch searchParam);

    /**
     * 查询避免行政处罚经济账，历史统计数据，目前主要是为统计：对应年份累计避免行政处罚额度。
     *
     * @param param 入参
     * @return 历史记录，避免行政处罚经济账统计数据。
     */
    List<RegionHistoryPunishInfo> getHistoryPunishInfo(RegionHistoryPunishInfo param);

    /**
     * 实时+今年上半年的：已化解风险企业数。（下半年的情况会调用到此方法）
     * @return 已化解风险企业数
     */
    Long getCurrentAndPreHalfResolveNum(RiskResolveResSearch searchParam, int currentYear);

    /**
     * 获取行政区划已化解风险企业数（查询全部数据或指定year时间范围）
     *
     * @param param areaId 行政区划id
     *              year     时间范围（如：2023,获取2023年区域已化解风险企业数；202401,获取2024上半年年区域已化解风险企业数。）
     * @return 已化解风险企业数
     */
    Long getRegionResolveComNumByCache(RiskResolveResSearch searchParam);

    // 需传入6位年份标识
    Long getRegionResolveComNum(RiskResolveResSearch searchParam);

    RegionRiskNumInfoVo getRegionResolveComNums(RiskResolveResSearch searchParam);

    /**
     * 获取行政区划未推送风险企业数
     */
    Long getRegionNoPushComNum(RiskResolveResSearch searchParam);

    /**
     * 风险化解结果验收-监管端-详情页 切换风险来源后，风险信息要发生对应变更，而整改和验收信息不变
     *  详情右边风险化解详情数据（监管的画像风险列表和服务管家都在用，机构端的列表详情也在用）
     * @param
     * @param id         整改id
     * @return RiskResolveResInfoVo
     */
    RiskResolveResInfoVo getReformRiskDetailVoById(Long id);

    /**
     * 获取示警企业数
     *
     * @param search
     * @return
     */
    ReformWarningStatistics getWarningComNum(RiskListSearch search);

    /**
     * 统计某区域企业风险信息和示警状态
     *
     * @return java.util.List<cn.smarthse.modules.health.entity.base.company.CompanyWarningStatusList>
     * @author 覃浩云 1770126791@qq.com
     * @date 2023/5/12 17:49
     */
    List<RiskWarningModel> staticAreaRiskInfo(List<Long> cids);

    /**
     * @description: 统计单家企业的示警状态信息
     * @version: 3.2.2.1
     * @date: 2023/5/26 18:42
     * @param: cid 单家企业id
     * @return: {@link List<ReformItemBasic>}
     * @author: DengJia 18402894534@163.com
     */
    List<ReformItemBasic> obtainCompanyRiskInfoByCid(Long cid);

    /**
     * @description: 清空之前企业示警状态清单数据
     * @version: 3.2.2.1
     * @date: 2023/5/26 18:39
     * @param: cid 企业id
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    void emptyCompanyRiskInfoByCid(Long cid);

    /**
     * 分类统计待验收风险数量
     *
     * @param searchVo searchParam
     * @return cn.smarthse.modules.health.vo.riskResolve.RiskResolveInfoVo
     * @author 覃浩云 1770126791@qq.com
     * @date 2023/5/16 13:29
     */
    RiskResolveInfoVo countWaitAcceptNum(KeyFactoryScoreParam searchVo);

    /**
     * 监管端 “三同时”进行中项目清单 数据
     *
     * @param param
     * @return
     */
    LayUiResponseResult<ThreeTimesInfo> getThreeTimesInfo(SearchParam param);

    /**
     * 获取待验收的整改数量
     *
     * @param cid
     * @return
     */
    Integer getUnReformNumByCid(Long cid, ReformGenerationSourceEnum sourceEnum);

    /**
     * @param cid
     * @param sourceEnum
     * @return java.util.List<cn.smarthse.modules.health.entity.work.reform.ReformItemBasic>
     * @Comments: <档案获取 整改数据， >
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/5/18-16:29
     */
    public List<ReformItemBasic> getArchiveData(Long cid, ReformGenerationSourceEnum sourceEnum);

    List<Byte> getGenerationSourceValue();


    /**
     * @description: 查询关键因素的风险状态（风险报表）
     * @version: VERSION
     * @date: 2024/1/25 16:05
     * @param: cid 企业id
     * @return: {@link List<KeyFactoryStateVo>} 关键因素状态
     * @author: DengJia 18402894534@163.com
     */
    List<KeyFactoryStateVo> getKeyFactorPortraitDataList(Long cid);

    /**
     * @description: 企业端可视化首页 查询三同时项目 数据详情
     * @version: 3.2.2.1
     * @date: 2023/05/17 15:58:34
     * @param: cid 企业id
     * @return: cn.smarthse.modules.health.vo.work.keyFactory.ThreeTimeDetailVo
     * @author: 邓佳 18402894534@163.com
     */
    ThreeTimeDetailVo getThreeTimeProjDetails(Long cid);

    List<HealthManagementArchiveVo> getHealthManagementArchivesData(Long cid);

    /**
     * @description: 企业端可视化首页 风险化解管理 获取风险等级 列表数据
     * 调接口获取整改数据（未化解风险的 以及 已化解风险的数据），
     * 将他们合并在一起统计各个风险等级出现的次数，并且最终转换为RiskLevelVo类型的数据进行返回。
     *      - 首次预警 画像不完整（有风险） 2个月内
     *      - 黄色预警 2个月后 未完成整改
     *      - 红色预警 黄色预警 1个月后 未完成整改
     *      - 启动执法 红色预警 1个月后 未完成整改
     *
     * @version: 3.2.2.1
     * @date: 2023/05/17 15:59:24
     * @param: cid 企业id
     * @return: java.util.List<cn.smarthse.modules.health.vo.work.reform.RiskLevelVo>
     * @author: 邓佳 18402894534@163.com
     */
    List<RiskLevelVo> getRiskLevelListData(Long cid);

    /**
     * @description: 企业端可视化首页 风险化解管理 查询不同类型的风险的列表数据 （实时查询）
     * cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService#selectRiskTypeListData(java.util.List) （报表查询，可以批量）
     * @version: 3.2.2.1
     * @date: 2023/05/17 15:59:50
     * @param: cid 企业id
     * @return: java.util.List<cn.smarthse.modules.health.vo.work.reform.RiskTypeVo>
     * @author: 邓佳 18402894534@163.com
     */
    List<RiskTypeVo> getRiskTypeListData(Long cid);

    /**
     * @description: 获取当前企业 现有风险数
     * @version: 3.2.2.1
     * @date: 2023/5/27 14:50
     * @param: cid 企业id
     * @return: {@link Long}
     * @author: DengJia 18402894534@163.com
     */
    Long obtainNowComRiskNum(Long cid);

    /**
     * 企业申报风险生成，分类对象但是不是申报企业的（2023今年临时使用）
     *
     * @param cids cid
     */
    void autoGenDeclReform(String cids);

    /**
     * 查询企业的负责人培训相关整改项信息
     * @param cid cid
     * @return 负责人培训整改信息
     */
    List<ReformItemBasic> getTrainReformByCid(Long cid);


    List<ReformItemBasic> getReformItemBasicList(List<Long> cids);

    /**
     * 获取整改
     * @param ems
     * @param cid
     */
    List<ReformItemBasic> getInfoByReformGenerationSource(List<ReformGenerationSourceEnum> ems,Long cid,Integer year);


    List<ReformItemBasic> lastApproveReform(Date updateDate);

    /**
     * 得到警告或个人防护时间
     *
     * @param reformItemBasic 改革项目基本
     * @return {@link Date}
     */
    Date getWarnOrProtectTime(ReformItemBasic reformItemBasic);

    /**
     * 三同时风险状态修改状态更改(有退回风险为退回，其次待审核为待审核，全部已完成则为已完成)
     *
     * @param cids id
     */
    void threeTimeStatusChange(String cids);


    /**
     * 获取最后一次体检/检测机构信息
     * @param cids
     * @return
     */
    List<ReformLastOrgInfo> getLastOrgInfo(List<Long> cids);

    /**
     * 查询检测风险已化解，但是没有检测数据的企业数（非自动验收的企业数）
     * @param areaId
     * @return
     */
    Integer getDefuseCheckNotDataNum(Long areaId);


    /**
     * 获取已推送风险的企业id
     * @return
     */
    List<Long> getPushedCids();

    //todo ------------------------------------------风险目前常用的接口--------------------------------------

    /**
     * 自动生成关键因素画像整改
     * @param cids
     */
    void autoGenKeyFactorReform(String cids);
    List<ReformItemBasic> commitBatchGenKeyReform(List<Long> cidList, Date findDate);

    /**
     * 关键因素画像自动验收接口(多数据源或单个数据源都可以用)
     * @param cids
     * @author zhangxu
     * @date 2024-01-26
     */
    void autoAcceptance(String cids) throws Exception;
    List<ReformItemBasic> acceptDivide(List<Long> cidList,Byte generationSource,Integer year,Integer type);

    /**
     * 上传画像验收风险
     * 培训的调用没改，验收的时候应该每个状态都掉
     * SyncTrainInfoServiceImpl培训同步没用
     * @param cid
     * @param generationSource
     */
    void changeStatusByCidAndGenerationSource(Long cid, Byte generationSource, Byte status, Long loginStaffId, Long businessId);

    /**
     * 手动填写整改信息整改
     * @param entity
     * @param loginStaffId
     * @return {@code ReformItemBasic }
     * @author zhangxu
     * @date 2024-01-29
     */
    ReformItemBasic saveGenerationReform(ReformItemBasic entity, Long loginStaffId);

    /**
     * 监管风险整改验收
     *
     * @param param
     */
    void reformRecordAcceptance(ReformRecordAcceptanceParam param);

    /**
     * 2024.2.27企业端风险列表查询
     * @param param
     * @param search
     * @param count      是否要返回总数
     * @param searchType searchType：0-重点风险 1-非重点风险
     * @return
     */
    PageInfo<RiskListItemDataVo> getRiskListDataPage(JqGridParam param, RiskListSearch search, Boolean count, Integer searchType);

    List<RiskListItemDataVo> getRiskListData(RiskListSearch search,Integer searchType);

    /**
     * 方法描述: 2024.2.27监管端风险列表查询（服务管家和画像风险列表都在用）
     *  searchVo.reformSource 如果不为空，查来源都需要搞清楚显示几条，查baisc还是source，包含那些来源 reform_item_source_mult
     *
     *  每次大调整修改一下注释，这里面很乱
     * @param searchParam //区域 areaId和areaLevel 示警状态 warningState 整改状态 reformStatus 风险类型 generation_source
     * @return List<RiskResolveResInfoVo>
     */
    PageInfo<RiskResolveResInfoVo> getReformRiskResolveResList(RiskResolveResSearch searchParam);
    Integer getReformRiskResolveResListCount(RiskResolveResSearch searchParam);
    //todo ------------------------------------------风险目前常用的接口--------------------------------------

    public List<ReformItemListVo> countReformCompletedGenerateSource(List<Long> cidList,List<Integer> generationSources);
}
