package cn.smarthse.modules.health.service.work.reform;


import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformAcceptanceRecordVo;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.vo.riskResolve.RiskResolveInfoVo;
import cn.smarthse.modules.health.vo.work.reform.ReformAddParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 整改生成重构
 * @author zhangxu
 * @date 2023/10/31
 */
public interface IReformItemBasicNewService extends IBaseService<ReformItemBasic> {

    ReformItemBasic getByIdAndRecordDetail(Long id);

    /**
     * 所有生成风险的统一接口（单一风险来源时，查询最大数量 大致 是addParamList，多数据源，几个数据源 大致 就是几倍addParamList，注意内存溢出）
     * 特殊三同时：如果最新一份是已化解需要生成一个新的，并且只生成一个最新的，其余来源的往里面合并
     * 只有八大项风险是在该接口中判断是否已存在整改，有就不生成了，其余都是进来多少生成多少
     * @param addParamList 去重了的需要生成的风险集合
     * @return {@code Integer }
     * @author zhangxu
     * @date 2024-02-19
     */
    Integer generateReform(List<ReformAddParam> addParamList);

    /**
     * 自动生成检测超标整改（暴露风险那边就是直接实时的?好像没有加那边的了）
     * @param cids
     * @author zhangxu
     * @date 2024-02-22
     */
    void autoAddReformByCheck(String cids);
    void generateBackData(String ids);
    /**
     * 定期检测和现状风险
     * @param cids
     * @author zhangxu
     * @date 2024-12-31
     */
    void autoAddReformByCheckChild(String cids);

    /**
     * 进行整改，验收整改
     * @param entity
     * @param loginStaffId
     * @return {@code ReformItemBasic }
     * @author zhangxu
     * @date 2024-02-19
     */
    ReformItemBasic saveOrSubmitReform(ReformItemBasic entity, Long loginStaffId);

    /**
     * 关键因素画像自动验收接口(多数据源或单个数据源都可以用)
     * @param cids
     * @author zhangxu
     * @date 2024-01-26
     */
    void autoAcceptance(String cids) throws Exception;
    /**
     * 单个自动验收接口(多数据源或单个数据源都可以用)
     * 不是通过佐证材料，通过上传有效画像都可以走这个验收接口
     * @param cidList
     * @param generationSource
     * @param year 那一年的风险
     * @return {@code List<ReformItemBasic> }
     * @author zhangxu
     * @date 2024-01-26
     */
    List<ReformItemBasic> acceptDivide(List<Long> cidList,Byte generationSource,Integer year);


    void autoGenKeyFactorReform(String cids);//自动生成关键因素画像整改
    Integer divideBatchGenKeyReform(List<Long> cidList, Byte generationSource, Integer year, Byte dataSource);//自动生成关键因素画像整改--逐项
    void onlyFileAcceptReformAfterTwoMonth(String cids);//仅作证材料化解两个月后推送风险
    void genKeyFactorReformNewCompany(String cids);//新建企业点击完成推送5大新建企业风险

    List<Long> getZjArchiveCountViewByCid(List<Long> cidList, Integer year);

    /**
     * 上传画像验收风险
     * 培训的调用没改，验收的时候应该每个状态都掉
     * SyncTrainInfoServiceImpl培训同步没用
     * @param cid
     * @param generationSource
     */
    void changeStatusByCidAndGenerationSource(Long cid, Byte generationSource, Byte status, Long loginStaffId, Long businessId);

    /**
     * 批量设置风险状态为中止
     *
     * @param reformIds
     * @author zhangxu
     * @date 2024-07-30
     */
    void setPauseStatus(List<Long> reformIds);

    /**
     * 可视化首页-审核工作提示，2024年推送的未化解风险个数（根据风险类型计数）
     * @param searchVo
     * @return
     */
    RiskResolveInfoVo getNoResolvedNum(SearchParam searchVo);

    /**
     * 可视化首页-审核工作提示，24年未审核风险统计
     * @param searchVo
     * @return
     */
    List<RiskResolveInfoVo> getRiskCountList(SearchParam searchVo);

    /**
     * 根据TjBusinessId 查询风险
     * @param tjIds
     * @return
     */
    List<ReformItemBasic> getListByTjBusinessIds(List<String> tjIds);

    /**
     * 获取体检异常风险数据（疑似职业病，职业禁忌症风险）
     * @param cids
     * @return
     */
    List<ReformItemBasic> getPhysicalAbnormalReform(List<Long> cids,Integer year);

    /**
     * 查询未化解的风险数据
     * @param cids
     * @param generationSources
     * @param year
     * @return
     */
    List<ReformItemBasic> queryNotAccReform(List<Long> cids,List<Byte> generationSources,Integer year);

    /**
     * 获取超标风险的对应暴露风险id
     * @param cidList
     * @param paramMap
     * @return {@code List<ReformItemBasic> }
     * @author zhangxu
     * @date 2024-06-25
     */
    Set<Long> getReformOverCheckRiskId(List<Long> cidList, Map<String,Object> paramMap);
    Set<Long> getReformOverCheckRiskId2(List<Long> checkPlanIdList, Map<String,Object> paramMap);

    /**
     * 企业端--获取风险化解验收记录
     * @param reformId
     * @param acceptanceId
     * @param map
     * @return {@code ReformAcceptanceRecordVo }
     * @author zhangxu
     * @date 2024-10-16
     */
    ReformAcceptanceRecordVo getReformAcceptanceRecordToHse(Long reformId, Long acceptanceId, Map<String,String> map);

    /**
     * 企业端--整改风险
     *
     * @param reformItem
     * @param loginStaffId
     * @param map
     * @return {@code ReformItemBasic }
     * @author zhangxu
     * @date 2024-10-16
     */
    ReformItemBasic saveGenerationAccToHes(ReformItemBasic reformItem, Long loginStaffId,Map<String,String> map);

    void deleteReform(List<Long> cidList, List<Byte> generationSources, List<Long> idList);

    //重新推送已经中止的检测体检异常风险（一次性接口）
    void pushPhyAndCheckAbnormalReform(Long id);
}
