/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.reform.ReformCheckMeasure;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Set;


/**
 * 
 * 《ReformItemAcceptanceRecordService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 01:30
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IReformItemAcceptanceRecordService extends IBaseService<ReformItemAcceptanceRecord>{


	/**
	 * 根据整改项ID，获取整改与验收的列表信息，按照创建时间排序(顺序)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月10日-下午3:15:47
	 * @param reformItemId 整改项ID
	 * @return
	 */
	List<ReformItemAcceptanceRecord> getListByReformItemId(Long reformItemId);
	
	/**
	 * 保存整改与验收信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月7日-下午2:38:32
	 * @param entity
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	ReformItemAcceptanceRecord saveAcceptanceInfo(ReformItemAcceptanceRecord entity,Long loginStaffId,Long cid);
	
	/**
	 * 获取企业的整改与验收信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年5月25日-下午5:37:34
	 * @param cid
	 * @return
	 */
	List<ReformItemAcceptanceRecord> getListByCid(Long cid);


	void deleteByReformId(Long reformItemId);


	 Integer addRecordList(List<ReformItemAcceptanceRecord> records);

     List<ReformItemAcceptanceRecord> getListByReformItemIds(Set<Long> idSet);

	/**
	 * 保存或更新 超标整改的整改措施
	 *
	 * @param checkMeasure 检查测量
	 * @return {@link String}
	 */
	ReformCheckMeasure updateReformCheckMeasureByDetail(ReformCheckMeasure checkMeasure);

	Integer updateBatchReformCheckMeasure(List<ReformCheckMeasure> updateList);

	Integer saveBatchReformCheckMeasure(List<ReformCheckMeasure> addList);

	/**
	 *  批量新增 超标整改的整改措施
	 * @param list
	 * @return {@code Integer }
	 * @author zhangxu
	 * @date 2024-02-22
	 */
	Integer insertReformCheckMeasureList(List<ReformCheckMeasure> list);
	/**
	 * 通过验收表id 查询 超标整改的整改措施
	 *
	 * @return {@link List}<{@link ReformCheckMeasure}>
	 */
	List<ReformCheckMeasure> getReformCheckMeasureList(ReformCheckMeasure checkMeasure);
	PageInfo<ReformCheckMeasure> getPageReformCheckMeasureList(JqGridParam jqGridParam, ReformCheckMeasure checkMeasure);

	Integer deleteReformCheckMeasure(Long checkMeasureId);
}
