package cn.smarthse.modules.health.service.work.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ComRiskCompletionStatisticsVo;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyCheckRiskCompletion;
import cn.smarthse.modules.health.entity.work.reform.vo.CompanyRiskCompletion;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeSubjectPerformsVo;
import cn.smarthse.modules.health.supervise.model.keyFactory.KeyFactoryScoreInfo;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;

public interface ICompanyRiskCompletionService extends IBaseService<CompanyRiskCompletion> {


    /**
     * 生成风险化解完成情况--定时任务
     *
     * @param idList 企业cid字符串逗号连接   ids为空查询所有，不为空只更新相应部分
     * @author zhangxu
     * @date 2023-05-18
     */
    void generateCompanyRiskCompletion(List<Long> idList,Boolean flag);
    Integer insertCompanyRiskCompletion(List<CompanyRiskCompletion> list);
    void supplyRefreshCompliance();//补充刷新合规


    /**
     * 更新风险化解完成情况--定时任务（根据风险化解时间去刷新部分数据）
     *
     * @author zhangxu
     * @date 2023-07-27
     */
    void updateCompanyRiskCompletion(List<Long> cidList,Boolean refresh);
    /**
     * 根据cid获取企业风险完成情况（报表查询）
     * 需要获取准确数据可以先刷新
     * 根据cid刷新刷新报表：generateCompanyRiskCompletion 根据修改时间判断是否需要刷新：updateCompanyRiskCompletion
     * 类似接口 cn.smarthse.modules.health.service.work.reform.IReformItemBasicService#selectRiskTypeListData(java.lang.Long) （实时查询）
     *
     * @param cidList
     * @param isBack
     * @return {@code List<RiskTypeVo> }
     * @author zhangxu
     * @date 2024-04-19
     */
    List<RiskTypeVo> selectRiskTypeListData(List<Long> cidList, boolean isBack);
    /**
     * 生成风险化解完成情况--定时任务（间隔一会就去查询已修改的数据，然后更新）
     *
     * @author zhangxu
     * @date 2023-07-27
     */

    /**
     * 各企业风险完成情况
     *
     * @param jqGridParam 金桥网格参数
     * @param searchParam 搜索参数
     * @return {@link PageInfo}<{@link CompanyRiskCompletion}>
     */
    PageInfo<CompanyRiskCompletion> getPageCompanyRiskCompletionBySearchModel(JqGridParam jqGridParam, CompanyRiskCompletion searchParam);
    List<CompanyRiskCompletion> getCompanyRiskCompletionBySearchModel(CompanyRiskCompletion searchModel);

    /**
     * 风险存在未化解的“接害人数>3人或无数据+正常营业+历年分类对象”企业
     *
     * @return {@code List<Long> }
     * @author zhangxu
     * @date 2025-01-09
     */
    List<Long> getUnresolvedAssessCompanyIds(List<Long> cidList);

    /**
     * 获得 风险 数据更新时间
     *
     * @param areaLevle 区域层
     * @param areaId    区域id
     * @return {@code Date }
     * @author zhangxu
     * @date 2023-07-26
     */
    Date getCompanyRiskCompletionMaxTime(Byte areaLevle, Long areaId);

    /**
     * 仅上传佐证材料化解风险企业清单--头部数据
     *
     * @param searchParam
     * @return {@link CompanyCheckRiskCompletion}
     */
    CompanyCheckRiskCompletion checkRiskCompletedHeadData(RiskResolveResSearch searchParam);

    /**
     * 仅上传佐证材料化解风险企业清单--列表数据
     *
     * @param searchParam
     * @return {@link List}<{@link CompanyCheckRiskCompletion}>
     */
    List<CompanyCheckRiskCompletion> checkRiskCompletedListData(RiskResolveResSearch searchParam);
    PageInfo<CompanyCheckRiskCompletion> checkRiskCompletedListPageData(JqGridParam jqGridParam, RiskResolveResSearch searchParam);

    /**
     * 首页可视化 - 主题履职 新版
     * @param searchVo
     * @return {@link HomeSubjectPerformsVo}
     */
    HomeSubjectPerformsVo getData5(HomeIndexSearchVo searchVo);

    /**
     * 首页可视化-卫企风控-单项风险完成情况 (2024.5.10 基本荒废了)
     */
    KeyFactoryScoreInfo countCompanyRiskCompletionNumByType(CompanyRiskCompletion searchModel);

    /**
     * 获取8项风险企业完成情况
     * @param searchModel
     * @return {@code ComRiskCompletionStatisticsVo }
     * @author zhangxu
     * @date 2024-05-10
     */
    ComRiskCompletionStatisticsVo getComRiskCompletionStatisticsVo(CompanyRiskCompletion searchModel);
}
