/**
 * 
 */
package cn.smarthse.modules.health.service.work.planyear;

import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;

/**
 * 《年度计划>计划实施同步接口定义》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-7-3-下午4:51:07
 */
public interface IPlanYearWorkService {

	/**
	 * 年度计划(补录)同步创建工作
	 * <li>由以下业务模块Service创建（第一阶段，存草稿）工作。
	 * <li>【职业健康监护】、【个人剂量监测】、【教育培训】、【职业病危害因素检测】、【职业卫生现场检查】、【应急演练】、【防护用品需求调查】、【危化品普查】、【法律法规标准需求调查】，必须返回业务主表ID
	 * <li>其他关联到此接口的Service无需具体实现。
	 * @param detail	年度计划详情对象
	 * @return	业务模块主表ID
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 */
	Long syncAddPlanYearByBL(PlanYearSyncSO detail);
	
	/**
	 * 年度计划(日常)同步创建工作
	 * <li>由以下业务模块Service创建（第一阶段，存草稿）工作。
	 * <li>【职业健康监护】、【个人剂量监测】、【教育培训】、【职业病危害因素检测】、【职业卫生现场检查】、【应急演练】、【防护用品需求调查】、【危化品普查】、【法律法规标准需求调查】，必须返回业务主表ID
	 * <li> 2.0只需要实现补录接口
	 * @param detail	年度计划详情对象
	 * @return	业务模块主表ID
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 */
//	Long syncAddPlanYearByDD(PlanYearSyncSO detail);
}
