/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.planyear;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.vo.work.yearplan.PlanYearWorkItemVO;

import java.util.List;

import com.github.pagehelper.PageInfo;


 /**
 * 
 * 《IPlanYearService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-06-08 14:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPlanYearService extends IBaseService<PlanYear>{

	//根据param查询年度计划
	PageInfo<PlanYear> getPlanYearListByGridParam(JqGridParam gparam);
	
	//根据cid查询计划已完成清单
	PageInfo<PlanYear> getPlanCompleteListByCid(JqGridParam gparam);
	
	//根据cid查询总结已完成清单
	PageInfo<PlanYear> getSummaryCompleteListByCid(JqGridParam gparam);
	
	/**
	 * 关键工作接口(传入cid,返回年度计划计划中与待总结数量以及是否距离上一次年度计划有一年时间)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐颖东 [xyd.900919@qq.com]
	 * @since 2017-8-22-上午10:57:23
	 * @param cid		企业编号
	 * @return	PlanYearWorkItemVO(年度计划-计划中size,年度计划-待总结size,  距离上一次年度计划是否超过一年(true-超过一年,false-未超过一年);
	 */
	PlanYearWorkItemVO getWorkByCid(Long cid,Long loginStaffId);
	
	//新增年度计划
	String addPlanYear(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, String details, String expends);
	
	//编辑年度计划
	String updatePlanYear(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, Byte fileType);
	
	//新增日常计划
	PlanYear addPlanDaily(Long cid, Long staffid, PlanYear planYear, Long[] fileId2);
	
	//编辑日常计划
	PlanYear updatePlanDaily(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, Byte fileType);
	//编辑日常计划总结
	PlanYear updateSummDaily(Long cid, Long staffid, PlanYear planYear, Long[] fileId2, Byte fileType);

	/**
	 * 统计年度计划阶段数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-22-上午11:25:11
	 * @param cid		企业ID
	 * @param stage PlanYearStageEnum阶段
	 * @return
	 */
	int countPlanYearCountByCidAndStage(Long cid, Byte stage);

	/**
	 * 
	 * @Comments:  <导出年度计划计划阶段已完成清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月22日-下午2:50:02
	 * @param cid
	 * @return
	 */
	List<PlanYear> exportPlanCompleteList(Long cid);

	/**
	 * 
	 * @Comments:  <导出年度计划总结阶段已完成清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月22日-下午2:50:29
	 * @param cid
	 * @return
	 */
	List<PlanYear> exportSummaryCompleteList(Long cid);
	
	PlanYear  addIsNotValidPlanYear(Long cid, Long loginStaffId,Long orgId);

	Integer updatePlanYearSubmitById(PlanYear year,Long cid, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <创建分解计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月15日-上午11:31:28
	 * @param planPId 分解计划的父id
	 * @param detOrExPid  实施计划和预算id
	 * @param source  是来自日常计划的还是年度计划
	 * @param type 1 是实施计划  2 经费预算
	 * @return
	 */
	public void  createDecomposePlanYearByParentIdAndType(Long planPid,Long detOrExPid,Byte source,Byte type,Long cid,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <根据父planID获取分解计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月15日-上午11:47:27
	 * @param parentId
	 * @param source
	 * @return
	 */
	PlanYear getDecomposePlanYearByParentIdAndType(Long parentId, Byte source);

	/**
	 * 
	 * @Comments:  <删除计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月16日-上午10:38:43
	 * @param id
	 * @param loginStaffId 
	 */
	void deleteEveryYearPlanSubmitById(Long id, Long loginStaffId);
	
	
	/**
	 * 
	 * @Comments:  <根据id获取数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月17日-下午4:16:38
	 * @param id
	 * @return
	 */
	public PlanYear getPlanYearById(Long id);

	PageInfo<PlanYear> getPlanYearPlanCompletedListByGridParam(JqGridParam gparam);
	
}
