/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.planyear;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearExpend;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanExpendStaticVo;
import cn.smarthse.modules.health.entity.work.planyear.vo.SearchParamVo;


 /**
 * 
 * 《IPlanYearExpendService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划预算>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-06-08 14:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPlanYearExpendService extends IBaseService<PlanYearExpend>{
	
	//根据param查询预算
	List<PlanYearExpend> getPlanYearExpendListByGridParam(JqGridParam gparam);
	
	/**
	 * 档案2接口(传入企业id和年份,返回年度计划预算list)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐颖东 [xyd.900919@qq.com]
	 * @since 2017-8-22-上午10:57:23
	 * @param cid		企业编号
	 * @return	List<PlanYearExpend>(年度计划预算);
	 */
	List<PlanYearExpend> getPlanYearExpendListByCidAndYear(Long cid,Integer year);
    
	/**
	 * 档案2接口(传入企业id和年份,返年度计划list)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐斌 [784514607@qq.com]
	 * @since 2019-01-08-上午10:37:23
	 * @param cid		企业编号
	 * @return	List<PlanYear>(年度计划);
	 */
	List<PlanYear> getPlanYearListForDoc2ByCidAndYear(Long cid, Integer year);

	/**
	 * 
	 * @Comments:  <添加经费预算>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-下午3:30:26
	 * @param planYearExpend
	 * @param loginStaffId
	 * @param cid
	 */
	void addPlanYearExpendSubmit(PlanYearExpend planYearExpend, Long loginStaffId, Long cid);

	/**
	 * 
	 * @Comments:  <编辑经费预算>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-下午3:49:35
	 * @param planYearExpend
	 * @param loginStaffId
	 */
	void updatePlanYearExpendSubmit(PlanYearExpend planYearExpend, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <删除经费预算>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-下午3:55:54
	 * @param id
	 * @param planId
	 * @param b
	 */
	void deletePlanYearExpendSubmit(Long id, Long planId, byte type,Long loginStaffId,Byte dataStatus);

	/**
	 * 
	 * @Comments:  <根据Id获取经费预算>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月15日-上午10:14:50
	 * @param id
	 * @return
	 */
	PlanYearExpend getPlanWorkExpendById(Long id);
	
	/**
	 * 
	 * @Comments:  <获取需分解的经费预算>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月18日-下午5:10:57
	 * @param planYearId
	 * @return
	 */
	List<PlanYearExpend>  getNeedDecomposeListByPlanYearId(Long planYearId);

	void updatePlanYearExpendSummarySubmit(PlanYearExpend planYearExpend, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <获取已分解的防治经费>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月20日-下午3:44:44
	 * @param gparam
	 * @param search
	 * @return
	 */
	PageInfo<PlanYearExpend> needDecomposePlanExpendParentListDataPage(JqGridParam gparam, SearchParamVo search);
	
	List<PlanYearExpend>  needDecomposePlanExpendParentListData(SearchParamVo search);
	
	
	/**
	 * 
	 * @Comments:  <根据的父的防治经费获取子的防治经费>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月20日-下午4:42:59
	 * @param pid
	 * @return
	 */
	public List<PlanYearExpend>  getChildrenPlanYearExpendByPid(Long pid);

	/**
	 * 
	 * @Comments:  <获取防治经费>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月22日-下午6:16:18
	 * @param id
	 * @return
	 */
	PlanYearExpend getNeedDecomposePlanExpendById(Long id);

	/**
	 * 
	 * @Comments:  <编辑分解的经费>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月22日-下午6:59:31
	 * @param planYearExpend
	 * @param loginStaffId
	 */
	void editNeedDecomposePlanExpendSubmit(PlanYearExpend planYearExpend, Long loginStaffId);

	int getNeedDecomposePlanExpendCountByStageAndCid(Byte stage, Long cid);

	PageInfo<PlanYearExpend> getChildrenxpendListDataGridParam(JqGridParam param);
	
	
	public List<PlanExpendStaticVo>  getStaticPlanExpend(SearchParamVo search);

	PageInfo<PlanExpendStaticVo> statisticPlanExpendListData(JqGridParam param, SearchParamVo vo);

	void deletePlanExpendSubmitByPlanId(Long planId,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <变更的经费预算>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月29日-上午9:59:43
	 * @param id
	 * @return
	 */
	List<PlanYearExpend> getChangeNeedDecomposeListByPlanYearId(Long id);

	void deleteChildrenByExpendPid(Long id, Long loginStaffId);
	
	//根据param查询预算
		List<PlanYearExpend> getPlanYearExpendChangeListByGridParam(JqGridParam gparam);

	void deleteDecomposePlanByDetailId(Long id, Long planId, Long loginStaffId);

}