/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.planyear;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.vo.SearchParamVo;
import cn.smarthse.modules.health.vo.work.yearplan.NeedDecomposeWorkPlan;


 /**
 * 
 * 《IPlanYearDetailService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.9.2>
 * @Comments:  <年度计划详细计划>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-06-08 14:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPlanYearDetailService extends IBaseService<PlanYearDetail>{
	
	//根据param查询详细计划
	List<PlanYearDetail> getPlanYearDetailListByGridParam(JqGridParam gparam);

	/**
	 * 更新实施方案
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-4-上午10:20:12
	 * @param detail
	 */
	void update(PlanYearDetail detail);
	
	/**
	 * 根据年度计划Id查询年度实施方案列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-4-上午10:00:58
	 * @param planYearId
	 * @return
	 */
	List<PlanYearDetail> getListByPlanYearId(Long planYearId);

	/**
	 * 根据条件查询年度实施列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-4-下午2:38:28
	 * @param cid
	 * @param businessModularId
	 * @param businessId
	 * @return
	 */
	List<PlanYearDetail> getList(Long cid, Long businessModularId, Long businessId);
	 
	/**
	 * 档案2接口(传入企业id和年份,返回年度计划详细计划list)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐颖东 [xyd.900919@qq.com]
	 * @since 2017-8-22-上午10:57:23
	 * @param cid		企业编号
	 * @return	List<PlanYearDetail>(年度计划详细计划);
	 */
	List<PlanYearDetail> getPlanYearDetailListByCidAndYear(Long cid,Integer year);
	
	/**
	 * 根据企业id、年份、工作类型id查询详细计划(传入企业id、年份、工作类型id,返回年度计划详细计划list)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐颖东 [xyd.900919@qq.com]
	 * @since 2017-8-22-上午10:57:23
	 * @param cid		企业编号
	 * @return	List<PlanYearDetail>(年度计划详细计划);
	 */
	List<PlanYearDetail> getPlanYearDetailListByCidAndYearAndBussnissModularId(Long cid,Integer year, Long bussnissModularId);

	/**
	 * 
	 * @Comments:  <新增实施计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-上午10:15:07
	 * @param planYearDetail
	 * @param loginStaffId
	 * @param cid
	 */
	PlanYearDetail addPlanWorkDetailSubmit(PlanYearDetail planYearDetail, Long loginStaffId, Long cid);

	/**
	 * 
	 * @Comments:  <更新实施方案>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-下午1:37:55
	 * @param planYearDetail
	 * @param cid
	 */
	PlanYearDetail updatePlanWorkDetailSubmit(PlanYearDetail planYearDetail, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <删除实施方案>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-下午2:06:51
	 * @param id
	 * @param planId
	 * @param type
	 */
	void deletePlanWorkDetailSubmit(Long id, Long planId, Byte type,Long loginStaffId,Byte dataStatus);

	/**
	 * 
	 * @Comments:  <根据id获取实施方案>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月14日-下午2:23:44
	 * @param id
	 * @return
	 */
	PlanYearDetail getPlanYearDetailById(Long id);

	/**
	 * 
	 * @Comments:  <获取不分解的实施方案(仅用于去每个模块创建数据)>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月16日-上午10:00:42
	 * @param planYearId
	 * @return
	 */
	List<PlanYearDetail> getNoDecomposeListByPlanYearId(Long planYearId);
	
	
	PageInfo<PlanYearDetail> getDailyPlanListByParam(JqGridParam gparam,SearchParamVo vo);
	
	PageInfo<PlanYearDetail> getDailySummaryListByParam(JqGridParam param, SearchParamVo vo);
	
	/**
	 * 
	 * @Comments:  <获取待分解的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月16日-下午7:20:30
	 * @param gparam
	 * @return
	 */
	PageInfo<PlanYearDetail> needDecomposePlanWorkParentListDataPage(JqGridParam gparam,SearchParamVo search);
	
	List<PlanYearDetail> needDecomposePlanWorkParentListData(SearchParamVo search);
	
	/**
	 * 
	 * @Comments:  <根据父的实施计划获取子实施计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月17日-下午6:58:22
	 * @param pid
	 * @return
	 */
	List<PlanYearDetail>  getChildrenPlanYearDetailsByPid(Long pid);
	

	PageInfo<PlanYearDetail> getChildrenPlanYearDetailsByPid(JqGridParam gparam,Long pid);
	

	
	/**
	 * 
	 * @Comments:  <获取需分解的实施方案>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月16日-上午10:00:42
	 * @param planYearId
	 * @return
	 */
	List<PlanYearDetail> getNeedDecomposeListByPlanYearId(Long planYearId);

	/**
	 * 
	 * @Comments:  <总结阶段提交实施方案>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月18日-下午7:54:40
	 * @param planYearDetail
	 * @param loginStaffId
	 */
	void editPlanWorkDetailSummarySubmit(PlanYearDetail planYearDetail, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <查询子计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月21日-下午5:21:13
	 * @param id
	 * @return
	 */
	PlanYearDetail getNeedDecomposePlanWorkById(Long id);


	/**
	 * 
	 * @Comments:  <编辑分解的工作计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月22日-上午10:27:01
	 * @param planYearDetail
	 * @param loginStaffId
	 */
	void editNeedDecomposePlanWorkSubmit(PlanYearDetail planYearDetail, Long loginStaffId);

	int getNeedDecomposePlanCountByStageAndCid(Byte stage, Long cid);
	
	/*统计*/
	
	/**
	 * 
	 * @Comments:  <计划总数>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月27日-上午9:52:49
	 * @param cid
	 * @return
	 * 工作计划统计界面，数据来自已完成的年度工作计划的实施方案、已完成的日常工作计划以及它们的子计划（即分解工作计划，子计划不管是否完成都纳入进来）
	 */
	int getPlanCountByCid(Long cid);
	
	
	/**
	 * 
	 * @Comments:  <计划完成数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月27日-上午10:09:50
	 * @param cid
	 * @return
	 */
	int getPlanCompletedStageCountByCid(Long cid);

	/**
	 * 
	 * @Comments:  <总结完成数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月27日-上午10:10:48
	 * @param cid
	 * @return
	 */
	int getPlanSummaryCompletedStageCountByCid(Long cid);

	void deletePlanDetailSubmitByPlanId(Long planId, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <统计所有实施方案的计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月28日-上午8:23:02
	 * @param param
	 * @param vo
	 * @return
	 */
	PageInfo<PlanYearDetail> statisticPlanDetailListData(JqGridParam param, SearchParamVo vo);

	List<PlanYearDetail> getAllPlanDetailListDataBySearch(SearchParamVo vo);
	
	
	/**
	 * 获取即将到期的未实施计划列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2019年10月28日-上午10:06:48
	 * @return
	 */
	List<PlanYearDetail> getWillExpirePlanList();

	/**
	 * 
	 * @Comments:  <变更分解实施方案>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月29日-上午9:58:51
	 * @param id
	 * @return
	 */
	List<PlanYearDetail> getChangeNeedDecomposeListByPlanYearId(Long id);

	/**
	 * 
	 * @Comments:  <删除子实施计划>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月29日-下午1:29:04
	 * @param id
	 * @param staffId
	 */
	void deleteChildrenByDetailPid(Long id, Long staffId);
     
	//根据param查询详细计划
		List<PlanYearDetail> getPlanYearDetailListChangeByGridParam(JqGridParam gparam);

		void deleteDecomposePlanByDetailId(Long id,Long planId, Long loginStaffId);
		
	  /**
	 * 
	 * @Comments:  <获取计划完成超过当前时间的年份数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月31日-上午8:58:19
	 * @param cid
	 * @return
	 */
	Integer getYearCountOverOneYearCompletedPlanByCid(Long cid);
	
	/**
	 * 获取子计划数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年5月14日-上午11:58:28
	 * @param detailPid
	 * @return
	 */
	Integer getChildPlanNumByPid(Long detailPid);
	
	
	/**
	 * 获取子计划已完成数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年5月14日-上午11:58:39
	 * @param detailPid
	 * @return
	 */
	Integer getChildPlanSummNumByPid(Long detailPid);

	PageInfo<NeedDecomposeWorkPlan> needDecomposePlanWorkParentListDataV2102Page(JqGridParam gparam,
			SearchParamVo search);
	
}
