/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.pdmonitor;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.pdmonitor.PdMonitor;
import cn.smarthse.modules.health.entity.work.pdmonitor.PdMonitorUpdable;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.work.thirdtime.PdMonitorWorkItemVO;


 /**
 * 
 * 《PdMonitor》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-08-07 04:10
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPdMonitorService extends IBaseService<PdMonitor>,IPlanYearWorkService{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-08-07 04:10
	 * @param PdMonitor
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public PdMonitor saveOrUpdatePdMonitor(PdMonitorUpdable pdMonitor, Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * 
	 * @Comments:  <获取个人剂量清单>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月7日-下午5:12:33
	 * @param param
	 * @param isFinish	是否获取已完成的数据
	 * @return
	 */
	public PageInfo<PdMonitor> pagePdMonitor(JqGridParam param, Boolean isFinish);
	
	/**
	 * 
	 * 
	 * @Comments:  <统计个人剂量 的数量（按企业和年份，   无年份的时候统计全部）>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月24日-下午5:59:11
	 * @return
	 */
	public Integer countPdMonitorByCid(Long cid, Boolean isFinish, Integer year) ;
	
	/**
	 * 
	 * 
	 * @Comments:  <距离现在十个月内容  是否有已完成的个人剂量数据>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月24日-下午6:14:28
	 * @param cid
	 * @return
	 */
	public boolean hasPdMonitorBetween3Month(Long cid) ;
	
	
	/**
	 * 根据年度查询汇总结果接口
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-1-上午10:09:17
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);

	/**
	 * 
	 * 
	 * @Comments:  <获取首页关键工作统计信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年9月27日-下午3:20:58
	 * @param cid
	 * @return
	 */
	public PdMonitorWorkItemVO getPdMonitorWorkItemVO(Long cid);

}
