package cn.smarthse.modules.health.service.work.operate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.operate.WorkOperateLog;
import com.github.pagehelper.PageInfo;

/**
 * 《》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/7/6 14:49
 */
public interface ICompanyWorkOperateLogService {

    /**
     * 操作记录-根据工作id
     * @param gparam
     * @param workId 工作id
     * @return
     */
    PageInfo<WorkOperateLog> getPage(JqGridParam gparam, Long workId);

    /**
     * 退回
     * @param workId 工作id
     * @param workModule 来源模块（WorkOperateLogEnum.typeVal）
     * @param reason 退回原因
     * @param operaterId 操作人id
     * @param operaterName 操作人名称
     */
    void back(Long workId, Byte workModule, String reason, Long operaterId, String operaterName,String companyName);

    /**
     * 上报
     * @param workId 工作id
     * @param workModule 来源模块（WorkOperateLogEnum.typeVal）
     * @param operaterId
     * @param operaterName
     */
    void report(Long workId, Byte workModule, Long operaterId, String operaterName,String companyName);

    /**
     *
     * @Comments:  <是否为退回>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年7月7日-下午1:36:35
     * @param workId
     * @param workModule
     * @return
     */
    Boolean isBack(Long workId, Byte workModule);
}
