/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2018
 */


package cn.smarthse.modules.health.service.work.judge;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.judge.OccuptionalJudge;


 /**
 * 
 * 《OccuptionalJudgeService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2018-08-04 01:41
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IOccuptionalJudgeService extends IBaseService<OccuptionalJudge>{


	/**
	 * 企业是否有评定
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月6日-上午10:35:25
	 * @param cid 企业ID
	 * @return
	 */
	public boolean hasJudgeCompany(Long cid);
	
	/**
	 * 用户最后一次评定
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月6日-上午10:36:15
	 * @param staffId 用户ID
	 * @return
	 */
	public OccuptionalJudge lastJudgeStaff(Long staffId);
	
	/**
	 * 是否有完成了的评定工作
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月13日-下午4:43:06
	 * @param staffId
	 * @return
	 */
	public boolean hasFinishedJudge(Long staffId);
	
	/**
	 * 保存评定信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月6日-下午4:22:40
	 * @param entity
	 * @return
	 */
	public OccuptionalJudge save(OccuptionalJudge entity,Long loginStaffId,Long cid);
	
	/**
	 * 评定完成分页信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月11日-上午9:22:15
	 * @param param
	 * @return
	 */
	public PageInfo<OccuptionalJudge> judgeFinishedPageInfo(JqGridParam param);

}
