package cn.smarthse.modules.health.service.work.judge;

import java.util.Date;
import java.util.List;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.judge.OccuptionalJudge;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.ContractInformNoRegister;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.PostHarmFactorInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.ThirdTimeInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainEducationInfo;
import cn.smarthse.modules.health.vo.work.judge.WarningSignsSummary;

/**
 * 职业病危害分险分类分级评定接口
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author horsy(何世壹) [hsy@smarthse.cn]
 * @since 2018年7月21日-上午10:24:04
 */
public interface IJudgeEhsClassificationService {

	/**
	 * 职业卫生管理制度列表（12-001）中有附件的制度个数
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月21日-上午10:28:57
	 * @param cid 企业ID
	 * @return
	 */
	int getMsInfoCountHasFile(Long cid);
	
	/**
	 * 岗位操作规程列表（12-003）中记录条数
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月21日-上午10:30:57
	 * @param cid
	 * @return
	 */
	int getMsPohopCount(Long cid);
	
	/**
	 * 职业卫生职能机构（14-001）中成立文件附件
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月21日-上午11:16:34
	 * @param cid
	 * @return
	 */
	SysFileModel getEstablishFile(Long cid);
	
	/**
	 * 获取职能机构管理人员信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月21日-上午11:26:07
	 * @param cid
	 * @return
	 */
	FunOrganManagerInfo getFunOrganMangerInfo(Long cid);
	
	
	/**
	 * 指定年份内，是否完成过一次职业病危害因素定期检测
	 * 职业病危害因素检测已完成清单（17-042）中
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月21日-上午11:29:59
	 * @param cid
	 * @param year
	 * @return
	 */
	boolean isFinishedHarmFactorRegularCheck(Long cid,int year);
	
	/**
	 * 获取指定年份内，最新的定期检测
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月11日-下午2:44:04
	 * @param cid
	 * @param year
	 * @return
	 */
	HcCheckPlan getLastHarmFactorRegularCheck(Long cid, int year);
	
	/**
	 * 最近进行的一次职业病危害因素现状评价检测的时间，如果没有进行过，则返回null
	 * 职业病危害因素检测已完成清单（17-042）中
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-上午9:57:15
	 * @param cid
	 * @return
	 */
	LastHarmFactorTestInfo getLastEvalForHarmFactor(Long cid);
	
	/**
	 * 获取最后一次危害因素检测的信息
	 * 职业病危害因素检测已完成清单（17-042）中
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-上午10:07:25
	 * @param cid
	 * @return
	 */
	LastHarmFactorTestInfo getLastHarmFactorInfo(Long cid);
	
	/**
	 * （27-021）检测结果告知已完成清单的数目
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-上午10:18:00
	 * @param cid
	 * @return
	 */
	int getHarmFactorInformNum(Long cid);
	
	/**
	 * 获取警示标识信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-上午10:27:02
	 * @param cid
	 * @return
	 */
	WarningSignsSummary getWarningSingsInfo(Long cid);
	
	/**
	 * 获取职业病危害因素申报信息
	 * 职业病危害项目申报结果统计（20-007）中记录
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-上午10:45:37
	 * @param cid
	 * @return
	 */
	HarmFactorDeclareInform getHarmFactorDeclareInform(Long cid);
	
	/**
	 * 建设项目清单（进行中）（23-002）和“三同时”管理结果统计（23-019）所有列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-上午11:23:20
	 * @param cid
	 * @return
	 */
	List<ThirdTimeInfo> getThirdTimeInfo(Long cid);
	
	/**
	 * 获取合同告知的统计信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午1:09:11
	 * @param cid
	 * @return
	 */
	ContractInformInfo getContractInformInfo(Long cid);
	
	/**
	 * 接害岗位中合同告知未登记人列表
	 * 
	 * 员工的岗位在岗位/工种接触的危害因素管理列表（11-001）中，且告知已完成清单（27-015）中无该人员该岗位的告知记录（不考虑人员的兼职岗位，也不统计离岗人员）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午1:19:25
	 * @param cid
	 * @return
	 */
	List<ContractInformNoRegister> getContractInformNoRegisterList(Long cid);
	
	
	/**
	 * 获取职业病防护设施数量
	 * 设备设施信息列表（08-001）中有类别为职业病防护设施子类的设备
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午1:32:31
	 * @param cid
	 * @return
	 */
	int getDeviceOccupationalDiseaseNum(Long cid);
	
	/**
	 * 获取防护用品采购列表信息
	 * 防护用品采购已完成清单（24-022）中记录
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午1:37:00
	 * @param cid
	 * @return
	 */
	List<ShieldPurchase> getShieldPurchaseList(Long cid);
	
	
	/**
	 * 获取防护用品发放信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午1:54:31
	 * @param cid
	 * @return
	 */
	ShieldSendInfo getShieldSendInfo(Long cid);
	
	/**
	 * 职业卫生培训合格证书的取证人员清单（30-024）中人员类别为主要负责人、职业卫生管理人员的人数，以及证书在有效期内的人数
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午2:08:02
	 * @param cid
	 * @return
	 */
	TrainCertificateInfo getTrainCertificateInfo(Long cid);
	
	
	/**
	 * 获取上岗和在岗期间培训信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午3:08:36
	 * @param cid
	 * @return
	 */
	TrainEducationInfo getTrainEducationInfo(Long cid);
	
	/**
	 * 获取职业健康体检信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午3:14:36
	 * @param cid
	 * @return
	 */
	PhcCheckInfo getPhcCheckInfo(Long cid);
	
	/**
	 * 获取在岗期间，职业健康体检的次数。
	 * 职业健康检查已完成清单（18-030）中种类为在岗期间职业健康检查的记录条数。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:11:49
	 * @param cid
	 * @return
	 */
	int getPhcCheckNumJobing(Long cid);
	
	/**
	 * 最后一次在岗期间职业健康体检的体检时间。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:12:40
	 * @param cid
	 * @return
	 */
	Date getLastPhcCheckDateJobing(Long cid);
	
	
	/**
	 * 获取职业病人人数
	 * 职业病人名单（18-033）中的人数。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:14:32
	 * @param cid
	 * @return
	 */
	int getOccupationalDiseasesNum(Long cid);
	
	/**
	 * 获取三年内，职业病新增病例数
	 * 诊断时间在三年以内的记录条数，同一个人可以计多次。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:15:28
	 * @param cid
	 * @return
	 */
	int getNewOccupationalDiseasesNum(Long cid);
	
	/**
	 * 获取上级监督检查的数量
	 * 隐患排查已完成界面（21-015）中类型为职业卫生和上级监督检查的记录条数。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:17:21
	 * @param cid
	 * @return
	 */
	int getSuperSceneInspectionNum(Long cid);
	
	/**
	 * 年度内上级监督检查的数量
	 * 隐患排查已完成界面（21-015）中类型为职业卫生和上级监督检查，且检查时间为今年的记录条数。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:18:01
	 * @param cid
	 * @return
	 */
	int getSuperSceneInspectionNumYear(Long cid);
	
	/**
	 * 获取岗位工作危害因素分页信息
	 * 调取自岗位/工种接触的危害因素管理列表（11-001）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:27:14
	 * @param param
	 * @param cid
	 * @return
	 */
	PageInfo<PostHarmFactorInfo> getPostHarmFactorInfoPage(JqGridParam param ,Long cid);
	
	/**
	 * 获取岗位工种危害因素对应的人员合计
	 * 岗位只取：调取自岗位/工种接触的危害因素管理列表（11-001）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月31日-下午4:28:28
	 * @param cid
	 * @return
	 */
	int getPostHarmFactorStaffNum(Long cid);
	
	/**
	 * 从原铺料中，获取高危危害因素的列表
	 * l_08_1_occupational_risk_factors_list表的H_toxic字段标识高毒
	 * 筛选条件：tpye=1：原辅物料信息列表（09-001）的物料名称和高危危害因素名称匹配（完全）
	 * 		 type=2：如果有石棉、石棉粉尘、石棉纤维、矽尘的则列出来，其中矽尘只需要包含这两字的就抓取出来。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月7日-下午12:47:53
	 * @param cid
	 * @param type 类型，1、高危危害因素，2、石棉、石棉粉尘、石棉纤维、矽尘
	 * @return 高危危害因素的名称列表
	 */
	List<String> getHighHarmFactorFromMaterial(Long cid,Integer type);
	
	/**
	 * 从产品信息列表中，获取高危危害因素
	 * l_08_1_occupational_risk_factors_list表的H_toxic字段标识高毒
	 * 筛选条件：type=1：产品信息列表（09-005）的物料名称与高危危害因素名称匹配
	 * 		 type=2：如果有石棉、石棉粉尘、石棉纤维、矽尘的则列出来，其中矽尘只需要包含这两字的就抓取出来。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月7日-下午12:47:53
	 * @param cid
	 * @param type 类型，1、高危危害因素，2、石棉、石棉粉尘、石棉纤维、矽尘
	 * @return 高危危害因素的名称列表
	 */
	List<String> getHighHarmFactorFromProduct(Long cid,Integer type);
	
	/**
	 * 从岗位工种接触的危害因素列表中，获取高危危害因素列表
	 * l_08_1_occupational_risk_factors_list表的H_toxic字段标识高毒
	 * 筛选条件：type=1：岗位/工种接触的危害因素管理列表（11-001）接触的危害因素是高危危害因素
	 * 		 type=2：如果有石棉、石棉粉尘、石棉纤维、矽尘的则列出来，其中矽尘只需要包含这两字的就抓取出来。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月7日-下午12:47:53
	 * @param cid
	 * @param type 类型，1、高危危害因素，2、石棉、石棉粉尘、石棉纤维、矽尘
	 * @return 高危危害因素的名称列表
	 */
	List<String> getHighHarmFactorFromWorkPost(Long cid,Integer type);
	
	/**
	 * 从工作场所接触的危害因素列表中，获取高危危害因素列表
	 * l_08_1_occupational_risk_factors_list表的H_toxic字段标识高毒
	 * 筛选条件：type=1：工作场所存在的危害因素管理列表（11-007）存在的危害因素是高危危害因素
	 * 		 type=2：如果有石棉、石棉粉尘、石棉纤维、矽尘的则列出来，其中矽尘只需要包含这两字的就抓取出来。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月7日-下午12:47:53
	 * @param cid
	 * @param type 类型，1、高危危害因素，2、石棉、石棉粉尘、石棉纤维、矽尘
	 * @return 高危危害因素的名称列表
	 */
	List<String> getHighHarmFactorFromWorkPlace(Long cid,Integer type);
	
	/**
	 * 从危害因素检测项目中，获取高危危害因素列表
	 * 
	 * l_08_1_occupational_risk_factors_list表的H_toxic字段标识高毒
	 * 筛选条件：type=1：职业病危害因素检测已完成清单（17-042）检测工作里的检测项目为高危危害因素
	 * 		 type=2：如果有石棉、石棉粉尘、石棉纤维、矽尘的则列出来，其中矽尘只需要包含这两字的就抓取出来。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月7日-下午12:47:53
	 * @param cid
	 * @param type 类型，1、高危危害因素，2、石棉、石棉粉尘、石棉纤维、矽尘
	 * @return 高危危害因素的名称列表
	 */
	List<String> getHighHarmFactorFromHarmFactorCheck(Long cid,Integer type);
}
