/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.informmanager;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-17 05:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface INoInformStaffService extends IBaseService<NoInformStaff>{

	/**
	 * 
	 * @Comments:  <根据搜索条件获取未告知职业病危害的人员清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月17日-下午6:49:01
	 * @param noInformStaff
	 * @return
	 */
	List<NoInformStaff> getNoInformStaffLisBySearch(NoInformStaff noInformStaff);

	/**
	 * 
	 * @Comments:  <根据人员关系中间表Id查询未告知职业病危害的人员清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月28日-下午10:43:58
	 * @param id
	 * @return
	 */
	NoInformStaff getNotInformStaffByStaffWorkRoleId(Long id,Long cid);

	void updateBeforeNoInformStaffNoValidBybeforeCurrentStaffWorkRoleId(Long beforeCurrentStaffWorkRoleId, Long cid,
			Long loginStaffId);
    
	/**
	 * 
	 * @Comments:  <根据搜索条件获取未告知职业病危害的人员清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月17日-下午6:49:01
	 * @param noInformStaff
	 * @return
	 */
	List<NoInformStaff> getNoInformStaffLisBySearchV24(NoInformStaff noInformStaff);

	/**
	 * 接害岗位中合同告知未登记人列表
	 * 员工的岗位在岗位/工种接触的危害因素管理列表（11-001）中，且告知已完成清单（27-015）中无该人员该岗位的告知记录（不考虑人员的兼职岗位，也不统计离岗人员） 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月3日-下午12:13:57
	 * @param cid
	 * @return
	 */
	List<NoInformStaff> getContractInformNoRegisterList(Long cid);

	void deleteNoInformStaffById(Long id, Long loginStaffId, Long cid);


}
