/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.informmanager;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInformTemplate;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-06 11:44
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IContractInformTemplateService extends IBaseService<ContractInformTemplate>{

	/**
	 * 
	 * @Comments:  <根据岗位Id获取告知模板>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月7日-下午2:41:48
	 * @param informWorkId
	 * @param cid
	 * @return
	 */
	ContractInformTemplate getContractInformTemplateByWorkId(Long informWorkId, Long cid);

	/**
	 * 
	 * @Comments:  <插入一条无效的模板数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月10日-下午5:07:54
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	ContractInformTemplate addNoValidContractInformTemplate(Long loginStaffId, Long cid,Long org);

	/**
	 * 
	 * @Comments:  <添加模板,并返回是否已存在该模板>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月11日-下午2:29:26
	 * @param template
	 * @return
	 */
	Boolean addContractInformTemplateSubmit(ContractInformTemplate template,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <合同告知模板数据查询>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月11日-下午3:20:09
	 * @param jparam
	 * @return
	 * @throws Exception 
	 */
	PageInfo<ContractInformTemplate> getcontractInformTemplateListByJParam(JqGridParam jparam,ContractInformTemplate template) throws Exception;

	/**
	 * 
	 * @Comments:  <根据多个ID删除数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月12日-下午4:49:40
	 * @param ids
	 * @param loginStaffId
	 */
	void deleteByIds(String ids, Long loginStaffId,Long cid);

	/**
	 * 
	 * @Comments:  <根据条件获取数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月15日-上午10:17:50
	 * @param template
	 * @return
	 * @throws Exception
	 */
	List<ContractInformTemplate> getcontractInformTemplateListBySearch(ContractInformTemplate template)
			throws Exception;

	/**
	 * 
	 * @Comments:  <根据多个Ids和搜索条件获取合同告知模板数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年12月12日-上午11:07:14
	 * @param tempIds
	 * @param search
	 * @return
	 */
	List<ContractInformTemplate> getcontractInformTemplateListBySearchAndIds(String tempIds,
			ContractInformTemplate search);

	void deleteContractInformTemplateById(Long id, Long loginStaffId, Long cid);



}
