/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.informmanager;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.entity.work.informmanager.OccupationalDiseaseContraindication;
import cn.smarthse.modules.health.entity.work.informmanager.vo.ContractInformDocVo;
import cn.smarthse.modules.health.model.HContractInfoModel;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.work.informManager.InformManagerFirstPageVo;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-06 11:43
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IContractInformService extends IBaseService<ContractInform>{
	
	/**
	 * 根据年度查询汇总结果接口
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-1-上午10:09:17
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);
	
	/**
	 * 
	 * @Comments:  <判断是否存在合同告知并保存合同告知>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月7日-下午1:10:50
	 * @param contractInform
	 * @return
	 */
	ContractInform addContractInformSubmit(ContractInform contractInform,Long loginStaffId,Long cid);

	List<OccupationalDiseaseContraindication> getOccupationalDiseaseContraindicationListFromBaseData(Long templateId, Long workId, Long cid,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <编辑所在工作岗位、可能产生的职业病危害、后果及职业病防护措施>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月11日-上午10:57:37
	 * @param o
	 */
	void editOccupationalDiseaseContraindicationSubmit(OccupationalDiseaseContraindication o,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <根据Id所在工作岗位、可能产生的职业病危害、后果及职业病防护措施>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月11日-上午11:03:39
	 * @param id
	 * @return
	 */
	OccupationalDiseaseContraindication getOccupationalDiseaseContraindication(Long id);
      
	/**
	 * 
	 * @Comments:  <获取合同告知数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月13日-下午3:21:07
	 * @param jparam
	 * @param inform
	 * @return
	 */
	PageInfo<ContractInform> getcontractInformListByJParam(JqGridParam jparam, ContractInform inform);

	/**
	 * 
	 * @Comments:  <根据ID获取合同告知数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月14日-上午11:25:48
	 * @param id
	 * @return
	 */
	ContractInform getContractInformById(Long id);

	/**
	 * 
	 * @Comments:  <根据搜索条件获取未告知职业病危害的人员清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月17日-下午6:43:04
	 * @param jparam
	 * @param noInformStaff
	 * @return
	 * @throws Exception 
	 */
	PageInfo<NoInformStaff> getNoInformStaffLisByJParam(JqGridParam jparam, NoInformStaff noInformStaff) throws Exception;

    
	/**
	 * 
	 * @Comments:  <获取告知管理首页数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月25日-下午5:04:37
	 * @param cid
	 * @return
	 */
	InformManagerFirstPageVo  getInformManagerFirstPageVoData(Long cid);
	
	
	/**
	 * 
	 * @Comments:  <根据年份获取和企业id获取相关合同告知信息:周立军>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月4日-下午4:29:52
	 * @param year
	 * @param cid
	 * @return
	 */
	List<ContractInformDocVo>  getContractInformDocVoByCidAndYear(String year,Long cid);
	
	
	
	/**
	 * 
	 * @Comments:  <来自人员岗位变更所产生的告知>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月5日-上午10:21:02
	 * @param inform
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	ContractInform informContractInformFromWorkChange(ContractInform inform,Long loginStaffId,Long cid);

	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月8日-下午5:12:03
	 * @param contractInform
	 * @param loginStaffId
	 */
	ContractInform updateContractInformSubmit(ContractInform contractInform, Long loginStaffId);
	
	
	/**
	 * 
	 * @Comments:  <根据岗位Id和人员Id获取最新的已完成的合同告知信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月25日-上午8:40:12
	 * @param staffId
	 * @param workId
	 * @param cid
	 * @param beginTime 当前岗位的上岗时间
	 * @param endTime   当前岗位的离岗时间
	 * @return
	 */
	Long getContractInformLastNewIdByStaffIdAndWorkId(Long staffId,Long workId,Long cid, Date beginTime, Date endTime);

	/**
	 * 
	 * @Comments:  <2.1需求>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月13日-下午1:40:42
	 * @param contractInform
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	ContractInform addNewContractInformSubmit(ContractInform contractInform, Long loginStaffId, Long cid);

	/**
	 * 
	 * @Comments:  <根据人员Id和岗位Id获取合同告知>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月2日-下午3:40:25
	 * @param staffIds
	 * @param workIds
	 * @param cid
	 * @return
	 */
	List<HContractInfoModel> getContractInformByStaffIdsAndWorkIdsAndCid(String staffIds, String workIds, Long cid);
	
	
	List<ContractInform> getcontractInformListByParam(ContractInform inform);

	Integer getcontractInformedCountByParam(ContractInform inform);

}
