/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.hccheckplan;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultReport;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-06 03:28
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHcCheckResultReportService extends IBaseService<HcCheckResultReport>{

	/**
	 * 
	 * @Comments:  <结果上报>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月13日-上午9:28:21
	 * @param jparam
	 * @param report
	 * @return
	 */
	PageInfo<HcCheckResultReport> getHcCheckResultReportListBySearchParam(JqGridParam jparam,
			HcCheckResultReport report);
	
	/**
	 * 
	 * @Comments:  <添加>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月13日-下午2:02:03
	 * @param report
	 * @param loginStaffId
	 * @param cid
	 */
	public HcCheckResultReport addHcCheckResultReportSubmit(HcCheckResultReport report,Long loginStaffId,Long  cid);
	
	/**
	 * 
	 * @Comments:  <更新>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月13日-下午2:02:17
	 * @param report
	 * @param loginStaffId
	 * @return 
	 */
	public HcCheckResultReport updateHcCheckResultReportSubmit(HcCheckResultReport report,Long loginStaffId);
	
	/**
	 * 
	 * @Comments:  <删除>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月13日-下午2:02:35
	 * @param report
	 * @param loginStaffId
	 */
	public void deleteHcCheckResultReportById(Long id,Long loginStaffId);
	
	
	/**
	 * 
	 * @Comments:  <根据Id查询单个的结果上报>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月17日-上午10:36:35
	 * @param id
	 * @return
	 */
	public HcCheckResultReport  getHcCheckResultReportById(Long id);
	
	
	/**
	 * 
	 * @Comments:  <职业病危害因素检测与评价结果待上报登记数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月25日-下午3:01:35
	 * @param cid
	 * @return
	 */
	public  Integer   getNoReportHcCheckPlansCount(Long cid);
	
	
	/**
	 * 
	 * @Comments:  <职业病危害因素检测与评价结果报告:何>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月6日-下午2:12:47
	 * @param cid
	 * @return
	 */
	public List<HcCheckResultReport> getHcCheckResultReportsBycid(Long cid,int year);
	
	
	/**
	 * 
	 * @Comments:  <获取正在上报的检测结果的数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月28日-下午4:04:26
	 * @param cid
	 * @return
	 */
	Integer getHcCheckResultReportingCountList(Long cid);

	/**
	 * 
	 * @Comments:  <获取已上报的检测结果的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月9日-上午10:43:22
	 * @param report
	 * @return
	 */
	List<HcCheckResultReport> exportHcCheckPlanReportResultStatData(HcCheckResultReport report);

	PageInfo<HcCheckResultReport> getHcCheckResultReportListIncludeNulltiyBySearchParam(JqGridParam jparam,
			HcCheckResultReport report);

	HcCheckResultReport updateAdminHcCheckResultReportSubmit(HcCheckResultReport report, Long loginStaffId);

	void deleteAdminHcCheckResultReportSubmit(Long id, Long loginStaffId);

}
