/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.hccheckplan;

import java.util.List;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultCollect;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-06 03:27
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHcCheckResultCollectService extends IBaseService<HcCheckResultCollect>{

	/**
	 * 
	 * @Comments:  <根据职业病危害因素检测Id获取检测项主要用于界面上检测项checkbox选中>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月20日-下午6:27:56
	 * @param hcId
	 * @return
	 */
	List<HcCheckResultCollect> getHcCheckResultCollectListByhcId(Long hcId,Long cid);


	/**
	 * 
	 * @Comments:  <添加检测项（结果汇总）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月21日-上午10:38:28
	 * @param hcId
	 * @param split
	 * @param collectTypes
	 * @param loginStaffId
	 */
	void addHcCheckResultCollectSubmit(Long hcId, String[] collectTypes, Long cid, Long loginStaffId);


	/**
	 * 
	 * @Comments:  <判断当前检测中是否有该检测项>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月31日-下午4:35:17
	 * @param hcId
	 * @param collectType
	 * @param cid
	 * @param loginStaffId
	 * @return
	 */
	HcCheckResultCollect getHcCheckResultCollectByhcIdAndCollectType(Long hcId, Byte collectType, Long cid,
			Long loginStaffId);

    
	/**
	 * 
	 * @Comments:  <根据检测大类获取HcIds>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月8日-下午4:15:27
	 * @param collectTypes
	 * @return
	 */
	List<Long>  getAllHcCheckPlanIdsByCollectTypes(String collectTypes,Long cid);

}
