/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.hccheckplan;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffWorkHarmCheckResultVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckCollectDataStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckCollectHarmFactorVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmMapByWorkAndYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmRanking;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmStatByYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckOnizingRadiationResult;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultCollectData;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckStatHarmByYearAndWork;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckWorkPointRate;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckWorkRanking;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectBiologicalFactorV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectChemicalV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectDustV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectEhighFrequencyV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectFreshAirrateV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectHandTransmittedVibrationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectHighTemperatureV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectIlluminationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectIonizingradiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectLaserRadiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectMicroclimateV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectMicrowaveradiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectNoiseV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectPowerFrequencyElectricFieldV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectUhfRadiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectUltravioletlightV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectWindSpeedV;
import cn.smarthse.modules.health.entity.work.hccheckplan.NoExistHarm;
import cn.smarthse.modules.health.entity.work.hccheckplan.SelectNoAccordCheckData;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectDataQuarterVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckResultValueVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCollectDataErrorVo;
import cn.smarthse.modules.health.enums.hccheckplan.HcQuarterEnum;
import cn.smarthse.modules.health.model.HDetectionOccModel;
import cn.smarthse.modules.health.model.HOccModel;
import cn.smarthse.modules.health.vo.base.company.AreaHarmFactorVo;
import cn.smarthse.modules.health.vo.base.company.HarmFactoCheckResultVo;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-06 03:27
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHcCheckResultCollectDataService extends IBaseService<HcCheckResultCollectData>{

	/**
	 * 
	 * @Comments:  <获取检测项化学物质视图的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午3:26:27
	 * @param jparam
	 * @param chemical
	 * @return
	 */
	PageInfo<HcCollectChemicalV> getHcCollectChemicalVBySearchParam(JqGridParam jparam, HcCollectChemicalV chemical);

	/**
	 * 
	 * @Comments:  <获取检测项粉尘视图的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午4:13:19
	 * @param jparam
	 * @param dust
	 * @return
	 */
	PageInfo<HcCollectDustV> getHcCollectDustVBySearchParam(JqGridParam jparam, HcCollectDustV dust);

	/**
	 * 
	 * @Comments:  <获取检测项生物因素视图的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午4:21:49
	 * @param jparam
	 * @param biological
	 * @return
	 */
	PageInfo<HcCollectBiologicalFactorV> getHcCollectBiologicalFactorVBySearchParam(JqGridParam jparam,
			HcCollectBiologicalFactorV biological);

	/**
	 * 
	 * @Comments:  <获取检测项噪声视图的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午4:29:58
	 * @param jparam
	 * @param noise
	 * @return
	 */
	PageInfo<HcCollectNoiseV> getHcCollectNoiseVBySearchParam(JqGridParam jparam, HcCollectNoiseV noise);

	/**
	 * 
	 * @Comments:  <获取检测项高温视图的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午4:53:16
	 * @param jparam
	 * @param highTemperature
	 * @return
	 */
	PageInfo<HcCollectHighTemperatureV> getHcCollectHighTemperatureVBySearchParam(JqGridParam jparam,
			HcCollectHighTemperatureV highTemperature);

	/**
	 * 
	 * @Comments:  <获取检测项紫外辐射视图的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午4:58:22
	 * @param jparam
	 * @param ultravioletlight
	 * @return
	 */
	PageInfo<HcCollectUltravioletlightV> getHcCollectUltravioletlightVBySearchParam(JqGridParam jparam,
			HcCollectUltravioletlightV ultravioletlight);

	/**
	 * 
	 * @Comments:  <工频电场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午5:11:07
	 * @param jparam
	 * @param powerFrequencyElectricField
	 * @return
	 */
	PageInfo<HcCollectPowerFrequencyElectricFieldV> getHcCollectPowerFrequencyElectricFieldVBySearchParam(
			JqGridParam jparam, HcCollectPowerFrequencyElectricFieldV powerFrequencyElectricField);

	/**
	 * 
	 * @Comments:  <微波辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午5:11:11
	 * @param jparam
	 * @param microwaveradiation
	 * @return
	 */
	PageInfo<HcCollectMicrowaveradiationV> getHcCollectMicrowaveradiationVBySearchParam(JqGridParam jparam,
			HcCollectMicrowaveradiationV microwaveradiation);

	/**
	 * 
	 * @Comments:  <高频电磁场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午5:16:38
	 * @param jparam
	 * @param ehighFrequency
	 * @return
	 */
	PageInfo<HcCollectEhighFrequencyV> getHcCollectEhighFrequencyVBySearchParam(JqGridParam jparam,
			HcCollectEhighFrequencyV ehighFrequency);

	/**
	 * 
	 * @Comments:  <超高频辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午5:21:27
	 * @param jparam
	 * @param uhfRadiation
	 * @return
	 */
	PageInfo<HcCollectUhfRadiationV> getHcCollectUhfRadiationVBySearchParam(JqGridParam jparam,
			HcCollectUhfRadiationV uhfRadiation);

	/**
	 * 
	 * @Comments:  <电离辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午5:29:08
	 * @param jparam
	 * @param ionizingradiation
	 * @return
	 */
	PageInfo<HcCollectIonizingradiationV> getHcCollectIonizingradiationVBySearchParam(JqGridParam jparam, HcCollectIonizingradiationV ionizingradiation);

	/**
	 * 
	 * @Comments:  <手传振动>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月22日-下午5:33:39
	 * @param jparam
	 * @param handTransmittedVibration
	 * @return
	 */
	PageInfo<HcCollectHandTransmittedVibrationV> getHcCollectHandTransmittedVibrationVBySearchParam(JqGridParam jparam,
			HcCollectHandTransmittedVibrationV handTransmittedVibration);

	/**
	 * 
	 * @Comments:  <激光辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月23日-上午11:44:30
	 * @param jparam
	 * @param laserRadiation
	 * @return
	 */
	PageInfo<HcCollectLaserRadiationV> getHcCollectLaserRadiationVBySearchParam(JqGridParam jparam,
			HcCollectLaserRadiationV laserRadiation);

	/**
	 * 
	 * @Comments:  <照度>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月23日-上午11:56:07
	 * @param jparam
	 * @param illumination
	 * @return
	 */
	PageInfo<HcCollectIlluminationV> getHcCollectIlluminationVBySearchParam(JqGridParam jparam,
			HcCollectIlluminationV illumination);

	/**
	 * 
	 * @Comments:  <微小气候>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月23日-下午12:01:44
	 * @param jparam
	 * @param microclimate
	 * @return
	 */
	PageInfo<HcCollectMicroclimateV> getHcCollectMicroclimateVBySearchParam(JqGridParam jparam,
			HcCollectMicroclimateV microclimate);

	/**
	 * 
	 * @Comments:  <新风量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月23日-下午12:06:36
	 * @param jparam
	 * @param freshAirrate
	 * @return
	 */
	PageInfo<HcCollectFreshAirrateV> getHcCollectFreshAirrateVBySearchParam(JqGridParam jparam,
			HcCollectFreshAirrateV freshAirrate);

	/**
	 * 
	 * @Comments:  <风速>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月23日-下午12:11:26
	 * @param jparam
	 * @param windSpeed
	 * @return
	 */
	PageInfo<HcCollectWindSpeedV> getHcCollectWindSpeedVBySearchParam(JqGridParam jparam,
			HcCollectWindSpeedV windSpeed);

	/**
	 * 
	 * @Comments:  <插入检测项具体数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月27日-上午10:33:57
	 * @param list
	 * @param cid
	 * @param loginStaffId
	 */
	void addHcCheckResultCollectDataSubmit(List<HcCheckResultCollectData> list, Long cid, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <根据检测项具体的数据的Id,得到行标识,通过行标识获取，具体的信息并变成Map key:是data_key的值，value：是data_value的值>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月27日-下午1:54:13
	 * @param resultCollectId
	 * @param hcId
	 * @param collectType
	 * @param dataId
	 * @return
	 */
	Map<String, String> getHcCheckPlanCollectDataMapBydataId(Long resultCollectId, Long hcId, Integer collectType,
			Long dataId);

	/**
	 * 
	 * @Comments:  <根据dataId进行更新，其实其实就是把当前的数据变为无效，再插入新的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @param list 
	 * @since 2017年7月27日-下午2:50:27
	 * @param resultCollectId
	 * @param hcId
	 * @param collectType
	 * @param dataId
	 * @param loginStaffId 
	 * @param cid 
	 */
	void udpateHcCheckResultCollectDataSubmit(List<HcCheckResultCollectData> list, Long resultCollectId, Long hcId, Integer collectType, Long dataId, Long cid, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <根据检测数据Id获取对应的行标识,进行数据逻辑删除>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月27日-下午2:54:26
	 * @param resultCollectId
	 * @param hcId
	 * @param collectType
	 * @param dataId
	 * @param loginStaffId 
	 */
	void deleteHcCheckPlanCollectDataByDataId(Long resultCollectId, Long hcId, Integer collectType, Long dataId, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <将整个检测项数据删除>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月27日-下午2:54:31
	 * @param resultCollectId
	 * @param hcId
	 * @param collectType
	 * @param loginStaffId 
	 */
	void deleteHcCheckPlanCollectByCollectType(Long resultCollectId, Long hcId, Integer collectType, Long loginStaffId);
	
	
	/**
	 * 
	 * @Comments:  <导入结果汇总数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月1日-下午3:28:16
	 * @param hcId
	 * @param filePath
	 * @param cid
	 * @param loginStaffId
	 */
	Map<Integer,List<HcCollectDataErrorVo>> importResultCollectDatas(Long hcId, String filePath, Long cid,Long loginStaffId);
	
	
	/**
	 * 
	 * @Comments:  <检测详情：周立军>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月7日-下午12:55:39
	 * @param jparam
	 * @param cid
	 * @param hcId
	 * @return
	 */
	PageInfo<HcCheckCollectHarmFactorVo> getHcCheckCollectAllCheckPojNamesByPage(JqGridParam jparam,Long cid,Long hcId);
	
	
	/**
	 * 
	 * @Comments:  <获取危害因素检测不符合项数据，分页>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月14日-下午2:52:40
	 * @param jparam
	 * @param cid
	 * @param hcId
	 * @param isIgnore
	 * @return
	 */
	PageInfo<HcCheckCollectHarmFactorVo>   getHcCheckCollectNotAccordDatas(JqGridParam jparam,Long cid,Long hcId,Boolean isIgnore);

	/**
	 * 
	 * @Comments:  <获取危害因素检测不符合项数据数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月14日-下午3:42:24
	 * @param cid
	 * @param hcId
	 * @return
	 */
	Integer getHcCheckCollectNotAccordDatasCountByhcId(Long cid, Long hcId);

	/**
	 * 
	 * @Comments:  <添加忽略的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月15日-下午5:21:16
	 * @param list
	 */
	void addIgNoreCheckDatas(String[] list);

	/**
	 * 
	 * @Comments:  <恢复忽略的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月16日-上午8:59:34
	 * @param list
	 */
	void recoveryIgNoreCheckDatas(String[] list);

	/**
	 * 
	 * @Comments:  <初次插入不符合项的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月16日-上午11:20:26
	 * @param list
	 * @param cid
	 * @param loginStaffId
	 * @return  返回的是初次加入的批次（UUID标识）是为了获取第一次没有整改Id的时候用
	 */
	String addNotAccordDatasToReformItem(String[] list, Long cid, Long loginStaffId);
	
	/**
	 * 
	 * @Comments:  <获取整改項的不合格检测点信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月16日-下午2:33:29
	 * @param jparam
	 * @param batch
	 * @return
	 */
	PageInfo<SelectNoAccordCheckData> getNotAccordDatasToReformItem(JqGridParam jparam, String batch);
	
	/**
	 * 
	 * @Comments:  <根据整改项ID获取整改項的不合格检测点信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月16日-下午2:33:29
	 * @param jparam
	 * @param batch
	 * @return
	 */
	PageInfo<SelectNoAccordCheckData> getNotAccordDatasToReformItemByReformItemId(JqGridParam jparam, Long  reformItemId);
	
	
	/**
	 * 
	 * @Comments:  <获取不符合项数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月21日-下午2:05:04
	 * @param cid
	 * @param year
	 * @return
	 */
	Integer   getHcCheckPlanNoAccordCountByYearAndCid(Long cid,String year);

	/**
	 * 
	 * @Comments:  <获取年份排名-岗位>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月22日-下午2:54:58
	 * @param jparam
	 * @param isThisYear
	 * @param cid
	 * @param year
	 * @return
	 */
	PageInfo<HcCheckWorkRanking> getHcCheckWorkRankingDataByYear(JqGridParam jparam, Boolean isThisYear, Long cid,
			Integer year);

	/**
	 * 
	 * @Comments:  <获取年份排名-危害因素>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月22日-下午7:13:55
	 * @param jparam
	 * @param isThisYear
	 * @param cid
	 * @param year
	 * @return
	 */
	PageInfo<HcCheckHarmRanking> getHcCheckHarmRankingDataByYear(JqGridParam jparam, Boolean isThisYear, Long cid,
			Integer year);
	
	
	/**
	 * 
	 * @Comments:  <超标岗位分布:肖奕>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月23日-下午1:25:52
	 * @param cid
	 * @param startYear
	 * @param endYear
	 * @return   workName（岗位名称），overproofCount（超标次数） harmNames（危害因素）
	 */
	List<HcCheckCollectDataStat>  getHcCheckCollectDataStatFromWorkByYear(Long cid,Integer startYear,Integer endYear);

	/**
	 * 
	 * @Comments:  <超标职业病危害因素分布:肖奕>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月23日-下午2:28:32
	 * @param cid
	 * @param startYear
	 * @param endYear
	 * @return  hamName（危害因素），overproofCount（超标次数） workNames（岗位名称）
	 */
	List<HcCheckCollectDataStat>  getHcCheckCollectDataStatFromHarmByYear(Long cid,Integer startYear,Integer endYear);
	
	/**
	 * 
	 * @Comments:  <历年检查结果趋势（肖奕）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月24日-上午9:27:06
	 * @param cid
	 * @param startYear
	 * @param endYear
	 * @param workId
	 * @return  year（年份），harmCount（超标次数） harmNames（危害因素）
	 */
	List<HcCheckHarmStatByYear> getHcCheckHarmStatByYearAndWorkId(Long cid,Long workId,Integer startYear,Integer endYear);

    
    /**
     * 
     * @Comments:  <多岗位检测结果趋势（肖奕）>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月24日-下午1:46:32
     * @param cid
     * @param startYear
     * @param endYear
     * @param workIds(字符串以逗号隔开)
     * @return  workName, list(年份,该年超标危害因素数量);
     */
    List<HcCheckStatHarmByYearAndWork> getHcCheckStatHarmByYearAndWork(Long cid,Integer startYear,Integer endYear,String workIds);
    
    
    /**
     * 
     * @Comments:  <热力图（肖奕）>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月24日-下午3:20:29
     * @param cid
     * @param startYear
     * @param endYear
     * @return
     */
    List<HcCheckHarmMapByWorkAndYear>  getHcCheckHarmMapByWorkAndYear(Long cid,Integer startYear,Integer endYear);
    
    
    /**
     * 
     * @Comments:  <岗位检测点位汇总:肖毅>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月24日-下午7:15:06
     * @param cid
     * @param startYear
     * @param endYear
     * @return
     */
    PageInfo<HcCheckWorkPointRate>  getHcCheckWorkPointRateData(JqGridParam jparam,Long cid,Integer startYear,Integer endYear);
    
    
    /**
     * 
     * @Comments:  <职业病危害因素日常监测季报汇总表:何>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月7日-上午7:39:36
     * @param cid
     * @param year
     * @param quarter
     * @return
     */
    List<HcCheckCollectDataQuarterVo>  getHcCheckCollectDataQuarterVosByCidAndYearAndQuarter(Long cid,String year,HcQuarterEnum quarter);
    
    /**
     * 
     * @Comments:  <根据HcIDs获取检测项>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月8日-下午5:31:11
     * @param hcIds
     * @return
     */
    List<StaffWorkHarmCheckResultVo>  getStaffWorkHarmCheckResultVoByHcIds(List<Long> hcIds);

	/**
	 * 
	 * @Comments:  <人员化学>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-上午9:09:37
	 * @param jparam
	 * @param chemical
	 * @return
	 */
	PageInfo<HcCollectChemicalV> getHcCollectChemicalVStaffBySearchParam(JqGridParam jparam,
			HcCollectChemicalV chemical);

	/**
	 * 
	 * @Comments:  <人员粉尘>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午3:45:35
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectDustV> getHcCollectDustVStaffBySearchParam(JqGridParam jparam, HcCollectDustV param);

	/**
	 * 
	 * @Comments:  <人员生物>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午3:50:16
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectBiologicalFactorV> getHcCollectBiologicalFactorVStaffBySearchParam(JqGridParam jparam,
			HcCollectBiologicalFactorV param);

	/**
	 * 
	 * @Comments:  <人员噪声>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午3:57:00
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectNoiseV> getHcCollectNoiseVStaffBySearchParam(JqGridParam jparam, HcCollectNoiseV param);

	/**
	 * 
	 * @Comments:  <人员高温>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:03:38
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectHighTemperatureV> getHcCollectHighTemperatureVStaffBySearchParam(JqGridParam jparam,
			HcCollectHighTemperatureV param);

	/**
	 * 
	 * @Comments:  <紫外辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:12:38
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectUltravioletlightV> getHcCollectUltravioletlightVStaffBySearchParam(JqGridParam jparam,
			HcCollectUltravioletlightV param);

	/**
	 * 
	 * @Comments:  <工频电场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:15:52
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectPowerFrequencyElectricFieldV> getHcCollectPowerFrequencyElectricFieldVStaffBySearchParam(
			JqGridParam jparam, HcCollectPowerFrequencyElectricFieldV param);

	/**
	 * 
	 * @Comments:  <微波辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:18:53
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectMicrowaveradiationV> getHcCollectMicrowaveradiationVStaffBySearchParam(JqGridParam jparam,
			HcCollectMicrowaveradiationV param);

	/**
	 * 
	 * @Comments:  <高频电磁场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:21:05
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectEhighFrequencyV> getHcCollectEhighFrequencyVStaffBySearchParam(JqGridParam jparam,
			HcCollectEhighFrequencyV param);

	/**
	 * 
	 * @Comments:  <超高频辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:32:44
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectUhfRadiationV> getHcCollectUhfRadiationVStaffBySearchParam(JqGridParam jparam,
			HcCollectUhfRadiationV param);

	/**
	 * 
	 * @Comments:  <电离辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:37:18
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectIonizingradiationV> getHcCollectIonizingradiationVStaffBySearchParam(JqGridParam jparam,
			HcCollectIonizingradiationV param);

	/**
	 * 
	 * @Comments:  <手传振动>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:43:08
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectHandTransmittedVibrationV> getHcCollectHandTransmittedVibrationVStaffBySearchParam(
			JqGridParam jparam, HcCollectHandTransmittedVibrationV param);

	/**
	 * 
	 * @Comments:  <激光辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:46:53
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectLaserRadiationV> getHcCollectLaserRadiationVStaffBySearchParam(JqGridParam jparam,
			HcCollectLaserRadiationV param);

	/**
	 * 
	 * @Comments:  <照度>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:51:19
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectIlluminationV> getHcCollectIlluminationVStaffBySearchParam(JqGridParam jparam,
			HcCollectIlluminationV param);

	/**
	 * 
	 * @Comments:  <微小气候>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:53:39
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectMicroclimateV> getHcCollectMicroclimateVStaffBySearchParam(JqGridParam jparam,
			HcCollectMicroclimateV param);

	/**
	 * 
	 * @Comments:  <新风量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:56:16
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectFreshAirrateV> getHcCollectFreshAirrateVStaffBySearchParam(JqGridParam jparam,
			HcCollectFreshAirrateV param);

	/**
	 * 
	 * @Comments:  <风速>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月29日-下午4:58:56
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCollectWindSpeedV> getHcCollectWindSpeedVStaffBySearchParam(JqGridParam jparam,
			HcCollectWindSpeedV param);

	/**
	 * 
	 * @Comments:  <生物>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:49:47
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectBiologicalFactorV> getHcCollectBiologicalFactorVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <化学>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:51:42
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectChemicalV> getHcCollectChemicalVByYearAndHarmIds(Long cid, Integer collectType, String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <粉尘>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:52:53
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectDustV> getHcCollectHcCollectDustVByYearAndHarmIds(Long cid, Integer collectType, String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <噪声>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:53:20
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectNoiseV> getHcCollectNoiseVByYearAndHarmIds(Long cid, Integer collectType, String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <高频电磁场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:54:18
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectEhighFrequencyV> getHcCollectEhighFrequencyVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <电离辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:54:45
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectIonizingradiationV> getHcCollectIonizingradiationVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <超高频辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:55:17
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectUhfRadiationV> getHcCollectUhfRadiationVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <手传振动>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:55:36
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectHandTransmittedVibrationV> getHcCollectHandTransmittedVibrationVByYearAndHarmIds(Long cid,
			Integer collectType, String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <微波辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:56:12
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectMicrowaveradiationV> getHcCollectMicrowaveradiationVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <紫外辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:56:43
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectUltravioletlightV> getHcCollectUltravioletlightVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <工频电场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:57:14
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectPowerFrequencyElectricFieldV> getHcCollectPowerFrequencyElectricFieldVByYearAndHarmIds(Long cid,
			Integer collectType, String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <高温>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:57:37
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectHighTemperatureV> getHcCollectHighTemperatureVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <激光辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月10日-下午2:58:10
	 * @param cid
	 * @param collectType
	 * @param harmIds
	 * @return
	 */
	List<HcCollectLaserRadiationV> getHcCollectLaserRadiationVByYearAndHarmIds(Long cid, Integer collectType,
			String harmIds,Integer year);

	/**
	 * 
	 * @Comments:  <根据危害因素和岗位的在岗时间段获取检测项>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月12日-上午9:13:22
	 * @param collectTypes
	 * @param harmIds
	 * @param beginTime
	 * @param leaveTime
	 * @param workId 
	 * @return
	 */
	List<StaffWorkHarmCheckResultVo> getStaffWorkHarmCheckResultVoByCollectTypesAndHarmIdsAndOnWorkTimes(
			List<Integer> collectTypes, String harmIds, Date beginTime, Date leaveTime,Long cid, Long workId);

	/**
	 * 
	 * @Comments:  <统计：化学物质>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午4:41:50
	 * @param jparam
	 * @param chemical
	 * @return
	 */
	PageInfo<HcCollectChemicalV> getHcCollectChemicalVStatBySearchParam(JqGridParam jparam,
			HcCollectChemicalV chemical);

	/**
	 * 
	 * @Comments:  <统计：粉尘>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午4:46:55
	 * @param jparam
	 * @param dust
	 * @return
	 */
	PageInfo<HcCollectDustV> getHcCollectDustVStatBySearchParam(JqGridParam jparam, HcCollectDustV dust);

	/**
	 * 
	 * @Comments:  <统计：噪声>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午4:50:45
	 * @param jparam
	 * @param noise
	 * @return
	 */
	PageInfo<HcCollectNoiseV> getHcCollectNoiseVStatBySearchParam(JqGridParam jparam, HcCollectNoiseV noise);

	/**
	 * 
	 * @Comments:  <统计：高温>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午4:53:28
	 * @param jparam
	 * @param highTemperature
	 * @return
	 */
	PageInfo<HcCollectHighTemperatureV> getHcCollectHighTemperatureVStatBySearchParam(JqGridParam jparam,
			HcCollectHighTemperatureV highTemperature);

	/**
	 * 
	 * @Comments:  <统计：紫外辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午4:57:26
	 * @param jparam
	 * @param ultravioletlight
	 * @return
	 */
	PageInfo<HcCollectUltravioletlightV> getHcCollectUltravioletlightVStatBySearchParam(JqGridParam jparam,
			HcCollectUltravioletlightV ultravioletlight);

	/**
	 * 
	 * @Comments:  <统计：工频电场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:00:10
	 * @param jparam
	 * @param powerFrequencyElectricField
	 * @return
	 */
	PageInfo<HcCollectPowerFrequencyElectricFieldV> getHcCollectPowerFrequencyElectricFieldVStatBySearchParam(
			JqGridParam jparam, HcCollectPowerFrequencyElectricFieldV powerFrequencyElectricField);

	/**
	 * 
	 * @Comments:  <统计：微波辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:03:19
	 * @param jparam
	 * @param microwaveradiation
	 * @return
	 */
	PageInfo<HcCollectMicrowaveradiationV> getHcCollectMicrowaveradiationVStatBySearchParam(JqGridParam jparam,
			HcCollectMicrowaveradiationV microwaveradiation);

	/**
	 * 
	 * @Comments:  <统计：高频电磁场>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:06:25
	 * @param jparam
	 * @param ehighFrequency
	 * @return
	 */
	PageInfo<HcCollectEhighFrequencyV> getHcCollectEhighFrequencyVStatBySearchParam(JqGridParam jparam,
			HcCollectEhighFrequencyV ehighFrequency);

	/**
	 * 
	 * @Comments:  <统计：超高频辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:08:34
	 * @param jparam
	 * @param uhfRadiation
	 * @return
	 */
	PageInfo<HcCollectUhfRadiationV> getHcCollectUhfRadiationVStatBySearchParam(JqGridParam jparam,
			HcCollectUhfRadiationV uhfRadiation);

	/**
	 * 
	 * @Comments:  <统计：电离辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:10:35
	 * @param jparam
	 * @param ionizingradiation
	 * @return
	 */
	PageInfo<HcCollectIonizingradiationV> getHcCollectIonizingradiationVStatBySearchParam(JqGridParam jparam,
			HcCollectIonizingradiationV ionizingradiation);

	/**
	 * 
	 * @Comments:  <统计：手传振动>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:13:48
	 * @param jparam
	 * @param handTransmittedVibration
	 * @return
	 */
	PageInfo<HcCollectHandTransmittedVibrationV> getHcCollectHandTransmittedVibrationVStatBySearchParam(
			JqGridParam jparam, HcCollectHandTransmittedVibrationV handTransmittedVibration);

	/**
	 * 
	 * @Comments:  <统计：光辐射>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:15:48
	 * @param jparam
	 * @param laserRadiation
	 * @return
	 */
	PageInfo<HcCollectLaserRadiationV> getHcCollectLaserRadiationVStatBySearchParam(JqGridParam jparam,
			HcCollectLaserRadiationV laserRadiation);

	/**
	 * 
	 * @Comments:  <统计：生物因素>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:21:44
	 * @param jparam
	 * @param biological
	 * @return
	 */
	PageInfo<HcCollectBiologicalFactorV> getHcCollectBiologicalFactorVStatBySearchParam(JqGridParam jparam,
			HcCollectBiologicalFactorV biological);

	/**
	 * 
	 * @Comments:  <统计：照度>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:39:33
	 * @param jparam
	 * @param illumination
	 * @return
	 */
	PageInfo<HcCollectIlluminationV> getHcCollectIlluminationVStatBySearchParam(JqGridParam jparam,
			HcCollectIlluminationV illumination);

	/**
	 * 
	 * @Comments:  <统计：微小气候>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午5:44:05
	 * @param jparam
	 * @param microclimate
	 * @return
	 */
	PageInfo<HcCollectMicroclimateV> getHcCollectMicroclimateVStatBySearchParam(JqGridParam jparam,
			HcCollectMicroclimateV microclimate);

	/**
	 * 
	 * @Comments:  <统计：新风量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午6:19:57
	 * @param jparam
	 * @param freshAirrate
	 * @return
	 */
	PageInfo<HcCollectFreshAirrateV> getHcCollectFreshAirrateVStatBySearchParam(JqGridParam jparam,
			HcCollectFreshAirrateV freshAirrate);

	/**
	 * 
	 * @Comments:  <统计：风速>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月19日-下午6:21:49
	 * @param jparam
	 * @param windSpeed
	 * @return
	 */
	PageInfo<HcCollectWindSpeedV> getHcCollectWindSpeedVStatBySearchParam(JqGridParam jparam,
			HcCollectWindSpeedV windSpeed);
	
	/**
	 * 
	 * @Comments:  <根据多个检测id，多个危害来源，是否存在超标查询危害来源>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月4日-下午2:26:48
	 * @param hcIds
	 * @param harmSources
	 * @param isExceeded
	 * @return
	 */
	List<HDetectionOccModel> getHDetectionOccModelByharmSourceAndHcIdAndIsExceeded(String hcIds,String harmIds,String harmSources,Boolean isExceeded);

	/**
	 * 
	 * @Comments:  <根据多个检测id，多个危害因素id，一个危害来源，是否存在超标查询危害来源>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月4日-下午3:48:42
	 * @param hcIds
	 * @param harmIds
	 * @param harmName
	 * @param isExceeded
	 * @return
	 */
	List<HOccModel> getHOccModelByharmSourceAndHcIdAndIsExceeded(String hcIds, String harmIds, String harmSource,
			boolean isExceeded);

	PageInfo<HcCheckHarmRanking> getNewHcCheckHarmRankingDataByYear(JqGridParam jparam, Boolean isThisYear, Long cid,
			Integer year);

	/**
	 * 
	 * @Comments:  <获取所有检测项总数>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年4月17日-上午10:32:49
	 * @param cid
	 * @param hcId
	 * @return
	 */
	Integer getAllCountResultDataByHcId(Long cid, Long hcId);
	
	/**
	 * 
	 * @Comments:  <获取系统中不存在的危害因素>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年4月18日-上午10:57:57
	 * @param jparam
	 * @param cid
	 * @return
	 */
	PageInfo<NoExistHarm> getNoExistHarmDataPageByCidAndHcId(JqGridParam jparam, Long cid,Long hcId);

	Integer getNoExistHarmListDataCountByHcId(Long cid, Long hcId);

	Integer getNotNullCheckDataByCidAndHcId(Long cid, Long hcId);

	Integer getAllCountResultDataHasNoHarmsByHcId(Long cid, Long hcId);
	
    /**
     * @param reportName
     * @param hcId
     * @return 根据检测报告id + 采样点获取危害因素id 集合
     */
	List<Long> getHcCheckReusltDataHarmIdsByReportNameAndHcId(String reportName,Long hcId);
	
	
	/**
	 * 
	 * @Comments:  <根据检测map信息查询检测结果数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年1月10日-上午10:40:59
	 * @param hcMap key为检测id  valueMap 有两个Key ：collectTypes（值为每个检测id对应的大类型），harmIds（值为每个检测id对应的危害因素id）
	 * @param hcHarmSourcesMap key为检测id  value为危害来源
	 * @return 
	 */
	List<StaffWorkHarmCheckResultVo> getStaffWorkHarmCheckResultVoByHcMap(
			 Map<Long, HashMap<String,ArrayList<Long>>>  hcMap,Map<Long,ArrayList<String>> hcHarmSourcesMap,Long cid);
	
	String getNoHarmNameByRowFlag(String rowFlag);
	
	
	/**
	 * 
	 * @Comments:  <获取电离辐射的检测结果>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年9月9日-上午9:47:22
	 * @param rowFlag
	 * @return
	 */
	List<HcCheckOnizingRadiationResult> getHcCheckOnizingRadiationResultListByRowFlag(String rowFlag);
	
	
	void editIonizingRadiationCheckResutlSubmit(List<HcCheckOnizingRadiationResult> checkResultList,
			Long resultCollectId, Long hcId, Integer collectType, Long dataId, Long loginStaffId);
	
	/**
	 * 
	 * @Comments:  <电离辐射根据Id删除>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年9月9日-下午1:35:19
	 * @param checkResultId
	 */
	void deleteHcCheckOnizingRadiationResultByCheckResultId(Long checkResultId, Long loginStaffId);
	
	
    /**
     * 
     * @Comments:  <根据检测id+危害因素获取  检测结果（数字，单位）分页:危害因素管理使用>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年3月12日-下午3:56:49
     * @param hcId
     * @param harmId
     * @return
     */
    List<HcCheckResultValueVo>	  getCheckResultValuesByHcIdAndHarmId(Long hcId, Long harmId);
    
    
    PageInfo<HcCheckResultValueVo>	  getCheckResultValuesByHcIdAndHarmIdPage(JqGridParam jparam,Long hcId, Long harmId);
    
    
    /**
     * 
     * @Comments:  <根据危害因素id和检测id（多个）查询检查结果>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年3月19日-下午4:24:10
     * @param list
     * @return
     */
    List<AreaHarmFactorVo>   getHcCheckPlanAndResultByHcIdAndHarmIdList(List<AreaHarmFactorVo> list);

	/**
	 * 
	 * @Comments:  <是否有峰接触浓度和超限倍数同时被填写>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年5月18日-上午10:44:53
	 * @param ossfile
	 * @return
	 */
	boolean isExistPeakcontactconcentrationAndTimesValues(String ossfile);

	/**
	 * 
	 * @Comments:  <获取excel里面哪些行是包含有峰接触浓度和超限倍数同时被填写的信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年5月18日-上午11:04:25
	 * @param ossfile
	 * @return
	 */
	List<HcCollectDataErrorVo> getPeakcontactconcentrationAndTimesValuesInfo(String ossfile);

	/**
	 * 
	 * @Comments:  <根据检测id和危害因素id获取检测结果（工作场所使用）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年6月11日-下午2:52:36
	 * @param harmId
	 * @param hcId
	 * @return
	 */
	AreaHarmFactorVo getHcCheckResultForWorkLocation(Long harmId, Long hcId,String checkPointName,Date checkBeginTime);
}
