/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.hccheckplan;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorHccheckplanunderway;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlanQueryParam;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckType;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.*;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasicHarmFactor;
import cn.smarthse.modules.health.enums.hccheckplan.HcQuarterEnum;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountDailyPageParamVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountDailyPageVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanCountVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanFirstPageVo;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-07-06 03:27
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHcCheckPlanService extends IBaseService<HcCheckPlan>,IPlanYearWorkService{
	
	 
	/**
	 * 根据年度查询汇总结果接口
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-9-1-上午10:09:17
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);

	/**
	 * 
	 * @Comments:  <保存职业病危害因素检测数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月9日-下午4:56:05
	 * @param hc
	 * @return
	 */
	HcCheckPlan addHcCheckPlanSubmit(HcCheckPlan hc,Long loginStaffId,Long cid,Long orgId);
	
	/**
	 * 
	 * @Comments:  <保存职业病危害因素检测数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月9日-下午4:56:05
	 * @param hc
	 * @return
	 */
	HcCheckPlan editHcCheckPlanSubmitAdmin(HcCheckPlan hc,Long loginStaffId,Long cid);

	/**
	 * 
	 * @Comments:  <添加一条无效的主记录数据用于关联子表数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @param loginStaffId 
	 * @param cid 
	 * @since 2017年7月21日-上午8:56:45
	 * @return
	 */
	HcCheckPlan addIsNotValidHcCheckPlan(Long cid, Long loginStaffId,Long orgId);
	
	
	/**
	 * 
	 * @Comments:  <获取搜索的时间范围获取检测报告数据 :周立军>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月7日-下午3:09:18
	 * @param startTime
	 * @param endTime
	 * @param cid
	 * @return
	 */
	PageInfo<HcCheckPlan> getHcCheckPlanCompletedByTimeRange(JqGridParam jparam,Date startTime,Date endTime,Long cid);

    
	
	PageInfo<HcCheckPlan> getHcCheckPlanListBySearchParam(JqGridParam jgGridParam,HcCheckPlan hc);
	
	/**
	 * 
	 * @Comments:  <来自第三方的检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年9月19日-下午3:38:51
	 * @param jgGridParam
	 * @param hc
	 * @return
	 */
	PageInfo<HcCheckPlan> getThirdHcCheckPlanListBySearchParam(JqGridParam jgGridParam,HcCheckPlan hc);
	

	ReformItemBasicHarmFactor saveReformItemBasicFromHarmFactor(ReformItemBasicHarmFactor entity, Long cid,
			Long loginStaffId,String batch);

	/**
	 * 
	 * @Comments:  <编辑检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月18日-下午2:59:13
	 * @param hc
	 */
	void editHcCheckPlanCheckingSubmit(HcCheckPlan hc,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <终止检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月18日-下午3:05:36
	 * @param ids
	 * @param cid 
	 * @param loginStaffId 
	 */
	void stopHcCheckPlanCheckingByIds(Long[] ids, Long loginStaffId, Long cid);

	/**
	 * 
	 * @Comments:  <根据Id获取检测数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月18日-下午3:45:49
	 * @param hcId
	 * @return
	 */
	HcCheckPlan getHcCHeckPlanById(Long hcId);

	/**
	 * 
	 * @Comments:  <根据年份获取检测数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月20日-下午5:53:28
	 * @param thisYear(为null为全部)
	 * @param cid
	 * @return
	 */
	Integer getHcCheckPlanCompletedCountByYear(String year, Long cid);
	
	
	
	/**
	 * 
	 * @Comments:  <获取危害因素首页统计数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月25日-下午1:56:18
	 * @param cid
	 * @return
	 */
	HcCheckPlanFirstPageVo getHcCheckPlanFirstPageVo(Long cid);
	
	
	/**
	 * 
	 * @Comments:  <统计对危害因素查询>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月28日-下午2:29:23
	 * @param jparam
	 * @param param
	 * @return
	 */
	PageInfo<HcCheckPlan>  getHcCheckPlanStatQueryVodata(JqGridParam jparam,HcCheckPlanQueryParam  param);
	
	
	/**
	 * 
	 * @Comments:  <获取当前企业的检测类型>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月31日-下午2:44:07
	 * @param cid
	 * @return
	 */
	List<HcCheckType> getHcCheckTypeListByCid(Long cid);

	/**
	 * 
	 * @Comments:  <危害因素检测告知数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月1日-下午3:26:11
	 * @param cid
	 * @param year
	 * @return
	 */
	Integer getInformedHcCheckCountByCidAndYear(Long cid, String year);
	
	
	/**
	 * 
	 * @Comments:  <根据检测Id获取获取危害因素检测超标率>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月5日-下午3:55:59
	 * @param cid
	 * @param hcId
	 * @return
	 */
	PageInfo<HarmCheckRateVo> getHarmCheckRateVosByHcId(JqGridParam jparam,Long cid,Long hcId);
	
    
	
	/**
	 * 
	 * @Comments:  <职业病危害因素检测点分布示意图:何>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月5日-下午5:17:50
	 * @param cid
	 * @return
	 */
	List<HcCheckPointMapVo>  getHcCheckPointMapVosByCid(Long cid,int year);
	
	
	/**
	 * 
	 * @Comments:  <职业病危害因素检测评价合同书:何>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月6日-下午1:30:20
	 * @param cid
	 * @return
	 */
	List<HcCheckEvaluateOrCheckFileVo>  getHcCheckEvaluateOrCheckFileVos(Long cid,int year);
	
	/**
	 * 
	 * @Comments:  <职业病危害检测与评价报告书:何>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月6日-下午1:50:31
	 * @param cid
	 * @return
	 */
	List<HcCheckEvaluateReportVo>  getHcCheckEvaluateReportVos(Long cid,int year);

	/**
	 * 
	 * @Comments:  <获取每年季度的检测IDS>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月7日-上午7:43:10
	 * @param cid
	 * @param year
	 * @param quarter
	 * @return
	 */
	List<Long> getHccheckplanDataByCidAndYearAndQuarter(Long cid, String year, HcQuarterEnum quarter);
	
	
	/**
	 * 
	 * @Comments:  <职业病危害因素检测评价结果告知清单:周立军>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月7日-上午8:38:56
	 * @param cid
	 * @param year
	 * @return
	 */
	List<HcResultCertificateVo>  getHcResultCertificateVosByYear(Long cid, String year);
	 /**
	  *
	  * @Comments:  <职业病危害因素检测评价结果告知清单:周立军>
	  * @author 邓力宾
	  * @since 2021年12月15日-上午9:11:56
	  * @param cid
	  * @param year
	  * @return
	  */
	List<HcResultCertificateVo>  getHcResultCertificateVosByYearNew(Long cid, String year);

	
	/**
	 * 
	 * @Comments:  <职业卫生技术服务机构资质证书:何>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月9日-下午12:06:49
	 * @param cid
	 * @param year
	 * @return
	 */
	List<Long>   getTpCompanyIdsFromHcCheck(Long cid,int year);

	/**
	 * 
	 * @Comments:  <根据整改项Ids获取检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月16日-下午5:24:36
	 * @param reformIdList
	 * @return
	 */
	List<HcCheckPlan> getHcCheckPlansByReformIdList(List<Long> reformIdList);

	/**
	 * 
	 * @Comments:  <根据整改项Id获取批次>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月22日-下午2:59:48
	 * @param reformId
	 * @return
	 */
	String getBatchByReformId(Long reformId);
	
	
	/**
	 * 
	 * @Comments:  <通过整改项恢复不符合整改项>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月25日-上午8:26:06
	 * @param reformId
	 */
	void recoveryNoAccordsByReformId(Long reformId);
	
	
	/**
	 * 
	 * @Comments:  <岗位对应危害因素浓度变化趋势>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月9日-下午4:09:26
	 * @param cid
	 * @param workId
	 * @param startYear
	 * @param endYear
	 * @return
	 */
	List<HcCheckHarmConcentrationForWorkEveryYear>   getHcCheckHarmConcentrationForWorkEveryYears(Long cid,Long workId,Integer startYear,Integer endYear); 

	/**
	 * 
	 * @Comments:  <根据查询条件，获取检测无分页>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月12日-上午9:34:35
	 * @param hc
	 * @return
	 */
	public List<HcCheckPlan> getHcCheckPlanListBySearchParam(HcCheckPlan hc);

	/**
	 * 
	 * @Comments:  <对岗位对应危害因素浓度变化趋势获取的数据做进一步的封装>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月13日-上午10:54:45
	 * @param list
	 * @return
	 */
	HcCheckConcentrationStat getHcCheckConcentrationStat(List<HcCheckHarmConcentrationForWorkEveryYear> list);

	/**
	 * 
	 * @Comments:  <导出检测完成的数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月9日-上午10:04:32
	 * @param hc
	 * @return
	 */
	List<HcCheckPlan> exportHcCheckPlanCompeledData(HcCheckPlan hc,boolean isThirdOrganization);

	/**
	 * 
	 * @Comments:  <检测结果告知已完成清单>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年11月16日-下午2:34:19
	 * @param hc
	 * @return
	 */
	List<HcCheckPlan> exportgetHcCheckPlanResultInform(HcCheckPlan hc);
	
	
	List<HarmfactorWorkSource>  getHarmfactorWorkByWorkIdAndHarmName(Long workId,String harmName);
	
	/**
	 * 
	 * @Comments:  <完成的检测的数量:周立军>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月18日-下午2:42:50
	 * @param cid
	 * @return
	 */
	Integer  getCompeletedHcCheckCount(Long cid);

	List<HcCheckPlan> getListByIdsAndDesc(List<Long> hcIds, Date workRoleStartDate, Date workRoleendDate);
	
	/**
	 * 
	 * @Comments:  <检测作废功能>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年4月10日-下午2:46:32
	 * @param hcId
	 */
	Boolean  hcCheckPlanNullifyByHcId(Long hcId,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <结果上报作废功能>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年4月11日-上午9:31:13
	 * @param hcId
	 * @return
	 */
	Boolean hcCheckPlanResultNullifyById(Long resutlId,Long staffId);
	
	PageInfo<HcCheckPlan> getHcCheckPlanListInCludeNullifyBySearchParam(JqGridParam jparam, HcCheckPlan hc);

	/**
	 * 
	 * @Comments:  <指定年份内，是否完成过一次职业病危害因素定期检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月3日-上午8:39:41
	 * @param cid
	 * @param year
	 * @return
	 */
	boolean isFinishedHarmFactorRegularCheck(Long cid, int year);
	
	/**
	 * 获取最新的定期检测
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年8月11日-下午2:37:05
	 * @param cid
	 * @param year
	 * @return
	 */
	HcCheckPlan getLastHarmFactorRegularCheck(Long cid, int year);

	/**
	 * 
	 * @Comments:  <最近进行的一次职业病危害因素现状评价检测的时间，如果没有进行过，则返回null>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月3日-上午8:51:06
	 * @param cid
	 * @return
	 */
	LastHarmFactorTestInfo getLastEvalForHarmFactor(Long cid);

	/**
	 * 
	 * @Comments:  <获取最后一次危害因素检测的信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月3日-上午9:20:09
	 * @param cid
	 * @return
	 */
	HcCheckPlan getLastHarmFactorInfo(Long cid);

	/**
	 * 
	 * @Comments:  <（27-021）检测结果告知已完成清单的数目>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月3日-上午9:59:09
	 * @param cid
	 * @return
	 */
	int getHarmFactorInformNum(Long cid);
	/**
	 * 从危害因素检测项目中，获取高危危害因素列表
	 * 
	 * l_08_1_occupational_risk_factors_list表的H_toxic字段标识高毒
	 * 筛选条件：type=1：职业病危害因素检测已完成清单（17-042）检测工作里的检测项目为高危危害因素
	 * 		 type=2：如果有石棉、石棉粉尘、石棉纤维、矽尘的则列出来，其中矽尘只需要包含这两字的就抓取出来。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author xubin
	 * @since 2018年8月7日-下午12:47:53
	 * @param cid
	 * @param type 类型，1、高危危害因素，2、石棉、石棉粉尘、石棉纤维、矽尘
	 * @return 高危危害因素的名称列表
	 */
	List<String> getHighHarmFactorFromHarmFactorCheck(Integer type,Long cid);

	/**
	 * 
	 * @Comments:  <职业病危害因素检测不符合项整改信息登记 删除功能>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年9月5日-上午8:51:18
	 * @param reformId
	 */
	void deleteReformForHcCheckPlanByReformId(Long reformId,Long userStaffId);
	
	
	
	/**
	 * 
	 * @Comments:  <根据检测时间范围查已检测的id集合>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年1月10日-上午10:26:26
	 * @param checkBigenTime
	 * @param checkEndTime
	 * @return  检测id集合
	 */
	List<Long>  getHcCheckPlanCompletedListByCheckTimeRange(Long cid,Date checkBigenTime,Date checkEndTime);
	
	/**
	 * 
	 * @Comments:  <获取现状数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年7月17日-上午9:32:10
	 * @param cid
	 * @return
	 */
	Integer getCheckPlanNowStatusCount(Long cid,Long evaId);
	
	/**
	 * 
	 * @Comments:  <获取控评数量>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年7月17日-上午9:32:34
	 * @param cid
	 * @return
	 */
	Integer getCheckPlanControlEvaluationCount(Long cid,Long evaId);

	HcCheckPlan updateHcCheckThirdOrgPlanSumbit(HcCheckPlan hcCheckThirdOrgPlan, Long loginBy);

	PageInfo<HcCheckPlan> getThirdHcCheckPlanListInCludeNullifyBySearchParam(JqGridParam jparam, HcCheckPlan hc);
	
	/**
	 * 
	 * @Comments:  <首页来自第三方的检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年9月27日-下午4:54:35
	 * @param cid
	 * @return
	 */
	HcCheckPlanFirstPageVo getThirdOrgHcCheckPlanFirstPageVo(Long cid);


	 HcCheckPlanCountVo getHcCheckPlanCompletedCountByYearAndType(Integer year, Long cid, Long checkType);

	 PageInfo<HcCheckPlanCountDailyPageVo> getHcCheckPlanCountDailyPage(JqGridParam jgGridParam, HcCheckPlanCountDailyPageParamVo paramVo);

	/**
	 * 
	 * @Comments:  <选择被关联的检测工作>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年3月4日-上午9:49:24
	 * @param jparam
	 * @param hc
	 * @return
	 */
	PageInfo<HcCheckPlan> getHcCheckNeedRelationDataPage(JqGridParam jparam, HcCheckPlan hc);

	PageInfo<HcCheckPlan> getThirdHcCheckNeedRelationDataPage(JqGridParam jparam, HcCheckPlan hc);

	HarmfactorHccheckplanunderway createHarmfactorHccheckplanunderway(Long hcId,Long loginStaffId);

	/**
	 * 
	 * @Comments:  <删除检测关联工作>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年3月5日-上午8:45:04
	 * @param hccheckUnderwayId
	 * @param staffId
	 */
	void deleteHarmHccheckplanRelationById(Long hccheckUnderwayId, Long staffId);

	/**
	 * 
	 * @Comments:  <存草稿和完成操作>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年3月5日-下午3:28:21
	 * @param hccheckUnderwayId
	 * @param hcplanId
	 * @param workrowDataJson	岗位关联数据
	 * @param isAdminModel		是否是超级管理员
	 * @param isFinish			false:存草稿， true 完成
	 * @param cid
	 * @param staffId
	 */
	void editHarmHccheckplanRelationSubmit(Long hccheckUnderwayId, Long hcplanId, String workrowDataJson,String areaRowDataJson, boolean isAdminModel,boolean isFinish,Long staffId,Long cid) throws Exception;

	/**
	 * 
	 * @Comments:  <获取危害因素关联历史记录>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年5月6日-下午2:58:37
	 * @param workRoleId
	 * @param occName
	 * @return
	 */
	List<HarmfactorWorkSource> getHarmfactorWorkHisByWorkIdAndHarmName(Long workRoleId, String occName);

	/**
	 * 
	 * @Comments:  <为上报的已告知的检测>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年5月11日-下午1:43:28
	 * @param jparam
	 * @param hc
	 * @return
	 */
	List<HcCheckPlan> exportgetThirdHcCheckPlanResultInform( HcCheckPlan hc);
}
