/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.harmfactor;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.vo.work.harmfactor.WorkHarmFactorCheckPointVo;
import cn.smarthse.modules.health.vo.work.harmfactor.WorkHarmFactorVo;

import java.util.List;
import java.util.Map;


/**
 * 
 * 《HarmfactorWorkSource》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-07-03 01:58
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHarmfactorWorkSourceService extends IBaseService<HarmfactorWorkSource>{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-07-03 01:58
	 * @param harmfactorWorkSource
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public HarmfactorWorkSource saveOrUpdateHarmfactorWorkSource(HarmfactorWorkSource harmfactorWorkSource, Long loginStaffId,Long cid) throws Exception;

	 /**
	  * 添加岗位危害因素
	  *
	  * @param workHarmfactorId
	  * @param harmId
	  * @param harmSource
	  * @param loginStaffId
	  * @param cid
	  * @return
	  */
	 public Map<String, Object> addHarmfactorWorkSource(Long workHarmfactorId, Long harmId, String harmSource, Long loginStaffId, Long cid);

	/**
	 * @Comments:  <删除关联关系>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2020/11/5-15:12
	 * @param checkPlanId
	 * @param loginStaffId
	 * @return void
	*/
	public void delHarmfactorWorkSourceByCheckPlanId(Long checkPlanId, Long loginStaffId);
	/**
	 * 根据岗位查询危害因素和检测信息 （邓力宾，2020-11-05）
	 * @param cid
	 * @param workId
	 * @return
	 */
    List<WorkHarmFactorVo> getWorkHarmFactorVos(Long cid, Long workId);

	/**
	 * 获取所有
	 * @param cid
	 * @return
	 */
	List<WorkHarmFactorCheckPointVo> getAllWorkHarmFactorVos(Long cid);


}
