/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.harmfactor;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorHccheckplanunderway;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkDiseaseVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceVo;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.DeclareHarmWorkNewVo;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmRiskDataVo;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmfactorItemVO;
import com.github.pagehelper.PageInfo;
import org.apache.ibatis.annotations.Param;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * 《HarmfactorWork》
 *
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-07-03 01:58
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHarmfactorWorkService extends IBaseService<HarmfactorWork> {
    /**
     * 业务验证异常
     */
    public static final Integer BUSINESS_VALID_EXCEPTION_CODE = 1;
    /**
     * 数据验证异常
     */
    public static final Integer DATA_VALID_EXCEPTION_CODE = 2;

    /**
     * @param HarmfactorWorkSourceVo
     * @param loginStaffId
     * @param cid
     * @return
     * @throws Exception
     * @Comments: 根据对象是否有主键id 判断做更新还是创建操作
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017-07-03 01:58
     */
    public HarmfactorWork saveOrUpdateHarmfactorWork(HarmfactorWork harmfactorWork, Long loginStaffId, Long cid) throws Exception;

    /**
     * @param harmfactorWork
     * @param loginStaffId
     * @throws Exception
     * @Comments: <删除 岗位/工种  危害因素信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月6日-下午3:51:57
     */
    public void delHarmfactorWork(HarmfactorWork harmfactorWork, Long loginStaffId) throws Exception;

    /**
     * @param harmfactorWorkSource
     * @param loginStaffId
     * @param cid
     * @throws Exception
     * @Comments: <根据 危害因素ID   删除 岗位/工种   危害因素列表>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月6日-下午4:07:48
     */
    public void delHarmfactorWorkSourceInfo(HarmfactorWorkSource harmfactorWorkSource, Long cid, Long loginStaffId) throws Exception;

    /**
     * @param param
     * @return
     * @Comments: <获取 分页功能的岗位工种危害因素管理，如果带查询，那么postDatas一定需要一个FieldKey为 searchKw的值>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月3日-下午2:13:19
     */
    public PageInfo<HarmfactorWorkSourceVo> pageHarmfactorWork(JqGridParam param, Boolean filterCurrYear);

    /**
     * @param cid
     * @param workHarmfactorId
     * @param harmId
     * @return
     * @Comments: 分页<查询给定 岗位工种危害因素 下的所有危害因素与危害因素来源的列表 （ 当有危害因素ID即 harmId有值的情况下表示 编辑页面 ）>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月5日-下午5:43:12
     */
    public PageInfo<HarmfactorWorkSourceInfoVo> pageHarmfactorWorkSourceInfoList(JqGridParam gparam, Long workHarmfactorId, Long harmId);


    public PageInfo<HarmfactorWorkSourceInfoVo> pageActualizeHarmfactorWorkSourceInfoList(JqGridParam gparam, Long workHarmfactorId, Long harmId);
    public List<HarmRiskDataVo> listHarmRiskData(Long cid);
    /**
     * @param wsource
     * @param delSource    要删除的危害因素来源 信息
     * @param loginStaffId
     * @param cid
     * @Comments: <更新 危害因素关联信息， >
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月6日-上午10:43:01
     */
    public void updateHarmfactorWorkSourceInfo(HarmfactorWorkSource wsource, String[] delSource, Long oldHarmId) throws Exception;

    /**
     * @param wsource
     * @Comments: <校验 该岗位危害因素下是否存在某危害来源>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年8月3日-下午4:49:53
     */
    public int checkHarmfactorWorkSourceInfo(HarmfactorWorkSource wsource);

    /**
     * @param cid
     * @param workHarmfactorId
     * @return
     * @Comments: <对外接口数据， 根据cid 和 岗位id  查询出对应有那些危害因素>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月7日-上午11:04:50
     */
    public List<HarmfactorWorkSourceInfoVo> getHarmfactorListByWork(@Param("cid") Long cid, @Param("work_id") Long workId);
    
    /**
     *  根据cid 和 岗位id  查询出给定时间五年内的检测对应有那些危害因素
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author  XiaoYi（肖奕)
     * @since 2020年6月2日-上午11:15:14
     * @param cid
     * @param workId
     * @param endTime
     * @return
     */
    public List<HarmfactorWorkSourceInfoVo> getHarmfactorListByWorkAndTime(Long cid,Long workId,Date endTime);
    
    public List<HarmfactorWorkSourceInfoVo> getHarmfactorListByWork(Long cid, Long workId, String type);

    public Integer countSourceNumByWork(@Param("cid") Long cid, @Param("work_id") Long workId, @Param("wid") Long wid);

    /**
     * @param param
     * @return
     * @Comments: <统计该企业下  所有岗位存在的危害因素>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年8月30日-上午11:29:30
     */
    public PageInfo<HarmfactorWorkSourceVo> getHarmfactorListGroupByWork(JqGridParam param);

    /**
     * @param cid
     * @param workId
     * @param splitor
     * @return
     * @Comments: <对外接口数据， 根据cid 和 岗位id  查询出对应有那些危害因素名称并按指定分隔符连接在一起>
     * @author yanao [ya@smarthse.cn]
     * @since 2017年7月7日-下午6:00:12
     */
    public String getHarmNamesByWork(@Param("cid") Long cid, @Param("work_id") Long workId, String splitor);

    public Set<Long> getHarmIdsByWorkId(Long cid, Long workId);


    public Set<Long> getHarmIdByGBZ();
    /**
     * @param hwsList
     * @Comments: <添加从 危害因素检测调过来的数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年8月8日-下午5:21:47
     */
    public void updateHarmfactorWorkSourceInfo(List<HarmfactorWorkSource> hwsList);

    /**
     * @param cid
     * @return
     * @Comments: <根据企业id统计该企业下是否有 岗位危害因素>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年8月24日-下午3:47:46
     */
    public Integer countHarmfactorByCid(Long cid);

    /**
     * @param cid
     * @return
     * @Comments: <统计指企业 接触职业病危害种类个数--   去重>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年11月24日-下午3:09:48
     */
    public Integer countHarmNumByCid(Long cid);

    /**
     * @param cid
     * @param WorkId
     * @return
     * @Comments: <根据岗位ID+Cid，返回岗位有危害因素数量？checkPlanId>0是必须条件>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年9月25日-上午11:42:46
     */
    public Integer countHarmfactorByCidAndWork(Long cid, Long WorkId);

    /**
     * @param cid
     * @param workId
     * @return
     * @Comments: <根据岗位id获取该岗位有的危害因素及可能引起的职业病 >
     * @author yanao [ya@smarthse.cn]
     * @since 2017年9月6日-上午9:28:35
     */
    public List<HarmfactorWorkDiseaseVo> getHarmfactorAndDieaseListByWork(@Param("cid") Long cid, @Param("work_id") Long workId);

    /**
     * @param cid
     * @param workId
     * @param harmId
     * @return
     * @Comments: <根据岗位信息和危害因素 关联查询危害因素来源>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年10月16日-下午1:48:50
     */
    public String getSourceByWorkIdAndHarmId(@Param("cid") Long cid, @Param("work_id") Long workId, @Param("harm_id") Long harmId);

    /**
     * @param cid
     * @return
     * @Comments: <获取岗位与危害因素的汇总>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年9月11日-上午11:02:29
     */
    @Deprecated
    public List<HarmfactorWork> getArchiveHarmfactor(Long cid);

    /**
     * @param cid
     * @param date
     * @return
     * @Comments: <获取岗位与危害因素的汇总>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年11月9日-上午10:40:08
     */
    public List<HarmfactorWork> getArchiveHarmfactor(Long cid, Date date);

    public List<HarmfactorWork> getActualizeArchiveHarmfactor(Long cid, Date date);
    /**
     * @param cid
     * @param workId
     * @param date
     * @return java.util.List<cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork>
     * @Comments: <查询该岗位 给定档案时间对应的存档（只包括从检测关联过来的数据）>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/1/11-15:05
     */
    public List<HarmfactorWorkSource> getArchiveHarmfactorByWork(Long cid, Long workId, Date date);

    public List<HarmfactorWorkSource> getActualizeArchiveHarmfactorByWork(Long cid, Long workId, Date date);
    /**
     * @param gparam
     * @param cid
     * @return
     * @Comments: <获取岗位与危害因素的汇总--- 带分页功能>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年11月24日-下午2:37:28
     */
    public List<HarmfactorWork> getArchiveHarmfactor(JqGridParam gparam, Long cid);

    /**
     * @param harmfactorWork
     * @param triggerChange
     * @param loginStaffId
     * @param cid
     * @return
     * @Comments: <对保存岗位危害因素， 并对危害因素是否有增加和删除 以触发代办事项>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年9月18日-上午11:37:22
     */
    public HarmfactorWork saveHarmfactorWork(HarmfactorWork harmfactorWork, boolean triggerChange, Long loginStaffId,
                                             Long cid) throws Exception;

    /**
     * 获取接触职业病危害因素人数
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年11月24日-下午3:18:28
     */
    public Integer getOccupationalStaffNumByCid(long cid);

    /**
     * @param cid
     * @return
     * @Comments: <根据cid 获取 存在危害因素的岗位信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年3月12日-下午1:53:11
     */
    public List<HarmfactorWork> getHarmfactorWorkListByCid(long cid);

    /**
     * 获取岗位接触危害因素情况
     *
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年11月24日-下午3:30:08
     */
    public PageInfo<HarmfactorWork> getHarmFactorWithWork(JqGridParam param);

    public HarmfactorWork saveHarmfactorWorkSource(List<HarmfactorWorkSource> hwList,List<HarmfactorWorkSource> areaDelMetaDataList, Long workId, Byte contactType, Long workHarmfactorId, Boolean isClone,
                                                   Long orgId, Long loginStaffId, Long cid) throws Exception;


    /**
     * @param cid
     * @return
     * @Comments: <查询指定企业下有已经有  哪些岗位有岗位危害因素信息了， 在页面显示的时候就需要排除这些数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月9日-上午11:45:24
     */
    public List<Long> listWorkIdByCid(@Param("cid") Long cid);

    /**
     * @param cid
     * @param harmId
     * @param checkPlanId
     * @return
     * @Comments: < 根据cid，hc_id,harm_id 获取workId，危害来源>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月15日-下午8:09:49
     */
    public List<HarmfactorWorkSource> getHarmfactorWsInfoByCheckplanIdHarmId(Long cid, Long harmId, Long checkPlanId);


    /**
     * @param cid
     * @return
     * @Comments: <统计首页工作>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月18日-下午4:15:06
     */
    public HarmfactorItemVO collectWorkCompHarmfactor(Long cid);

    /**
     * @param gparam
     * @param isFinish 是否已完成
     * @return
     * @Comments: <查询 检测报告危害因素关联一览表（进行中）>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月19日-下午1:19:03
     */
    public PageInfo<HarmfactorHccheckplanunderway> pageHarmfactorHccheckplanUnderway(JqGridParam gparam, Boolean isFinish);


    /**
     * @param underway
     * @return
     * @Comments: <检测已完成时， 需向危害因素管理插入数据：（hccplanId hccplanName hazardStartDate hazardEndDate hazardType 这几个字段需赋值）>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月19日-下午1:35:39
     */
    public int insertHarmfactorWorkHccheckplan(HarmfactorHccheckplanunderway underway);

    public List<HarmfactorWorkSourceVo> getHarmLinkHccheckplan(Long cid, Long hcplanId, Boolean isFinish, String kw, boolean isAdminModel);

    /**
     * @param cid
     * @param isFinish
     * @return
     * @Comments: <统计 检测报告危害因素关联一览表（进行中） 数量>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月19日-下午3:49:22
     */
    public int countHccplanUnderWay(Long cid, Boolean isFinish);

    /**
     * @param wharmSourceHccplanList
     * @param isFinish               保存标记
     * @param isAdminModel           是否是超级管理员
     * @param cid                    企业id
     * @param loginStaffId           操作人
     * @return
     * @Comments: <检测报告危害因素关联  保存>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月23日-下午2:40:19
     */
    public void saveHarmLinkHccheckplan(List<HarmfactorWorkSource> wharmSourceHccplanList, boolean isFinish,/* Long hccheckUnderwayId,*/ Long checkPlanId, Boolean isAdminModel,
                                        Long cid, Long loginStaffId) throws Exception;


    public HarmfactorHccheckplanunderway getHarmfactorHccheckplanunderwayById(Long hhccplanId);

    public PageInfo<HarmfactorWorkSourceVo> getHisDataByWork(JqGridParam jparam, Long workId, Long cid);

    /**
     * @param clonedWorkId 被克隆的岗位编号
     * @param newWorkId    需要被克隆的岗位
     * @param cid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月26日-下午3:19:45
     */
    public void cloneHarmfactorWork(Long clonedWorkHarmfactorId, Long newWorkId, Long loginStaffId, Long cid) throws Exception;


    /**
     * @param cid
     * @param workId
     * @param recommedType
     * @param splitor
     * @return
     * @Comments: <根据cid、岗位id、推荐类型获取检查内容>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年11月1日-下午2:41:59
     */
    public String getRecommedCheck(Long cid, Long workId, String recommedType, String splitor, String excludes);

    public List<String> getRecommedCheckList(Long cid, Long workId, String recommedType);

    public List<String> getOccRiskFactorsNameList(Long cid, Integer type, String function);

    /**
     * @param cid
     * @param allWorkIds
     * @param string
     * @return
     * @Comments: <根据岗位id集合获取危害因素>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年9月19日-上午11:39:55
     */
    public String getHarmNamesByWorks(Long cid, List<Long> allWorkIds, String string);

    public List<HarmfactorWorkSourceVo> ImportHarmsource(List<String> ossFileList, Long cid, Long hcplanId) throws IOException, Exception;

    /**
     * @param cid
     * @param workHarmfactorId
     * @param checkPlanId
     * @return
     * @Comments: <根据workHarmfactorId 和 检测报告ID 获取危害因素来源列表 >
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年11月20日-下午3:56:09
     */
    public List<HarmfactorWorkSource> getHarmfactorWorkSourceListByWorkHarmHccId(HarmfactorWorkSource param);

    /**
     * @Comments:  <查询岗位对应的危害因素》 再获取 必选或选填的体检项目>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018/11/30-16:47
     * @param cid    企业id
     * @param workId    岗位id
     * @param nameExamination    RecommendCheckEnum 枚举
     * @return java.util.List<java.lang.String>
     */
//	 public List<String> getContentExaminationByWork(Long cid,Long workId, RecommendCheckEnum recommendCheckEnum);

    /**
     * @param gparam 查询参数
     * @param isPage 是否分页
     * @return java.util.List<cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo>
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018/12/6-17:07
     */
    public PageInfo<HarmWorkStaffInfoVo> listHarmfactorStaffInfo(JqGridParam gparam, boolean isPage);

    /**
     * @param cid
     * @return
     * @Comments: <危害因素管理关联检测数量（正在进行的数量）>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年2月27日-上午10:05:56
     */
    int harmfactorHccheckplanunderwayCount(Long cid);


    /**
     * 导入岗位危害因素
     *
     * @param ossfileUrl excel 下载路径
     * @param cid
     */
    public Map<String, Object> importWorkHarm(String ossfileUrl, Long loginStaffId, Long orgId, Long cid) throws Exception;

    /**
     * @Comments:  <导入岗位危害因素：共享体系>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/12/18-10:10
     * @param ossfileUrl
     * @param loginStaffId
     * @param organizadId
     * @param cid
     * @return java.util.Map<java.lang.String,java.lang.Object>
    */
    public Map<String, Object> importWorkHarmLite(String ossfileUrl, Long loginStaffId, Long organizadId, Long cid) throws Exception;
    /**
     * @param hccheckUnderwayId
     * @param staffId
     * @Comments: <删除检测关联工作>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年3月5日-上午8:47:47
     */
    public void deleteHarmHccheckplanRelationById(Long hccheckUnderwayId, Long staffId);

    /**
     * @param underway
     * @Comments: <更新检测关联工作>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年3月5日-下午3:45:05
     */
    public void updateHarmHccheckplanRelation(HarmfactorHccheckplanunderway underway);

    HealthCheckStaffInfoVo getRecommendChecks(String[] harmIds, String[] specialWorkIds, String mustCheckFlag, String chooseCheckFlag, String splitor);

    /**
     * @param cid     必填
     * @param workId  必填
     * @param must    选填（必检项体检类型）
     * @param choose  选填（选检项体检类型）
     * @param splitor 选填（字符串分隔符）
     * @return HealthCheckStaffInfoVo.mustChecks HealthCheckStaffInfoVo.chooseChecks
     */
    HealthCheckStaffInfoVo getRecommedCheckInfo(Long cid, Long workId, String must, String choose, String splitor);
    
    /**
     * @Comments:  <根据检测ID  获取危害因素以及 危害来源>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/3/12-16:51
     * @param jparam
     * @param cid
     * @param hcId
     * @return void
    */
    public List<HarmfactorWorkAreaSourceVo> workAreaDetailList(JqGridParam jparam, Long cid, Long hcId, Boolean isFinish, Boolean isAdminModel);

    String exportImportTemp(Long hcplanId, Long cid);


    public DeclareHarmWorkNewVo collectDeclareHarmWorkNum(Long cid);
}
