package cn.smarthse.modules.health.service.work.harmfactor;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorAreaSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.vo.base.company.AreaHarmFactorVo;

import javax.cn.smarthse.modules.health.exception.HealthException;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: HarmfactorAreaSourceService
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 15
 * @since 2020/3/12-16:15
 */
public interface IHarmfactorAreaSourceService extends IBaseService<HarmfactorAreaSource> {

    /**
     * @Comments:  <区域维护因素关联信息保存>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/3/13-15:05
     * @param harmfactorAreaSource
     * @param loginStaffId
     * @param cid
     * @return cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorAreaSource
    */
    public HarmfactorAreaSource saveOrUpdateHarmfactorAreaSource(HarmfactorAreaSource harmfactorAreaSource, Long loginStaffId, Long cid) throws HealthException;


    public void saveAreaHarmRelation(List<HarmfactorWorkAreaSourceVo> aharmSourceHccplanList, boolean isFinish, Long checkPlanId, Boolean isAdminModel, Long cid, Long loginStaffId) throws Exception;


    public List<HarmfactorWorkAreaSourceVo> listHarmfactorAreaSourceByHcId(Long hcId, Boolean isFinish);

    Map<String, HarmfactorWorkAreaSourceVo> importAreaHarmRelation(String ossfile, Long loginStaffId, Long orgId, Long cid) throws Exception;

    /**
     * 查询区域下的危害因素  邓力宾 2020-03-18
     * @param areaIds
     * @return 只需 id(危害因素id),checkId (检测id)，区域id 危害因素名称name，hazardSource 字段
     */
    List<AreaHarmFactorVo> getHarmFactorAndCheckId(List<Long> areaIds, Long cid);


    List<HarmfactorAreaSource> getHarmSourceByHcId(Long hcId, Long harmId);

    /**
     * 根据危害因数查询
     * @param harmFactorIds
     * @return
     */
    List<HarmfactorAreaSource> getByHarmFactorIds(List<Long> harmFactorIds);

    /**
     * @Comments:  <删除关联关系>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/11/5-15:12
     * @param checkPlanId
     * @param loginStaffId
     * @return void
    */
    public void delHarmfactorAreaSourceByCheckPlanId(Long checkPlanId, Long loginStaffId);

    /**
     * @Comments:  <获取档案历史记录>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/8/19-17:36
     * @param cid
     * @param areaId
     * @param date
     * @return java.util.List<cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorAreaSource>
    */
    public List<HarmfactorAreaSource> getActualizeArchiveHarmfactorAreaSource(Long cid, Long areaId, Date date);
}










