/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.harmfactor;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaSourceHisVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaVo;
import cn.smarthse.modules.health.vo.base.company.AreaHarmFactorCheckVo;
import com.github.pagehelper.PageInfo;

import javax.cn.smarthse.modules.health.exception.BusinessException;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 《HarmfactorArea》
 *
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-07-03 01:59
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IHarmfactorAreaService extends IBaseService<HarmfactorArea> {

    /**
     * @param HarmfactorAreaVo
     * @param loginStaffId
     * @param cid
     * @return
     * @throws Exception
     * @Comments: 根据对象是否有主键id 判断做更新还是创建操作
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017-07-03 01:59
     */
    public HarmfactorArea saveOrUpdateHarmfactorArea(HarmfactorArea harmfactorArea, Long loginStaffId, Long cid) throws Exception;

    /**
     * @param param
     * @param areaId 有值时表示是编辑页面的表格
     * @return
     * @Comments: <获取 分页功能的区域危害因素管理，如果带查询，那么postDatas一定需要一个FieldKey为 searchKw的值>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月3日-下午2:13:19
     */
    public PageInfo<HarmfactorAreaVo> pageHarmfactorArea(JqGridParam param, Long areaId);

    /**
     * @param area
     * @param oper
     * @Comments: <根据 oper的不同 对 area 进行更新或删除>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月7日-下午3:22:37
     */
    /*public void updateOrDelHarmfactorArea(HarmfactorArea area, String oper, Long loginStaffId);*/
    public void delHarmfactorArea(Long areaId, Long loginStaffId, Long cid) throws Exception;

    /**
     * @param cid
     * @param harmId
     * @param date
     * @return java.util.List<cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea>
     * @Comments: <获取区域危害因素的归档记录>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/1/16-15:36
     */
    public List<HarmfactorArea> getArchiveHarmfactorAreaList(Long cid, Long harmId, Date date);

    /**
     * @param areaId
     * @param oldAreaId
     * @param loginStaffId
     * @param cid
     * @throws BusinessException
     * @Comments: <更改 工作场所 危害因素的 场所ID>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年7月12日-上午10:51:54
     */
    public void changeHarmfactorArea(List<HarmfactorArea> haList, Long areaId, Long oldAreaId, Long loginStaffId, Long cid) throws Exception;

    /**
     * @param cid
     * @param harmId
     * @return
     * @Comments: <提供档案接口：获取区域危害因素管理 的 监测周期（天） >
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2017年9月14日-上午9:16:25
     */
    public List<HarmfactorArea> getcheckCycleList(Long cid, Long harmId);

    /**
     * @param clonedAreaId
     * @param newAreaId
     * @param loginStaffId
     * @param cid
     * @throws Exception
     * @Comments: <保存通过克隆出来的数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年1月26日-下午4:48:34
     */
    public void saveCloneHarmfactorArea(Long clonedAreaId, Long newAreaId, Long orgId, Long loginStaffId, Long cid) throws Exception;


    /**
     * @param cid
     * @param areaId
     * @return
     * @Comments: <根据区域id 获取在该区域下的危害因素>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年7月19日-上午11:42:06
     */
    public List<HarmfactorAreaVo> listHarmfactorArea(Long cid, Long areaId,Boolean filterHcIdIsNULL) throws BusinessException;

    /**
     * 据区域id 获取在该区域下的危害因素 (邓力宾)
     *
     * @param cid
     * @param areaIds
     * @return
     * @throws BusinessException
     */
    List<HarmfactorArea> listHarmFactorArea(Long cid, List<Long> areaIds);

    /**
     * 区域存在的危害因数
     * @param cid
     * @param areaIds
     * @return AreaHarmFactorCheckVo 需要三个字段id,name,区域id 按危害因数id排序
     */
    List<AreaHarmFactorCheckVo> listHarmFactorArea2(Long cid, List<Long> areaIds, String harmTypes);
    /**
     * 区域存在的危害因数
     * @param cid
     * @param areaIds
     * @return AreaHarmFactorCheckVo 需要三个字段id,name,区域id 按危害因数id排序
     */
    PageInfo<AreaHarmFactorCheckVo> listHarmFactorArea2Page(Long cid, List<Long> areaIds, int pageNum, int pageSize);

    /**
     * @param ossfile
     * @param loginStaffId
     * @param orgId
     * @param cid
     * @return java.util.Map<java.lang.String, java.lang.Object>
     * @Comments: <区域危害因素导入>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/3/2-10:48
     */
    Map<String, Object> importAreaHarm(String ossfile, Long loginStaffId, Long orgId, Long cid) throws Exception ;

	List<HarmfactorAreaVo> listDistinctFactorAreas(Long cid,String keyword, String harmTypes);

    public PageInfo<HarmfactorAreaSourceHisVo> pageAreaHisData(JqGridParam jparam, Long cid, Long areaId);
}
