/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.harmFactorDeclare;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclare;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclareVO;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.CompanyDecBaseInfoVo;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.HarmFactorDecWorkItemVo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import com.github.pagehelper.PageInfo;

import java.util.List;


 /**
 * 
 * 《HarmFactorDeclareService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.30.1>
 * @Comments:  <职业病危害项目申报>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi(肖奕) 
 * @since 2017-08-02 01:22
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年9月4日-下午3:51:09
 */
public interface IHarmFactorDeclareService extends IBaseService<HarmFactorDeclare>{
	/**
     * 根据条件获取申报列表
     */
	PageInfo<HarmFactorDeclare> getHarmFactorDeclareList(JqGridParam param, HarmFactorDeclareVO info);
	
	/**
     * 统计进行中职业病危害项目申报数量
     */
	Integer numOfUnFinished(Long cid);
	
	/**
	 * 根据cid统计数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年10月9日-下午1:35:48
	 * @param cid
	 * @return
	 */
	Integer numByCid(Long cid);
	
	/**
	 * 获取待办事项提醒信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月26日-下午12:57:46
	 * @param cid
	 * @return
	 */
	HarmFactorDecWorkItemVo getDeclareTodoIndo(Long cid);

	/**
	 * 三同时,事故上报来源工作项目添加关键工作事项
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月28日-下午5:48:00
	 * @param data
	 * @param staffid
	 * @param cid
	 * @return
	 */
	HarmFactorDeclare addWithCoreWork(HarmFactorDeclare data, Long staffid, Long cid);
	
	/**
	 * 更新，如果来源为三同时,事故上报更新相关记录
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月28日-下午5:54:40
	 * @param info
	 * @param staffid
	 * @return
	 */
	HarmFactorDeclare updateWithCoreWork(HarmFactorDeclare info, Long staffid);
	/**
	 * 根据年度查询汇总结果接口
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年9月1日-下午4:32:23
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);
	
	/**
	 * 根据年度获取申报列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年9月4日-下午3:51:12
	 * @param cid
	 * @param year
	 * @return
	 */
	List<HarmFactorDeclare> getHarmFactorDeclareByYear(Long cid, Integer year);

	/**
	 * 根据查询信息获取申报列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月6日-上午10:58:14
	 * @param info
	 * @return
	 */
	List<HarmFactorDeclare> getListByInfo(HarmFactorDeclareVO info);

	/**
	 * 获取职业病危害因素申报信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年8月1日-上午9:01:41
	 * @param cid
	 * @return
	 */
	HarmFactorDeclareInform getHarmFactorDeclareInform(Long cid);

	/**
	 * 获取已完成的申报列表包括作废的
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年4月10日-下午2:08:08
	 * @param param
	 * @param info
	 * @return
	 */
	//PageInfo<HarmFactorDeclare> getHarmFactorDeclareFinishedList(JqGridParam param, HarmFactorDeclareVO info);

	/**
	 * 作废
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年4月10日-下午2:18:58
	 * @param id
	 * @param staffid
	 */
	//void toVoid(Long id, Long staffid);

	/*
	 * @Description:获取企业申报基础信息
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2020/10/15 11:23
	 * @param: [cid]
	 * @return: cn.smarthse.modules.health.vo.work.harmFactorDeclare.CompanyDecBaseInfoVo
	 **/
	CompanyDecBaseInfoVo getCompanyDecBaseInfo(Long cid);

}
