package cn.smarthse.modules.health.service.work.evaluate;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.outdata.evaluate.NowEvaluateModel;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateQueryVo;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateThridFormVo;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.evaluate.Evaluate;
import cn.smarthse.modules.health.enums.evaluate.EvaluateTypeEnum;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateForm;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateItemVO;
import org.apache.ibatis.annotations.Param;

public interface IEvaluateService  extends IBaseService<Evaluate>, IPlanYearWorkService {

	public final String MAIN_OCC_SEPARATOR = "!##!";
	/**
	 * 
	 * 
	 * @Comments:  <获取分页的评价工作数据， 完成与未完成通用>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年11月10日-下午4:40:07
	 * @param param
	 * @param finish
	 * @return
	 */
	PageInfo<Evaluate> pageEvaluate(JqGridParam param, EvaluateQueryVo queryVo);
	
	/**
	 * 
	 * 
	 * @Comments:  <分页的评价工作查询>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年11月27日-下午2:55:10
	 * @param param
	 * @return
	 */
	public PageInfo<Evaluate> pageEvaluateSearch(JqGridParam gdparam, String  param) ;

	public List<Evaluate> listEvaluateByOccType(Long cid, EvaluateTypeEnum evaluateType,  List<Byte> occType);
	/**
	 * 
	 * 
	 * @Comments:  <保存评价工作相关信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年11月10日-下午4:40:16
	 * @param form
	 * @return
	 */
	Map<String,Object> saveEvaluate(EvaluateForm form) throws Exception ;

	public EvaluateItemVO collectWorkCompEvaluate(Long cid, boolean hasThirdOrganization);

	public Evaluate getEvaluateByTsProEvaluateType(Long cid,Long tsProId, EvaluateTypeEnum evaluateType);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取评价报告和存放位置>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年12月18日-下午5:58:30
	 * @param evaluateId
	 * @return
	 */
	public Evaluate getEvaluateReport(Long cid,Long evaluateId);
	
	/**
	 * 
	 * 
	 * @Comments:  <作废 评价工作>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年4月10日-下午5:50:26
	 * @param e
	 * @param loginStaffId
	 */
	public void toVoidTsProject(Evaluate e, Long loginStaffId);

	/**
	 * @Comments:  <获取最新创建的  评价信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2019/7/16-18:57
	 * @param cid				必填
	 * @param evaluateType		EvaluateTypeEnum 评价类型，  为空时  不管是那个评价类型类型
	 * @param isFinish			是否完成， 为空时  不管是否完成
	 * @return cn.smarthse.modules.health.entity.work.evaluate.Evaluate
	*/
	public Evaluate getLastEvaluate(Long cid, EvaluateTypeEnum evaluateType, Boolean isFinish);
	/**
	 * @Comments:  <可以根据具体的字段排序，  默认使用 create_date>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2022/4/13-17:03
	 * @param cid
	 * @param evaluateType
	 * @param isFinish
	 * @param orderBy
	 * @return cn.smarthse.modules.health.entity.work.evaluate.Evaluate
	*/
	public Evaluate getLastEvaluate(Long cid, EvaluateTypeEnum evaluateType, Boolean isFinish, String orderBy);

	public Evaluate getEvaluateById(Long id);


	/**
	 * @Comments:  <获取最新 风险分类 并更新>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2021/4/19-16:19
	 * @param cid
	 * @return java.lang.Integer
	 */
	public Integer getAndUpdateOccType(Long cid, Long induId);

	/**
	 * @Comments:  <获取最新 风险分类 不更新>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2022/4/7-14:39
	 * @param cid
	 * @param induId
	 * @return java.lang.Integer
	*/
	public Integer getOccType(Long cid, Long induId);

	/**
	 * 可视化首页使用
	 * @param cid
	 * @param induId
	 * @return
	 */
	public Integer getAndUpdateOccTypeKSH(Long cid, Long induId);

	/**
	 * 获取还未添加到 共享体系的评价报告（预评价、控评）
	 * @param param
	 * @return
	 */
	public PageInfo<Evaluate> pageLiteEvaluates(JqGridParam param);

	public String getEvaluateIdsByProjectId(Long projectId);


	public Map<String, Integer> collectEvaluateNum(Long cid, Integer year);

	public Map<String, Integer> collectEvaluateNum(Long cid, Date start, Date end);

	/**
	 * 获取评价id
	 * @param cid
	 * @param year
	 * @return
	 */
	List<Long> getEvaluateIds(Long cid, Integer year);


	public List<String> parseEvaluateHarmName(Long eid);
	public List<String> parseEvaluateHarmName(Evaluate evaluate);


	public ResponseData<String> importNowEvaluate(NowEvaluateModel nowEvaluateModel) throws Exception;
}
