package cn.smarthse.modules.health.service.work.evaluate;

import java.util.List;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.evaluate.Evaluate;
import cn.smarthse.modules.health.entity.work.evaluate.EvaluateOtherfile;
import cn.smarthse.modules.health.entity.work.evaluate.EvaluateOtherfileUpdable;
import cn.smarthse.modules.health.enums.evaluate.EvaluateTypeEnum;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateOtherfileVo;

public interface IEvaluateOtherfileService extends IBaseService<EvaluateOtherfile>{
	public EvaluateOtherfile saveOrUpdateEvaluateOtherfile(EvaluateOtherfileUpdable otherfile, Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * 
	 * @Comments:  <获取评价项目文件信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年11月13日-上午9:48:52
	 * @param cid
	 * @param eProjectId
	 * @param evaluateType
	 * @return
	 */
	public List<EvaluateOtherfile> getEvaluateOtherfileList(Long cid, Long eProjectId, EvaluateTypeEnum evaluateType);

	/**
	 * @Comments:  <获取带有 SysFile 实体的文件对象>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2019/9/9-10:40
	 * @param cid
	 * @param eProjectId
	 * @param evaluateType
	 * @return java.util.List<cn.smarthse.modules.health.vo.work.evaluate.EvaluateOtherfileVo>
	*/
	public List<EvaluateOtherfileVo> getEvaluateOtherfileVoList(Long cid, Long eProjectId, EvaluateTypeEnum evaluateType);
	
	public EvaluateOtherfile getEvaluateOtherfile(Long cid, Long eProjectId, EvaluateTypeEnum evaluateType, Byte cate);
}
