package cn.smarthse.modules.health.service.work.evaluate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.evaluate.EvaluateThird;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateThirdModel;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateThirdSearchModel;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateThridFormVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: ${NAME}
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 40
 * @since 2019/8/29-10:40
 */
public interface EvaluateThirdService extends IBaseService<EvaluateThird> {

    public List<EvaluateThird> listEvaluateThirdByEid(Long evaluateId);

    public EvaluateThird getEvaluateThirdByEid(Long evaluateId);

    public Map<String, Object> saveOrUpdateEvaluateThridForm(EvaluateThridFormVo formVo, Long loginStaffId, Long cid) throws Exception;

    /**
     * @Comments:  <获取评价信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/9/3-16:31
     * @param searchModel
     * @param cid
     * @return java.util.List<cn.smarthse.modules.health.vo.work.evaluate.EvaluateThirdModel>
    */
    public List<EvaluateThirdModel> listEvaluateThirdModel(EvaluateThirdSearchModel searchModel, Long cid);

    /**
     * @Comments:  <获取分页的数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/9/3-16:41
     * @param gparam
     * @param searchModel
     * @param cid
     * @return java.util.List<cn.smarthse.modules.health.vo.work.evaluate.EvaluateThirdModel>
    */
    public PageInfo<EvaluateThirdModel> pageEvaluateThirdModel(JqGridParam gparam, EvaluateThirdSearchModel searchModel, Long cid);

    /**
     * @Comments:  <删除主副表数据>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/9/4-14:15
     * @param evaluateId
     * @param loginStaffId
     * @return void
    */
    public void delEvaluateById(Long evaluateId, Long loginStaffId);


//    public List<EvaluateThirdModel> listEvaluateThirdModelByAreaId(EvaluateThirdSearchModel searchModel, Long cid);
    /**
     * @Comments:  <根据区域查询  上报的 评价信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/9/6-11:23
     * @param param
     * @param searchModel
     * @param cid
     * @return java.util.List<cn.smarthse.modules.health.vo.work.evaluate.EvaluateThirdModel>
    */
//    public PageInfo<EvaluateThirdModel> pageEvaluateThirdModelByAreaId(JqGridParam param, EvaluateThirdSearchModel searchModel, Long cid);
}













