/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.eme;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueTeamRerson;

 /**
 * 
 * 《IEmeRescueTeamRersonService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.8.3>
 * @Comments:  <应急救援队伍人员>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-06-08 14:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IEmeRescueTeamRersonService extends IBaseService<EmeRescueTeamRerson>{
	
	// 根据应急救援队伍ID查询队伍所属的人员(带分页)
	PageInfo<EmeRescueTeamRerson> getEmeRescueTeamRersonListByGridParam(JqGridParam gparam);
	
	// 根据应急救援队伍ID查询队伍所属的人员(不带分页)
	List<EmeRescueTeamRerson> getEmeRescueTeamRersonList(Long teamId);

	List<EmeRescueTeamRerson> getMobileList(Long teamId,String keyword);

	List<EmeRescueTeamRerson> getMobileList(Long cid, Long teamId, String keyword);

	boolean hasMemeber(EmeRescueTeamRerson rerson);

	void updateInfoByPrimaryKey(EmeRescueTeamRerson emeRescueTeamRerson, Long staffid);
	
	/**
	 * 
	 * 
	 * @Comments:  <应急救援队伍ID查询队伍的领导人员>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年9月6日-上午8:58:09
	 * @param teamId
	 * @return
	 */
	List<EmeRescueTeamRerson> getEmeRescueTeamRersonLeaderList(Long teamId);
}
