package cn.smarthse.modules.health.service.work.check.newcheck20241015;


import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckSearchParam;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckStaffBasicInfo;
import cn.smarthse.modules.health.vo.work.check.CheckStaffInfo;
import cn.smarthse.services.wanda.api.entity.WandaHcRItems;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 体检人员信息(2024-10-15 重构)(PhcPhysicalCheckStaffBasicInfo)表服务接口
 *
 * @author Supw
 * @since 2024-10-15 14:34:17
 */
public interface IPhcPhysicalCheckStaffBasicInfoService extends IBaseService<PhcPhysicalCheckStaffBasicInfo> {

    int batchInsert(List<PhcPhysicalCheckStaffBasicInfo> staffCheckBasicInfos);

    List<CheckStaffInfo> listData(PhcPhysicalCheckSearchParam param);
    PageInfo<CheckStaffInfo> listPage(PhcPhysicalCheckSearchParam param);

    List<WandaHcRItems> getXfcItem(String cardId, String diagnosisId);

    /**
     * 按照老版体检的格式查询数据
     *
     * @param cidList
     * @return cid、bodyCheckType,conclusion,body_check_type,idcard_code,card_id,name
     */
    List<PhcPhysicalStaffCheckInfo> getOldDataModelListByCid(List<Long> cidList);

    /**
     *  统计体检异常人员数量
     * @param conclusions :3-疑似职业病，4-职业禁忌症
     * @param cids
     * @param year
     * @return 疑似职业病:numberOfYszyb , 职业禁忌症:numberOfYsjjz
     */
    List<PhcPhysicalCheckV3221> countAbnormalNum(List<Long> cids, Integer year,List<String> conclusions);
}

