package cn.smarthse.modules.health.service.work.check.newcheck20241015;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckReport;
import cn.smarthse.modules.health.entity.work.check.newcheck20241015.PhcPhysicalCheckSearchParam;
import cn.smarthse.modules.health.vo.work.check.ReportVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @ author Supw
 * @ since 2024/10/15 10:43
 */
public interface IPhcPhysicalCheckReportService extends IBaseService<PhcPhysicalCheckReport> {


    /**
     * 万达体检数据转换到企业端数据接口
     * @param unifiedSocialCc
     */
    void convertData(String unifiedSocialCc);

    /**
     * 根据年份统计体检人数
     * @param cid
     * @param year
     * @return
     */
    PhcPhysicalStatisticsModel statisticsYearNum(Long cid,Integer year);

    /**
     * 查询有体检的年份
     * @param cid
     * @return
     */
    List<Integer> queryYearList(Long cid);

    /**
     * 根据条件查询体检报告列表
     * @param param
     * @return
     */
    List<ReportVo> queryReportList(PhcPhysicalCheckSearchParam param);

    /**
     * 分页查询体检报告列表
     * @param param
     * @return
     */
    PageInfo<ReportVo> queryReportListPage(PhcPhysicalCheckSearchParam param);

    /**
     * 根据ID查询体检报告详情
     * @param id
     * @return
     */
    ReportVo info(Long id);

}
