package cn.smarthse.modules.health.service.work.check.checkV3221;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.earliestCheckModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckDataParam;
import cn.smarthse.services.wanda.api.entity.WandaHcRItems;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Set;

public interface IPhcPhysicalStaffCheckInfoService extends IBaseService<PhcPhysicalStaffCheckInfo> {

    /**
     * 批量保存人员体检信息
     * @param staffCheckInfoList
     */
    void batchInsertStaffCheckInfo(List<PhcPhysicalStaffCheckInfo> staffCheckInfoList);

    List<PhcPhysicalStaffCheckInfo> getStaffCheckInfoListByCheckId(Long id);
    List<PhcPhysicalStaffCheckInfo> getStaffCheckInfoListByCheck(PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch);

    /**
     * 获取体检结果
     *
     * @param param
     * @param searchVo
     * @param isSearchThirdMatch 是否同时查询机构端匹配的体检数据 1是0否
     * @return
     */
    PageInfo<PhcPhysicalStaffCheckInfo> getPhcPhysicalResult(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch);

    PhcPhysicalStaffCheckInfo getPhcPhysicalResultView(PhcPhysicalCheckSearchVo searchVo);

    PhcPhysicalStaffCheckInfo getStaffCheckInfoById(PhcPhysicalCheckSearchVo searchVo);

    /**
     * 根据结论查询列表
     * @param param
     * @param searchVo
     * @return
     */
    PageInfo<PhcPhysicalStaffCheckInfo> getListByConclusion(JqGridParam param, PhcPhysicalCheckSearchVo searchVo);

    /**
     * 根据身份证号查询人员
     *
     * @param idCard 身份证
     * @param cid
     * @return {@code PhcPhysicalStaffCheckInfo }
     * @author zhangxu
     * @date 2023-05-23
     */
    PhcPhysicalStaffCheckInfo getPhcPhysicalStaffCheckInfoByCardId(String idCard, Long cid);

    void batchInsertStaffInfo(List<StaffInfo> staffInfoList, Set<String> idcardCodeList, List<PhcPhysicalCheckData> phcPhysicalCheckDataList);

    public List<WandaHcRItems> getXfcItem(PhcPhysicalStaffCheckInfo checkInfo);

    void batchInsertPhcPhysicalCheckInfo(List<PhcPhysicalCheck> phcPhysicalCheckList, List<PhcPhysicalCheckData> phcPhysicalCheckDataList, List<PhcPhysicalCheckDataResult> phcPhysicalCheckDataResultList);

    void batchInsertReformItemBasic(List<ReformItemBasic> reformItemBasicList, List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList);

    /**
     * 用于手动设置或修改某个或多个企业的对应工作和体检项
     * @param unifiedSocialCcs
     */
    void changeGeneratedData(String unifiedSocialCcs);

    /**
     * 机构端详情list
     * @param jparam
     * @param param
     * @return
     */
    PageInfo<CheckDataInfo> pageCheckData(JqGridParam jparam, PageCheckDataParam param);

    List<PhcPhysicalStaffCheckInfo> getListByCardId(String cardId);

    JqGridData<PhcPhysicalStaffCheckInfo> laborDispatchList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo);

    /**
     * @description: 企业端 -> 职业健康检查 -> 劳务派遣单位体检清单，查询体检人员数据
     * 当机构端的体检数据上报且匹配了，才在这里查询展示。
     * @version: 3.2.2.3
     * @date: 2023/7/19 16:24
     * @param: param, searchVo
     * @return: {@link JqGridData<PhcPhysicalStaffCheckInfo>}
     * @author: DengJia 18402894534@163.com
     */
    JqGridData<PhcPhysicalStaffCheckInfo> laborDispatchAssociationMatchList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo);

    CheckDataResultInfo getCheckResultInfo(Long id);

    PhcPhysicalStaffCheckInfo getByCardIdWhereSource2(Long dataId);

    List<PhcPhysicalStaffCheckInfo> getLIstByCardIds(List<String> cardIds);

    /**
     * 推送疑似职业病和职业禁忌症风险
     */
    void pushRisk(Long cid);

    List<PhcPhysicalCheckV3221> countYszybNum(List<Long> cids,Integer year);
    List<PhcPhysicalStaffCheckInfo> queryCompliancePhysicalCheckInfo(List<Long> cids);

    /**
     * 查询人员的体检数据
     * @param searchVo
     * @return
     */
    List<PhcPhysicalStaffCheckInfo> getStaffCheckList(PhcPhysicalCheckSearchVo searchVo);

    PageInfo<PhcPhysicalStaffCheckInfo> getStaffCheckListPage(JqGridParam gparam,PhcPhysicalCheckSearchVo searchVo);

    List<PhcPhysicalStaffCheckInfo> getByCidIdCard(List<Long> cids, Set<String> idCardSet);
    List<PhcPhysicalStaffCheckInfo> settingDicValue(List<PhcPhysicalStaffCheckInfo> list);

    /**
     * 查询最早的体检日期
     * @param cid
     * @param idCard
     * @return
     */
    List<earliestCheckModel> getEarliestPhcDate(List<Long> cidList,List<String> idCardList);

    List<PhcPhysicalStaffCheckInfo> getNotConvertCfbYszybList(String unifiedSocialCc);

    /**
     * 体检删除记录
     * @param unifiedSocialCc
     * @return
     */
    PageInfo<PhcPhysicalStaffCheckInfo> getDelStaffListPage(JqGridParam gparam,String keyword,Long cid);

    List<PhcPhysicalStaffCheckInfo> getBySourceId(Long checkId);

    /**
     * 批量删除体检人员信息根据phc_physical_check_v3221的id
     * @param sourceId
     * @param loginUserId
     */
    void batchDelectStaffCheckInfoBySourceId(Long sourceId,Long loginUserId);
}
