package cn.smarthse.modules.health.service.work.check.checkV3221;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.Company;
import cn.smarthse.modules.health.entity.work.check.checkV3221.*;
import cn.smarthse.modules.health.model.phyphcCheck.PhyPhcCheckCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDetailInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckListInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckListParam;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface IPhcPhysicalCheckV3221Service extends IBaseService<PhcPhysicalCheckV3221> {

    /**
     * 查询转换次数
     * @param unifiedSocialCcList
     */
    PageInfo<String> getPage(List<String> unifiedSocialCcList, Integer page, Integer pageSize);

    /**
     * 数据转换
     * @param unifiedSocialCcList
     * @param page
     * @param pageSize
     */
    List<String> convertedData(List<String> unifiedSocialCcList, Integer page, Integer pageSize) throws Exception;

    void appendPhysicalCheckData(String unifiedSocialCc);

    /**
     * 追加credit_code_employer的体检数据
     * @param unifiedSocialCc
     */
    void appendEmpCreditCodeData(String unifiedSocialCc);

    List<Company> getEmpCreditCodeList(int pageNum, int pageSize, String unifiedSocialCcs);

    void correctData(String unifiedSocialCc);


    /**
     * 检查数据是否正确，不正确删除重新转换
     * @param cid
     */
    void checkAndCorrect(Long cid);

    /**
     * 获取年份列表
     * @param searchVo
     * @return
     */
    List<Integer> getYearList(PhcPhysicalCheckSearchVo searchVo);

    /**
     * 获取种类列表
     * @param searchVo
     * @return
     */
    Map<String, String> getBodyCheckTypeList(PhcPhysicalCheckSearchVo searchVo);

    PageInfo<PhcPhysicalCheckV3221> getPageInfoBySearchVo(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch);

    List<PhcPhysicalCheckV3221> getListDataBySearchVo(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch);

    /**
     * 获取体检项目详情
     * @param searchVo
     * @return
     */
    PhcPhysicalViewModel getViewById(PhcPhysicalCheckSearchVo searchVo);

    /**
     * 获取体检项目详情 包含企业数据和从机构端匹配来的数据
     * @param searchVo
     * @param isSearchThirdMatch 是否同时查询机构端匹配的体检数据 1是0否
     * @return
     */
    PhcPhysicalViewModel getViewAssociativeMatchDataById(PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch);

    /**
     * 数据转换定时任务
     */
    void phcPhysicalCheckTask(String unifiedSocialCcs, Date endTime);

    /**
     * 获取年度企业统计
     * @param searchVo
     * @return
     */
    PhcPhysicalStatisticsModel getStatisticsModel(PhcPhysicalCheckSearchVo searchVo);

    /**
     * 风险化解管理自动验收查询检测接口
     * @param cidList
     * @return
     */
    Map<Long, PhcPhysicalCheckV3221> getCheckMapByCid(List<Long> cidList);

    /**
     *  最近一年体检的企业数(如果传了year的话就查当年的)
     * @param areaId
     * @param areaLevel
     * @param year
     * @param finalOwnLevel
     * @return
     */
    int getHcCheckNumByByAreaAndYear(Long areaId, Byte areaLevel, Integer year, Byte finalOwnLevel);


    /**
     * 获取企业体检信息
     * 1体检时间：（最近一个有数据的年份中，第一个有数据的日期和最后一个有数据的日期）
     * 2体检人数：最近一个有在岗期间体检数据的年份，历次体检人数是之和（去重）
     * @param cid
     * @return
     */
     Map<Long, PhyPhcCheckCompanyInfo>getPhyPhcCompanyInfo(Long cid);

    CheckDetailInfo getCheckDetailById(Long id);

    /**
     * 机构端上报使用
     * @param checkDetail
     * @return
     */
    CheckDetailInfo saveInfo(CheckDetailInfo checkDetail);

    void saveResult(CheckDataResultInfo resultInfo);

    PageInfo<CheckListInfo> thirdOrgPage(JqGridParam jparam, PageCheckListParam param);


    List<PhcPhysicalCheckV3221> lastUpdatePhcCheck(Date updateDate);

    void deleteByCardIds(String sourceIds);

    void insertCheckDataBatch(List<CheckDataResultInfo> checkDataBatch);

    /**
     * 通过主表phc_physical_check_v3221.source_id查找人员信息
     *
     * @param id id
     * @return {@code PhcPhysicalStaffCheckInfo }
     * @author zhangxu
     * @date 2023-07-27
     */
    List<PhcPhysicalStaffCheckInfo> getPhcPhysicaStaffCheckInfoV3221(Long id);

    /**
     * 查询体检数据数量
     * @param searchVo
     * @return
     */
    Long getCountBySearchVo(PhcPhysicalCheckSearchVo searchVo);

    Integer[] checkStaffNum(Long cid);


    /**
     * 查询在岗体检数据
     * @param loginStaffCompanyId
     * @return
     */
    List<PhcPhysicalCheckV3221> getOnWorkListByCid(Long loginStaffCompanyId);

    /**
     * 获取最近一次体检机构
     * @param cids
     * @return
     */
    Map<Long, String> getLastCheckOrgName(List<Long> cids);

    List<PhcPhysicalStatisticsModel> queryCompliancePhysical5Data(List<Long> cids,Integer year);

    void staticsCompanyAppendInfo();

    void resetConverted(Integer customBatchSize);
}
