package cn.smarthse.modules.health.service.work.check.checkV3221;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.disease.Disease;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.model.phyphcCheck.AddCheckStaffModel;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckProjectVo;
import cn.smarthse.modules.health.model.phyphcCheck.CheckDetailModel;
import cn.smarthse.modules.health.model.phyphcCheck.CheckProjectModel;
import cn.smarthse.modules.health.model.phyphcCheck.CheckSubmitModel;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.github.pagehelper.PageInfo;

/**
 * @ author Supw
 * @ since 2024/11/19 16:35
 */
public interface IPhcPhysicalCheckV3221OrgService extends IBaseService<PhcPhysicalCheckV3221> {


    /**
     * 提交体检报告
     * @param model
     * @return
     */
    CheckDetailModel submit(CheckSubmitModel model,Long operatorId);

    CheckDetailModel info(Long checkId);

    /**
     * 查询体检项目列表
     * @param model
     * @param param
     * @return
     */
    PageInfo<PhcPhysicalCheckProjectVo> getCheckProjectList(CheckProjectModel model, JqGridParam param);


    /**
     * 删除体检项目数据
     * @param model
     */
    void delCheckProject(CheckProjectModel model);

    /**
     * 新增或更新 单条 体检人员
     * @param model
     */
    void addOrUpdateCheckStaff(List<AddCheckStaffModel> modelList,Long operatorId);


    /**
     * 体检人员列表
     * @param checkId
     * @param conclusion
     * @return
     */
    List<AddCheckStaffModel> checkStaffList(Long checkId,String conclusion,String keyword);
    AddCheckStaffModel getCheckStaff(Long id);

    /**
     * 体检人员列表分页查询
     * @param pageParam
     * @param checkId
     * @param conclusion
     * @return
     */
    PageInfo<AddCheckStaffModel> checkStaffListPage(JqGridParam pageParam, Long checkId, String conclusion, String keyword);

//    /**
//     * 体检人员导入
//     * @param contents
//     */
//    void importCheckStaffBatch(List<List<String>> contents,Long checkId);

    /**
     * 检查体检人员信息  身份证和名字在系统中是否能对上
     * @param checkId
     * @param modelList
     * @return
     */
    Map<String, Map<String,String>> checkStaffInfo(Long checkId, List<AddCheckStaffModel> modelList);

    /**
     * 删除体检人员
     * @param checkStaffId
     */
    void delCheckStaff(List<Long> checkStaffId);

    Map<Integer, Disease> queryAbnormalName(List<Integer> AbnormalCodeList);
}
