/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckRecommendIgnored;
import cn.smarthse.modules.health.entity.work.check.vo.*;
import cn.smarthse.modules.health.model.HHealthCheckModel;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveFileVo;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveStaffGroup;
import cn.smarthse.modules.health.pojo.HealthCheckArchiveStaffInfo;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.work.check.CheckTipQuery;
import cn.smarthse.modules.health.vo.work.check.CheckWorkIdVO;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPhcPhysicalCheckService extends IBaseService<PhcPhysicalCheck>,IPlanYearWorkService{

	PageInfo<PhcPhysicalCheck> getListByQuery(int pageIndex,PhcPhysicalCheckParam check);
	
	PhcPhysicalCheck getDetailById(Long id);
	
	PhcPhysicalCheck insertOrUpdate(PhcPhysicalCheck data, Long cid, Long staffId);

	PhcPhysicalCheck finishedInfo(PhcPhysicalCheck data, Long cid, Long staffId);


	void deleteByIds(String ids, Long staffId,Long cid);

	List<PhcPhysicalCheck> listDetails(PhcPhysicalCheckParam data);

	PageInfo<PhcPhysicalCheck> getList(JqGridParam gparam, PhcPhysicalCheckParam param);

	PageInfo<PhcPhysicalCheck> getReportPage(JqGridParam gparam, PhcPhysicalCheckParam param);


	Integer getReportNum(PhcPhysicalCheckParam param);


	Map<Integer,Map<String,Integer>> getCheckTypeNum(PhcPhysicalCheckParam param);
	
	/**
	 * 
	 * 
	 * @Comments: 统计某年的体检信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月10日-下午1:50:38
	 * @param params
	 * @return
	 */
	PhcYearCheckInfo countYearCheckInfo(PhcYearCheckInfo params);
	
	/**
	 * 
	 * 
	 * @Comments:  导入体检数据
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月12日-下午12:35:14
	 * @param contents
	 * @param param
	 * @param cid
	 * @param createBy
	 * @return
	 */
	List<String>  importCheckResult(List<List<String>> contents,PhcPhysicalCheckQuery param,Long cid,Long createBy);

	/**
	 * 
	 * 
	 * @Comments: 未上报的体检
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月24日-上午10:48:13
	 * @param data
	 * @return
	 */
	List<PhcPhysicalCheck> unreportList(PhcPhysicalCheckParam data);
	
	/**
	 * 
	 * 
	 * @Comments: 某企业，某年是否有体检
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月25日-下午3:01:00
	 * @param query
	 * @return
	 */
	Boolean hasThisYearChecked(CheckTipQuery query);
	
	/**
	 * 
	 * 
	 * @Comments: 体检已告知次数
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月1日-下午12:03:43
	 * @param data
	 * @return
	 */
	Integer countConfired(PhcPhysicalCheckParam data);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取员工体检数量>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月9日-下午7:00:06
	 * @param param（cid必填，其余选填）
	 * @return
	 */
	Integer getStaffCheckCount(PhcPhysicalCheckParam param);
	
	/**
	 * 获取去年最近一次体检的开始时间
	 * @param query
	 * @return
	 */
	Date getLastYearCheckDate(CheckTipQuery query); 
	
	/**
	 * 获取体检信息列表
     * 用户身份证号,企业ID,年月 查询体检信息
     * <li>按时间倒序显示；
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年1月5日-下午3:09:44
	 * @param paramModel
	 * @return
	 */
	List<HHealthCheckModel> getHealthCheckList(PageParamModel paramModel);

	PageInfo<HHealthCheckModel> getHealthCheckPage(PageParamModel paramModel);
	
	/**
	 * 
	 * 获取体检异常信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年1月5日-下午3:56:13
	 * @param param
	 * @return
	 */
	HHealthCheckModel getHealthCheckList(HHealthCheckParam param);
	
	/**
	 * 
	 * @Comments:  <体检推荐人员清单（在岗期间职业健康检查）>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年1月25日-下午3:22:20
	 * @param param
	 * @param query
	 * @return
	 */
	PageInfo<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param,HealthCheckStaffInfoQuery query);
	
	List<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfos(HealthCheckStaffInfoQuery query);
	/**
	 * 
	 * 
	 * @Comments:  <作废>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年4月10日-下午2:20:40
	 * @param ids（多个以逗号隔开）
	 * @param staffId
	 * @param cid
	 */
	void cancelByIds(String ids, Long staffId, Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <最后一次在岗期间职业健康体检的体检时间。>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月2日-上午11:22:09
	 * @param cid
	 * @return
	 */
	Date getLastPhcCheckDateJobing(Long cid);
	/**
	 * @Comments:  <指定年份 最早的一次体检时间>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2022/3/31-18:07
	 * @param cid
	 * @param year
	 * @return java.util.Date
	*/
	Date getFirstPhcCheckDateByCidAndCheckTypeAndYear(Long cid, Integer year);

	/**
	 * 
	 * 
	 * @Comments:  <职业健康检查已完成清单（18-030）中种类为在岗期间职业健康检查的记录条数。>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月2日-上午11:39:50
	 * @param cid
	 * @return
	 */
	int getPhcCheckNumJobing(Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <获取职业健康体检信息>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月2日-上午11:49:00
	 * @param cid
	 * @return
	 */
	PhcCheckInfo getPhcCheckInfo(Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <（18-148）年度人员体检结果汇总>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年10月31日-下午4:07:53
	 * @param gparam
	 * @param param
	 * @return
	 */
	PageInfo<StaffCheckCountResult> getStaffCheckPage(JqGridParam gparam, StaffCheckCountParam param);

	/**
	 * 年度人员体检 人员id
	 * @param cid 企业id
	 * @param year 年份
	 * @return
	 */
	List<Long> getHealthCheckStaffIds(Long cid, Integer year);

	List<StaffCheckCountResult> getStaffCheckList(StaffCheckCountParam param);

	PageInfo<HealthCheckStaffInfoVo> getBeforeRecommendHealthCheckStaffInfosPageBySearch(JqGridParam gparam, HealthCheckStaffInfoQuery query);

	List<HealthCheckStaffInfoVo> getBeforeRecommendHealthCheckStaffInfos(HealthCheckStaffInfoQuery query);

	PageInfo<HealthCheckStaffInfoVo> getLeaveRecommendHealthCheckStaffInfosPageBySearch(JqGridParam gparam, HealthCheckStaffInfoQuery query);

	List<HealthCheckStaffInfoVo> getLeaveRecommendHealthCheckStaffInfos(HealthCheckStaffInfoQuery query);

    void ignoreStaff(PhcPhysicalCheckRecommendIgnored data, Long loginStaffId, Long cid);

    List<CheckWorkIdVO> getCheckWorks(Long cid, int year);


     Map<String,List<PhcPhysicalCheckData>> getHuadongCheckDataByCheck(PhcPhysicalCheckQuery param);

     List<HudongSysStaffInfoVo> getAllStaffInfoListByCid(Long cid);

	/**
	 * 查询体检机构
	 * @param cid 体检企业id
	 * @param year  体检年份
	 * @return
	 */
	 List<Long> queryHospital(Long cid, Long year);


	/**
	 * 根据体检机构资质查询文件id
	 * @param cid
	 * @param year
	 * @return
	 */
	 List<Long> getInstitutionalQualificationFileIdsByCidAndYear(Long cid, Long year);


	/**
	 *@author DengLibin
	 *@date 2021-12-22 14:38:06
	 * 体检清单
	 * @param cid 企业id
	 * @param year 年份
	 * @return
	 */
	 List<HealthCheckArchiveFileVo> queryHealthArchiveVo(Long cid, Integer year);


	/**
	 * 体检异常人员 2、复查 3、疑似职业病 4、职业禁忌症
	 * @param cid
	 * @return
	 */
	List<HealthCheckArchiveStaffInfo> queryHealthCheckArchiveStaffInfo(Long cid);

	/**
	 * 体检异常人员-分组 2、复查 3、疑似职业病 4、职业禁忌症
	 * @param cid
	 * @return
	 */
	List<HealthCheckArchiveStaffGroup> queryHealthCheckArchiveStaffInfoGroup(Long cid);


	/**
	 * 企业实检人数
	 * @param cid
	 * @return 【上岗实检，在岗实检，离岗实检】
	 */
	Integer[] checkStaffNum(Long cid);


	Integer getCheckNumByCid(Long cid,Integer year);

	/**
	 * 根据年份获取当年份的体检机构ID
	 * @param cid
	 * @param year
	 * @return
	 */
    List<Long> getThirdOrgIdByYear(Long cid, int year);

    WandaDeclare getLastOneWandaDeclareByCid(Long cid);

}
