/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.common.util.excel.ExcelContent;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.vo.*;
import com.github.pagehelper.PageInfo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPhcPhysicalCheckDataService extends IBaseService<PhcPhysicalCheckData>{

   /** 
   * @Comments:  <根据条件获取所有体检结果汇总人员数量>
   * @author BinXu(徐斌) [784514607@qq.com]
   * @since 上午9:35 2021/2/25
   **/
    Integer getAllCheckResultStaffCountByByQuery(PhcPhysicalCheckQuery query);

    /**
	 * 
	 * @Comments:  获取体检数据列表
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月18日-下午5:26:14
	 * @param query
	 * @return
	 */
	List<PhcPhysicalCheckDataVO> listDatas(PhcPhysicalCheckQuery query);
	
	/**
	 * 
	 * @Comments:  获取体检数据分页列表
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月18日-下午5:25:51
	 * @param gparam
	 * @param param
	 * @return
	 */
	PageInfo<PhcPhysicalCheckDataVO> getList(JqGridParam gparam, PhcPhysicalCheckQuery param);
	
	/**
	 * 
	 * @Comments: 根据id获取体检数据详情包括体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月18日-下午5:23:37
	 * @param query
	 * @return
	 */
	PhcPhysicalCheckData getDataDetailById(PhcPhysicalCheckData query);
	
	PhcPhysicalCheckData insertOrUpdate(PhcPhysicalCheckData data,Long staffId,Long cid);

	/**
	 * 
	 * @Comments:  根据人员id，体检id，体检类型和体检结果获取已存在的数据
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月20日-下午2:27:40
	 * @param query
	 * @return
	 */
	PhcPhysicalCheckData getDataDetailByQuery(PhcPhysicalCheckData query);
	
	/**
	 * 
	 * @Comments:  根据人员id，体检id，体检类型和体检结果判断该人员的体检结果是否已存在
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月20日-下午2:27:40
	 * @param query
	 * @return
	 */
	Boolean hasDataExist(PhcPhysicalCheckData query);

	PageInfo<PhcPhysicalCheckDataVO> getRecheckPage(JqGridParam gparam, PhcPhysicalCheckQuery param);

	List<PhcPhysicalCheckData> getByCheckInfo(PhcPhysicalCheckQuery param);

	List<PhcPhysicalCheckData> getHuadongByCheckInfo(PhcPhysicalCheckQuery param);

	void deleteByInfo(PhcPhysicalCheckData data);

	void deleteById(Long id);

	PhcPhysicalCheckData addStaffs(PhcPhysicalCheckData data, String staffIds, Long staffId, Long cid);
	
	/**
	 * 
	 * 
	 * @Comments:  统计体检类型的体检人数和应检人数
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月15日-下午2:01:03
	 * @param query(cid、开始、结束年份必填)
	 * @return
	 */
	List<PhcPhysicalCheckTypeInfo> checkTypesInfo(PhcPhysicalYearCountQuery query);
	
	void deleteByCheck(PhcPhysicalCheck check);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取员工第一次体检的开始时间>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月28日-下午2:58:06
	 * @return
	 */
	Date getStaffFirstCheckBeginTime(Long staffId);

	List<PhcPhysicalCheckDataVO> selectStaff(PhcPhysicalCheckQuery param);

	/**
	 *
	 *
	 * @Comments:  <根据体检id查询对应体检类型中实际填写人员数量>
	 * @author yangzp
	 * @since 2020年10月13日-下午1:24:15
	 * @return list
	 */

	Integer selectCountByCheckIdAndType(PhcPhysicalYearCountQuery query);
	/*
	 * @Description:获取体检结果确认情况人员列表
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2021/4/22 10:30
	 * @param: [checkId, confirmationType]
	 * @return: com.github.pagehelper.PageInfo<cn.smarthse.modules.health.entity.work.check.vo.StaffCheckCountResult>
	 **/
	PageInfo<StaffCheckCountResult> getConfirmationStaffList(JqGridParam gparam,Long checkId, Byte confirmationType);

    PhcPhysicalCheckData getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(Long cid,Long checkId, Long staffId, Byte checkType);


    void addExistCheckResults(Map<Long,List<ArrayList<ExcelContent>>> existedStaffInfosMap, Long checkId, Byte checkType, Long loginStaffId, Long cid);

    void addNeedAddStaffInfosCheckResults(List<ArrayList<ExcelContent>> needAddStaffInfos, Long checkId, Byte checkType, Long loginStaffId, Long cid);

    void addNeedUpdateStaffInfosCheckResults(Map<Long, List<ArrayList<ExcelContent>>> needUpdateStaffInfosMap, Long checkId, Byte checkType, Long loginStaffId, Long cid);

	/**
	 * 体检类型人员数量
	 * @param cid
	 * @param checkYear 体检年份
	 * @return 上岗 在岗 离岗时 复查 应急 离岗后
	 */
	Integer[] checkTypeUserCount(Long cid, Integer checkYear);
}
