/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.check;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhyCheckDataResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.*;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table3;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table4_1;
import com.github.pagehelper.PageInfo;

import java.util.List;


//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPhcPhysicalCheckDataResultService extends IBaseService<PhcPhysicalCheckDataResult>{

	void updateResultsByData(PhcPhysicalCheckData data);
	
	List<PhcPhysicalCheckDataResult> listResults(PhcPhysicalCheckData query);
	
	List<PhcPhysicalCheckDataResult> listOtherResults(PhcPhysicalCheckData query);

	void deleteByDataId(String id);
	
	List<PhcPhysicalCheckAbnormal> getAbnormalList(PhcPhysicalCheckAbnormalParam param);
	List<PhcPhysicalCheckAbnormal> getAbnormalListV3_1(PhcPhysicalCheckAbnormalParam param);
	/**
	 * 根据体检id获取体检中为疑似职业病人数
	 * */
	int countSDieasers(Long checkId);
	
	PageInfo<PhcPhysicalCheckAbnormal> getAbnormalPage(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param);
	PageInfo<PhcPhysicalCheckAbnormal> getAbnormalPageV3_1(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param);

	int getAbnormalCount(PhcPhysicalCheckAbnormalParam param);
	
	void updateDealInfo(PhcPhysicalCheckDataResult result,Long staffId,Long cid);
	
	PhcPhysicalCheckDataResult getResultInfoById(Long id);
	
	PhcPhysicalCheckResultDeal getResultDealInfo(PhcPhysicalCheckDataResult result);

	void rechckInfoPost(PhcPhysicalCheckRechckDataVO recheckData, Long staffId, Long cid);

	List<Long> getNormalStaffIdsByCheck(PhcPhysicalCheckQuery param);

	void deleteByInfo(PhcPhysicalCheckDataResult result);

	void deleteByData(PhcPhysicalCheckData data);
	/**
	 * 
	 * 
	 * @Comments:  根据员工id获取员工的体检信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月14日-下午4:58:59
	 * @param staffId
	 * @return
	 */
	PageInfo<PhcPhysicalPersonInfo> getPersonCheckInfo(JqGridParam gparam, Long staffId);
	List<PhcPhysicalPersonCheckInfo> getPersonCheckInfoList(Long staffId);

	/**
	 * 
	 * 
	 * @Comments:  统计体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月15日-下午3:45:38
	 * @param query(cid、开始、结束年份必填、部门/岗位标识必填默认为部门)
	 * @return
	 */
	List<PhcPhysicalCheckResultInfo> countResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments:  统计部门/岗位体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月15日-下午3:45:38
	 * @param query(cid、开始、结束年份必填)
	 * @return
	 */
	List<PhcPhysicalResultInfo> getResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments:  统计年份体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月17日-上午10:37:30
	 * @param query(cid、开始、结束年份必填)
	 * @return
	 */
	List<PhcPhysicalResultInfo> getYearResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments:  统计岗位/部门年份体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月17日-上午11:35:05
	 * @param query(cid、开始、结束年份必填、部门/岗位标识必填默认为部门)
	 * @return
	 */
	List<PhcPhysicalResultInfo> getDeptOrWorkYearResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments:  获取体检基本信息,并统计体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月18日-上午11:47:55
	 * @param query
	 * @return
	 */
	List<PhcPhysicalQueryCheckInfo> queryCheck(PhcPhysicalQueryCheck query);
	
	/**
	 * 
	 * 
	 * @Comments:  获取体检下的异常人员信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月18日-下午2:49:55
	 * @param param
	 * @return
	 */
	List<PhcPhysicalCheckAbnormalInfo> queryCheckAbnormalResult(PhcPhysicalCheckParam param);
	
	/**
	 * 
	 * 
	 * @Comments:  获取已告知的体检
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月28日-上午10:53:38
	 * @param param(cid：企业id 必填、keyword：编号/名称、checkType：体检类型、beginTime、endTime：体检查询时间)
	 * @return
	 */
	PageInfo<PhcPhysicalCheckConfiredInfo> getConfirmedCheck(JqGridParam gparam,PhcPhysicalCheckParam param);
	
	/**
	 * 
	 * 
	 * @Comments:  获取已告知的体检列表
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月16日
	 * @param param(cid：企业id 必填、keyword：编号/名称、checkType：体检类型、beginTime、endTime：体检查询时间)
	 * @return
	 */
	List<PhcPhysicalCheckConfiredInfo> getConfirmedCheckList( PhcPhysicalCheckParam param);
	
	/**
	 * 
	 * 
	 * @Comments:  获取已告知的体检列表
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月4日-下午6:02:59
	 * @param cid
	 * @param year
	 * @return
	 */
	List<PhcPhysicalCheckConfiredInfo> getConfirmedCheckList(Long cid,Integer year);
	
	/**
	 * 
	 * 
	 * @Comments:  根据体检信息统计体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月30日-下午3:12:03
	 * @param infos
	 */
	void countCheck(List<PhcPhysicalQueryCheckInfo> infos);
	
	/**
	 * 
	 * 
	 * @Comments:  获取体检人员体检结果及处理情况
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月1日-下午2:09:22
	 * @param param
	 * @return
	 */
	List<PhcPhysicalCheckResultDeal> getCheckResultAndDealInfo(PhcPhysicalCheckParam param);
	
	/**
	 * 
	 * 
	 * @Comments: 获取个人历次职业健康检查结果及处理情况
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月8日-下午12:11:29
	 * @param staffId
	 * @return
	 */
	List<Doc6Table3> doc6Table3(Long staffId);
	
	/**
	 * 
	 * 
	 * @Comments:  员工个体结论报告
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月8日-下午2:12:06
	 * @param staffId
	 * @return
	 */
	List<Doc6Table4_1> doc6Table4_1(Long staffId);
	
	/**
	 * 
	 * 
	 * @Comments:  获取疑似职业病人中处理为职业病诊断的信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月29日-上午11:09:11
	 * @param param（staffId,checkId必填）
	 * @return
	 */
	List<PhcPhysicalCheckAbnormal> getSuspectDiseaseList(PhcPhysicalCheckAbnormalParam param);
	
	/**
	 * 
	 * 
	 * @Comments:  根据体检id获取疑似职业病人信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月27日-下午2:51:12
	 * @param checkId
	 * @return
	 */
	void addSuspectedDiseasersByCheckId(Long checkId);

	void deleteDieasersByCheckIds(List<Long> idArray);
	
	/**
	 * 
	 * 
	 * @Comments:  <修改病例时，删除原有的病例>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年9月10日-下午3:16:39
	 * @param dataId
	 * @param examResult
	 */
	void deleteByDataIdAndExamResult(Long dataId,Byte examResult);

    PageInfo<PhcDieaserUnprocessInfo> getSDPage(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param);

	Integer getSDNum( PhcPhysicalCheckAbnormalParam param);
	//疑似职业病患者
	PageInfo<PhcDieaserUnprocessParam> getPatientData(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param);
	List<PhcDieaserUnprocessParam> getPatientDataByCid(Long cid);

    PageInfo<PhcDieaserUnprocessInfo> listOCData(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param);

	Integer getOCNum( PhcPhysicalCheckAbnormalParam param);

	PageInfo<PhcDieaserUnprocessInfo> listRecheckData(JqGridParam gparam, PhcPhysicalCheckAbnormalParam param);

	Integer getRecheckNum( PhcPhysicalCheckAbnormalParam param);

	PhcSDInfo getSDById(Long resultId);

    void rechckBatchPost(PhcPhysicalCheckDataResult data, Long staffId, Long cid);

	/**
	 * 获取体检结果详情
	 * @param id
	 * @return
	 */
	PhyCheckDataResultInfo getCheckResultInfo(Long id);

	/**
	 *@author DengLibin
	 *@date 2021-12-22 15:03:39
	 * 根据体检结果查询
	 * @param checkId
	 * @return
	 */
    List<PhcPhysicalCheckDataResult> queryByCheckId(Long checkId);

	/**
	 * 更新监管端状态
	 * @param resultId
	 * @param superviseStatus 监管端状态（0：未处理，1：企业端已上报（企业整改上报时改为该状态），2：已忽略，3：已确认
	 */
	void updateSuperviseStatus(Long resultId, Integer superviseStatus);

	PhcPhysicalCheckDataResult getDataResultByStaffId(Long staffId,String workName);
}
