/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.check;

import java.util.Date;
import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedDetail;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedStaff;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCountInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultGroupCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckTypeInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table4_2;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;


public interface IPhcPhysicalCheckCountService {
	
	/**
	 * 
	 * 
	 * @Comments:  体检数据汇总  体检率
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月15日-下午2:10:53
	 * @param query(cid、开始、结束年份必填)
	 * @return
	 */
	List<PhcPhysicalCheckTypeInfo> checkTypesInfo(PhcPhysicalYearCountQuery query);	

	/**
	 * 
	 * 
	 * @Comments:  体检数据汇总  体检结论汇总
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月15日-下午5:29:04
	 * @param query(cid、开始、结束年份必填)
	 * @return
	 */
	PhcPhysicalCheckResultCount countResult(PhcPhysicalYearCountQuery query);
	/**
	 * 
	 * 
	 * @Comments:  体检数据汇总  体检种类划分
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月15日-下午5:29:09
	 * @param query(cid、开始、结束年份必填)
	 * @return
	 */
	List<PhcPhysicalCheckResultCount> countCheckTypeResult(PhcPhysicalYearCountQuery query);	
	
	/**
	 * 
	 * 
	 * @Comments: 异常情况汇总 岗位/工种
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月16日-上午11:25:10
	 * @param query(cid、开始、结束年份必填,deptOrWork：dept岗位，work工种默认dept)
	 * @return
	 */
	PhcPhysicalCheckResultGroupCount countWorkResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments: 历年体检结论趋势
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月17日-上午10:40:21
	 * @param query(cid、开始、结束年份必填,deptOrWork：dept岗位，work工种默认dept)
	 * @return
	 */
	List<PhcPhysicalCheckResultGroup> countYearResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments:  历年岗位或工种体检结论趋势
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月17日-下午1:34:28
	 * @param query(cid、开始、结束年份必填,deptOrWork：dept岗位，work工种默认dept)
	 * @return
	 */
	List<PhcPhysicalCheckResultCountInfo> countDeptOrWorkYearResultInfo(PhcPhysicalYearCountQuery query);
	
	/**
	 * 
	 * 
	 * @Comments:  获取相关的体检基本信息,并统计体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月18日-上午11:47:55
	 * @param query
	 * @return
	 */
	PageInfo<PhcPhysicalQueryCheckInfo> queryCheckList(JqGridParam gparam,PhcPhysicalQueryCheck query);
	
	/**
	 * 
	 * 
	 * @Comments:  获取体检基本信息,并统计体检结果
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月18日-下午2:06:10
	 * @param checkId
	 * @param checkType
	 * @return
	 */
	PhcPhysicalQueryCheckInfo queryCheckInfo(Long checkId,Byte checkType);
	
	/**
	 * 
	 * 
	 * @Comments:  获取体检的异常人员信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月18日-下午2:59:11
	 * @param checkId
	 * @param checkType
	 * @param keyword
	 * @return
	 */
	List<PhcPhysicalCheckAbnormalInfo> queryCheckAbnormalResult(Long checkId,Byte checkType,String keyword);
	
	/**
	 * 
	 * 
	 * @Comments:  获取体检的异常人员分页信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年8月23日-上午9:26:58
	 * @param gparam
	 * @param query（checkId、checkType必填，keyword选填）
	 * @return
	 */
	PageInfo<PhcPhysicalCheckAbnormalInfo> queryCheckAbnormalResult(JqGridParam gparam,PhcPhysicalCheckParam query);
	
	/**
	 * 
	 * 
	 * @Comments:  体检已告知次数
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月1日-下午2:57:32
	 * @param cid
	 * @param year
	 * @return
	 */
	Integer checkConfiredTimes(Long cid, String year);
	
	/**
	 * 
	 * 
	 * @Comments: 职业卫生开展情况汇总
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月1日-下午3:09:48
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);
	
	/**
	 * 
	 * 
	 * @Comments:  档案2职业病已告知清单
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月7日-下午4:39:54
	 * @param cid
	 * @param year
	 * @return
	 */
	List<PhcDiseaserConfirmedStaff> getConfirmedListByQuery(Long cid,Integer year);
	
	/**
	 * 
	 * 
	 * @Comments:  <职业病已告知分页>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月7日-下午4:40:26
	 * @param gparam
	 * @param query
	 * @return
	 */
	PageInfo<PhcDiseaserConfirmedDetail> getConfirmedPageByQuery(JqGridParam gparam,PhcDiseaserUnProcessParam query);
	
	/**
	 * 
	 * 
	 * @Comments:  <职业病已告知列表>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月16日
	 * @param gparam
	 * @param query
	 * @return
	 */
	List<PhcDiseaserConfirmedDetail> getConfirmedListByQuery(PhcDiseaserUnProcessParam query);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取职业病诊断告知次数>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月17日
	 * @param param
	 * @return
	 */
	Integer getConfirmedCountByYear(Long cid,String year);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取职业病诊断信息>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月8日-上午11:17:16
	 * @param staffId
	 * @param year
	 * @return
	 */
	List<PhcDiseaserConfirmedDetail> getDiseaserListByQuery(Long staffId,Integer year);
	
	/**
	 * 
	 * 
	 * @Comments:  职业病诊断证明书
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月8日-下午2:40:40
	 * @param staffId
	 * @return
	 */
	List<Doc6Table4_2> doc6Table4_2(Long staffId);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取员工第一次体检的开始时间>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月28日-下午2:58:06
	 * @return
	 */
	Date getStaffFirstCheckBeginTime(Long staffId);

}
