/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.check;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.check.PhcDiagnoseDiseaseProcess;
import cn.smarthse.modules.health.entity.work.check.PhcOccupationalDiseaser;
import cn.smarthse.modules.health.entity.work.check.vo.*;
import com.github.pagehelper.PageInfo;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
  * 
  * 《》
  * 
  * 
  * @Project:  smarthse-facade
  * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
  * @Comments:  职业病人
  * @JDK version used:      <JDK1.7> 
  * @author yanao [ya@smarthse.cn]
  * @since 2017年8月8日-下午2:31:14
  */
//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IPhcOccupationalDiseaserService extends IBaseService<PhcOccupationalDiseaser>{

	PageInfo<PhcOccupationalDiseaserVo> getList(JqGridParam gparam, PhcOccupationalDiseaserParam param);

	 PageInfo<PhcSuperviseOccupationalDiseaserVo> listSuperviseData(JqGridParam gparam, PhcOccupationalDiseaserParam param);

	Integer getSuperviseNum(PhcOccupationalDiseaserParam param);

	PhcOccupationalDiseaser getDetailById(Long id);

	List<PhcOccupationalDiseaserVo> listDetails(PhcOccupationalDiseaserParam param);

	void deleteByIds(String ids, Long staffId);

	PhcOccupationalDiseaser insertOrUpdate(PhcOccupationalDiseaser data, Long cid, Long staffId);

	void addByProcess(PhcDiagnoseDiseaseProcess data, Long cid, Long staffId);

	Integer countYearDiseasers(PhcYearCheckInfo params);

	List<PhcPhysicalResultInfo> getResultInfo(PhcPhysicalYearCountQuery query);
	
	List<PhcPhysicalResultInfo> getDeptOrWorkYearResultInfo(PhcPhysicalYearCountQuery query);	
	
	/**
	 * 
	 * 
	 * @Comments:  <获取职业病诊断告知清单>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月7日-下午4:35:44
	 * @param param
	 * @return
	 */
	List<PhcDiseaserConfirmedDetail> getConfirmedListByQuery(PhcDiseaserUnProcessParam param);
	 List<PhcDiseaserConfirmedDetail> getConfirmedListFromViewByQuery(PhcDiseaserUnProcessParam param);
	/**
	 * 
	 * 
	 * @Comments:  <职业病诊断证明书>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月8日-下午2:35:35
	 * @param param
	 * @return
	 */
	List<PhcDiseaserConfirmedDetail> doc6Table4_2(PhcDiseaserUnProcessParam param);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取职业病信息>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年10月24日-下午5:24:05
	 * @param param
	 * @return
	 */
	List<PhcDiseaserConfirmedDetail> getDiseaserInfosByQuery(PhcDiseaserUnProcessParam param);
	
	/**
	 * 
	 * 获取三年内，职业病新增病例数
	 * 诊断时间在三年以内的记录条数，同一个人可以计多次。
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月1日-下午4:06:41
	 * @param param
	 * @return
	 */
	Integer getNewOccupationalDiseasesNum(PhcOccupationalDiseaserParam param);
	/**
	 * 获取职业病人人数
	 * 职业病人名单（18-033）中的人数。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月1日-下午4:20:22
	 * @param cid
	 * @return
	 */
	Integer getOccupationalDiseasesNum(Long cid);

	PhcSuperviseOccupationalDiseaserVo getSuperviseInfo(Long id);

    List<PhcSuperviseOccupationalDiseaserVo> getSuperviseDataList(PhcOccupationalDiseaserParam param);


	/**
	 * 职业病人员数量
	 * @param param
	 * @return
	 */
	Integer diseaserCount( PhcOccupationalDiseaserParam param);

	/**
	 * 有新发职业病的企业
	 * @param begin 诊断时间 开始
	 * @param end 诊断时间 结束
	 * @return 企业 id
	 */
	Set<Long> diseaserCids(Date begin, Date end);

	/**
	 * 新发职业病 人数
	 * @param begin 诊断时间 开始
	 * @param end 诊断时间 结束
	 * @return 企业id->人数
	 */
	Map<Long, Integer> diseaserCidCount(Date begin, Date end);

	/**
	 * 更新监管端状态
	 * @param diseaserId
	 * @param superviseStatus 监管端状态（0：未处理，1：企业端已上报（企业整改上报时改为该状态），2：已忽略，3：已确认
	 */
	void updateSuperviseStatus(Long diseaserId, Integer superviseStatus);

}
