/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.certificate;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.vo.summary.CertificateNumSummVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffCountVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffDetailVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateWorkItemVo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import com.github.pagehelper.PageInfo;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi(肖奕）
 * @since 2017-11-06 04:19
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICertificateStaffService extends IBaseService<CertificateStaff>{

	PageInfo<CertificateStaff> getCertficateList(CertificateStaff info, JqGridParam param);

	List<CertificateStaff> getExportListByCid(Long cid);
	
	/**
	 * 获取企业职业卫生培训合格证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年1月17日-下午5:46:22
	 * @param cid
	 * @return
	 */
	CertificateStaff getHseTrainCert(Long cid,Long nameId);
	/**
	 * 获取证书管理待办信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月16日-上午9:10:13
	 * @param cid
	 * @return
	 */
	CertificateWorkItemVo getCertTodoInfo(Long cid);

	CertificateNumSummVo certStaffSummaryInfo(Long cid, Long nameId, Integer staffType);

	int getCertNumByCid(Long cid);

	void updateWithHistory(CertificateStaff record, Long staffid);

	CertificateStaff addWithHistory(CertificateStaff data, Long staffid, Long cid);

	Boolean haveThisName(Long nameId, Long cid);

	CertificateStaff getByNameId(Long nameId, Long cid);

	/**
	 * 职业卫生培训合格证书的取证人员清单（30-024）中人员类别为主要负责人、职业卫生管理人员的人数，以及证书在有效期内的人数
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年8月1日-上午9:16:21
	 * @param cid
	 * @return
	 */
	TrainCertificateInfo getTrainCertificateInfo(Long cid);

	/**
	 * 删除人员证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年11月14日-上午9:40:57
	 * @param info
	 * @param staffid
	 */
	void deleteWithHis(CertificateStaff info, Long staffid,Long cid);


	 List<CertificateStaffDetailVo> getCertStaffByParam(CertificateStaff info);
	 List<CertificateStaffDetailVo> getCertStaffNoIncludeNoWorkedByParam(CertificateStaff info);


     List<CertificateStaff> getCertficateListByCid(Long cid);
	  /**
	   *@ Description: <获取证书到期时间>
	   *@ Author XiaoYi
	   *@ Date  2022/7/22  16:07
	   *@ param
	   *@ return
	  **/
	 Date getHseCertExpireDate(Long cid);


}
