/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.certificate;

import cn.hutool.core.lang.Pair;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.base.Company;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.certificate.CertificateImportVo;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainCertModel;
import cn.smarthse.modules.health.supervise.model.home.v3223.homeIndex.HomeEnergyEfficiencyVo;
import cn.smarthse.modules.health.supervise.service.keyFactory.IApprovalDataSourceService;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffCountVo;
import cn.smarthse.modules.health.vo.work.staffCert.StaffCertDetailVo;
import com.github.pagehelper.PageInfo;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;


 /**
 *
 * 《xxxService》
 *
 *
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author xiaoyi(肖奕）
 * @since 2017-11-06 04:19
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICertificateStaffDetailService extends IBaseService<CertificateStaffDetail>, IApprovalDataSourceService {

	/**
	 * 根据证书id获取取证人员列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月13日-上午11:41:37
	 * @param id
	 * @return
	 */
	List<CertificateStaffDetail> getListByCertId(Long id);

	Long addWithFile(CertificateStaffDetail staff, Long staffid, Long cid);

	List<CertificateStaffDetail> getListByParam(CertificateStaffDetail info, Long nameId);

	List<CertificateStaffDetail> getListNoIncludeNoWorkedByParam(CertificateStaffDetail info, Long nameId);


	List<CertificateStaffDetail> getListNoIncludeNoWorkedByCidAndNameIdsAndYear(Long cid,String nameIds,Integer year);




	PageInfo<CertificateStaffDetail> getPageDataByParam(CertificateStaffDetail info, Long nameId,JqGridParam param);

	 /**
	  *@ Description: <简化版证书列表>
	  *@ Author XiaoYi
	  *@ Date  2022/7/21  10:53
	  *@ param
	  *@ return
	 **/
	 PageInfo<CertificateStaffDetail> getLitePageDataByParam(CertificateStaffDetail info, JqGridParam param, Date dateNow, String paramYear);


	CertificateStaffDetail getByIdWithFile(Long id);

	void updateWithFile(CertificateStaffDetail record, Long staffid);

	/**
	 * 获取到期人员证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月14日-下午5:31:30
	 * @param info
	 * @param param
	 * @return
	 */
	PageInfo<CertificateStaffDetail> getExpireCertficateList(CertificateStaffDetail info, JqGridParam param);
	/**
	 * 获取到期人员证书数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月16日-上午9:45:25
	 * @param cid
	 * @return
	 */
	Integer getExpireCertficateNum(Long cid);
	/**
	 * 判断企业是否有各种培训合格证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月15日-下午5:30:58
	 * @param cid
	 * @param type
	 * @return
	 */
	Boolean haveManagerCertificate(Long cid,Long nameId, Integer type);

	 public Date getCertificateValidate(Long cid, Long nameId, Integer type);

	 /**
  *@ Description: <对此方法的描述>
  *@ Author XiaoYi
  *@ Date  2022/7/27  14:24
  *@ param
  *@ return
 **/
	 Boolean haveManagerCertificateByCid(Long cid,Long nameId);

	/**
	 * 根据证书编号删除取证人员
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月16日-上午10:24:12
	 * @param id
	 */
	void delByCertId(Long id);

	List<CertificateStaffDetail> getBatchEditList(CertificateStaffDetail info, Long nameId);

	ResponseData<Boolean> isEqualOfCreateTime(Long certId);

	/**
	 * 根据人员id获取人员的证书信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月17日-下午4:16:42
	 * @param staffid
	 * @param gparam
	 * @return
	 */
	PageInfo<CertificateStaffDetail> getByStaffId(Long staffid,JqGridParam gparam);

	/**
	 * 获取不同类别的证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2017年11月20日-上午10:42:57
	 * @param params
	 * @return
	 */
	List<CertificateStaffDetail> getCertListByParam(Map<String, Object> params);


	List<CertificateStaff> getCertStaffNumByCid(Long cid);

	Integer getCertNumByParam(Map<String, Object> params);

	/**
	 * 根据人员编号获取人员证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕)
	 * @since 2018年1月9日-上午9:19:56
	 * @param staffid
	 * @param cid
	 * @return
	 */
	List<CertificateStaffDetail> getCertByStaffId(Long staffid,Long cid);

	PageInfo<CertificateStaffDetail> getStaffCertByStaffId(CertificateStaffDetail info, JqGridParam param);

	/**
	 * 根据证书ID，获取证书附件
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年2月23日-下午6:26:49
	 * @param certId
	 * @return
	 */
	List<CertificateFiles> getCertFilesByCertId(Long certId);

	/**删除取证人员
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年11月14日-上午9:49:05
	 * @param info
	 * @param staffid
	 * @param cid
	 */
	void deleteWithHis(CertificateStaffDetail info, Long staffid, Long cid);


	/**
	 * 获取企业的有效职业卫生管理人员数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2019年5月22日-下午5:32:37
	 * @param cid
	 * @return
	 */
	int getgetHaveEffectiveHseCertNumBycid(Long cid);

	/**
	 * 判断企业是否有有效的主要负责人职业卫生管理合格证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2019年5月22日-下午5:34:18
	 * @param cid
	 * @return
	 */
	Boolean haveMainEffectiveCertByCid(Long cid);

	/**
	 *
	 * @Comments:  <该人员是否有证书>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since Sep 2, 2020-9:58:18 AM
	 * @param staffid
	 * @param cid
	 * @return
	 */
	CertificateStaffDetail getCertForOrgByStaffId(Long staffid,Long certId, Long cid,Long reportId);

	 CertificateStaffDetail getCertForOrgByStaffIdAndCertType(Long staffid,Integer staffType, Long cid);

	 /**
	  * 证书同步接口（查询该人员是否已有某个培训的证书）
	  * @param trainId 培训id
	  * @param staffId 员工id
	  * @param staffType 人员类型（主要负责人/职业管理人员）
	  * @param cid 企业cid
	  * @return 证书信息
	  */
	 CertificateStaffDetail getCertForOrgByStaffIdAndCertType(Long trainId, Long staffId, Integer staffType, Long cid);

	 /**
	  * @description: 证书同步接口（查询人员是否已有某个在线培训证书）
	  * @version: 在线培训
	  * @date: 2024-07-5 16:37
	  * @param: 传参说明：
	  * 		certSync -> 在线培训同步入参数据
	  * @return: {@link CertificateStaffDetail} 证书信息
	  * @author: DengJia 18402894534@163.com
	  */
	 CertificateStaffDetail getOnlineTrainCertBySyncInfo(TrainAttendModel certSync);

	 /**
	  * @description: 证书同步接口（查询人员是否已有某个线下培训证书）
	  * @version: 东阳线下培训
	  * @date: 2024-07-2 23:45
	  * @param: 传参说明：
	  * 		certSync -> 同步入参数据
	  * @return: {@link CertificateStaffDetail} 证书信息
	  * @author: DengJia 18402894534@163.com
	  */
	 CertificateStaffDetail getDongYangCertBySyncInfo(TrainCertModel certSync);

	CertificateStaffDetail addCertStaffForOrg(CertificateStaffDetail info);

	void addOrUpdateFileForOrg(Long[] fileIds, Long staffCertId, Long cid, Long staffid);

	 void addOrUpdateFile(String fileIds, Long staffCertId, Long cid, Long staffid);

	/**
	 *
	 * @Comments:  <机构端监管端查询人员证书>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since Sep 2, 2020-3:08:53 PM
	 * @param info
	 * @param param
	 * @return
	 */
	PageInfo<StaffCertDetailVo> getStaffCertListPageForOrg(CertificateStaffDetail info, JqGridParam param);

	 /**
	  * @Comments:  监管端-职业健康培训项目查看-人员证书信息（培训创建的企业数据不显示）
	  * @author wujiacheng
	  * @since 2022-10-19
	  * @param info
	  * @param param
	  * @return
	  */
	 PageInfo<StaffCertDetailVo> getStaffCertListPageForSup(CertificateStaffDetail info, JqGridParam param);

	List<Long> getCerFileIds(List<Long>   reportIds);

	 /**
	  *
	  * @Comments:  <机构端监管端查询人员证书>
	  * @author BinXu(徐斌) [784514607@qq.com]
	  * @since Sep 2, 2020-3:08:53 PM
	  * @param info
	  * @param param
	  * @return
	  */
	 List<StaffCertDetailVo> getStaffCertListForOrg(CertificateStaffDetail info);

     void addOrUpdateFile(List<SysFileModel> fileModelList, Long id, Long cid, Long staffId);

     List<CertificateStaffDetail> getListNoIncludeNoWorkedByCertId(Long id);

	 List<CertificateImportVo> getCertInfoFromExcel(String ossfile);

	 int importCertInfo(List<CertificateImportVo> list) throws Exception;

     int batchUpdateStaffName(List<CertificateStaffDetail> certificateList, String staffName);

	 List<CertificateStaffDetail> getListByParam(Long staffId, Long cid, Long reportId);

	 /**
	  * 获取企业管理人员和主要负责人的证书（有效期内）
	  * @author Supw
	  * @param cid
	  * @return
	  */
	 List<CertificateStaffDetail> getManagePrincipalCert(Long cid);

	 /**
	  * 风险化解管理自动验收查询培训接口
	  * @param type 12 主要负责人 13 管理人员
	  * @param cidList
	  * @return
	  */
	 Map<Long, CertificateStaffDetail> getCertificateMapByCid(List<Long> cidList, Integer type);

	 /**
	  * @description 新增主要负责人证书-提交监管端审核
	  * @author 覃浩云 1770126791@qq.com
	  * @date 2023/5/6 15:45
	  */
	 Long submitApproval(Company currentCompany, StaffInfo staffInfo , CertificateStaffDetail record);

	 /**
	  * @description: 终止申请企业负责人培训
	  * @version: 3.2.2.2
	  * @date: 2023/6/20 10:14
	  * @param: info, loginStaffId, currentCompany 当前登录人，当前登录企业
	  * @return: {@link String} 成功/失败
	  * @author: DengJia 18402894534@163.com
	  */
	 Pair<String, Long> setTermination(CertificateStaffDetail info, Long loginStaffId, Company currentCompany);

     void saveBatch(List<CertificateStaffDetail> details);

     List<CertificateStaffDetail> getLastUpdate(Long cidParam, Date updateDate);


	 /**
	  * 给第一次未设置sourceId的证书添加sourceId
	  * @param cid
	  */
	 void setSourceId(Long cid);

	 /**
	  * 获取用人单位培训率（两个证书有一个到今天有效就算完成）
	  * @param searchVo
	  * @param efficiencyVo
	  * @return {@link List}<{@link HomeEnergyEfficiencyVo}>
	  */
	 HomeEnergyEfficiencyVo getCertificateRate(HomeIndexSearchVo searchVo, HomeEnergyEfficiencyVo efficiencyVo);


	 List<CertificateStaffCountVo> countCertByCids(List<Long> cids);
 }
