/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.certificate;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.certificate.CertificateName;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi(肖奕）
 * @since 2017-11-06 04:19
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICertificateNameService extends IBaseService<CertificateName>{

	/**
	 * 根据证书类型分页获取证书名称
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月8日-下午2:18:20
	 * @param info
	 * @param param
	 * @return
	 */
	PageInfo<CertificateName> getCertNameList(CertificateName info, JqGridParam param);

	/**
	 * 根据证书类型获取证书名称列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月8日-下午2:18:45
	 * @param info
	 * @return
	 */
	List<CertificateName> getListByType(CertificateName info);


	/**
	 * 获取首页统计信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月20日-上午10:22:31
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);

	void updateWithHistory(CertificateName info, Long staffid);

	CertificateName addWithHistory(CertificateName info, Long staffid, Long cid);

	Boolean haveThisName(String name, Long cid, Byte nameType);

	void delWithHis(CertificateName info, Long staffid,Long cid);
	
	/**
	 * 获取自定义数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年12月14日-下午4:59:40
	 * @return
	 */
	List<CertificateName> getAllCustom();
}
