/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.certificate;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDevice;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi(肖奕）
 * @since 2017-11-06 04:19
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICertificateDeviceService extends IBaseService<CertificateDevice>{

	PageInfo<CertificateDevice> getCertficateList(CertificateDevice info, JqGridParam param);

	/**获取导出设备证书列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月13日-上午9:59:34
	 * @param cid
	 * @return
	 */
	List<CertificateDevice> getExportListByCid(Long cid);

    /**
     * 根据cid获取证书数量
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕) 
     * @since 2017年12月14日-下午4:47:32
     * @param cid
     * @return
     */
    int getNumOfDeviceCertByCid(Long cid);

	void updateWithHistory(CertificateDevice record, Long staffid);

	CertificateDevice addWithHistory(CertificateDevice record, Long staffid, Long cid);

	/**
	 * 判断是否存在该设备的证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年8月17日-下午4:30:14
	 * @param deviceId
	 * @param cid
	 * @param cid2 
	 * @return
	 */
	Boolean haveThisDevice(Long id,Long deviceId, Long cid);

	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年11月14日-上午11:47:35
	 * @param info
	 * @param staffid
	 * @param cid
	 */
	void delWithHis(CertificateDevice info, Long staffid, Long cid);

}
