/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.certificate;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDeviceDetail;
import cn.smarthse.modules.health.vo.summary.CertificateNumSummVo;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi(肖奕）
 * @since 2017-11-06 04:19
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICertificateDeviceDetailService extends IBaseService<CertificateDeviceDetail>{

	List<CertificateDeviceDetail> getCertListByCertId(Long id);

	/**
	 * 添加设备证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月10日-上午10:04:27
	 * @param record
	 * @param staffid
	 * @param cid
	 */
	void addCertDeviceDetail(CertificateDeviceDetail record, Long staffid, Long cid);
	
	/**
	 * 获取证书信息，包括附件等
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月10日-上午10:08:03
	 * @param id
	 * @return
	 */
	CertificateDeviceDetail getByIdWithAll(Long id);

	/**
	 * 编辑设备证书，包括附件
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月10日-上午10:59:39
	 * @param record
	 * @param staffid
	 * @param cid
	 */
	void updateCertDeviceDetail(CertificateDeviceDetail record, Long staffid, Long cid);

	/**
	 * 获取到期设备证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月10日-下午1:38:05
	 * @param info
	 * @param param
	 * @return
	 */
	PageInfo<CertificateDeviceDetail> getExpireCertficateList(CertificateDeviceDetail info, JqGridParam param);


	/**
	 * 获取到期设备证书数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月16日-上午9:45:25
	 * @param cid
	 * @return
	 */
	Integer getExpireCertficateNum(Long cid);

	/**
	 * 根据证书编号删除下面的详细证书信息（逻辑删除）
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月16日-上午10:31:17
	 * @param id
	 * @param staffid
	 */
	void delByCertId(Long id, Long staffid);
	
	
	/**
	 * 根据设备编号获取证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月20日-下午2:27:52
	 * @param id
	 * @return
	 */
	PageInfo<CertificateDeviceDetail> getCertListByDeviceId(Long deviceId,JqGridParam param);
	
	/**
	 * 统计某种类型的设备证书信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年12月29日-下午1:43:18
	 * @param cid
	 * @param nameId
	 * @return
	 */
	CertificateNumSummVo certDeviceSummaryInfo(Long cid, Long nameId);

	Boolean haveThisName(Long nameId, Long cid, Long certId);

	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年11月14日-上午11:51:09
	 * @param info
	 * @param staffid
	 * @param cid
	 */
	void delWithHis(CertificateDeviceDetail info, Long staffid, Long cid);

	
	
}
