/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.certificate;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.certificate.CertificateCompany;
import cn.smarthse.modules.health.vo.summary.CertificateNumSummVo;


 /**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi(肖奕）
 * @since 2017-11-06 04:18
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ICertificateCompanyService extends IBaseService<CertificateCompany>{

	/**
	 * 获取企业证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月8日-上午9:53:09
	 * @param info
	 * @param param
	 * @return
	 */
	PageInfo<CertificateCompany> getCertficateList(CertificateCompany info, JqGridParam param);

	/**
	 * 更新企业证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月8日-下午3:03:26
	 * @param record
	 * @param staffid
	 */
	void updateCertComp(CertificateCompany record, Long staffid);

	/**
	 * 新增企业证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月8日-下午3:03:37
	 * @param record
	 * @param staffid
	 * @param cid
	 */
	void addCertComp(CertificateCompany record, Long staffid, Long cid);


	CertificateCompany getByIdWithFile(Long id);

	/**
	 * 根据cid获取导出企业证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月8日-下午4:08:50
	 * @param cid
	 * @return
	 */
	List<CertificateCompany> getExportListByCid(Long cid);
	
	/**
	 * 获取到期企业证书列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月9日-下午2:00:50
	 * @param info
	 * @param param
	 * @return
	 */
	PageInfo<CertificateCompany> getExpireCertficateList(CertificateCompany info, JqGridParam param);
	
	/**
	 * 获取到期企业证书数量
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月16日-上午9:45:25
	 * @param cid
	 * @return
	 */
	Integer getExpireCertficateNum(Long cid);
	
	/**
	 * 获取企业营业执照
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月17日-下午4:44:56
	 * @param cid
	 * @return
	 */
	CertificateCompany getBusinessLicenseByCid(Long cid);

	/**
	 * 获取企业证书过期，有效，待复审数量信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年11月20日-上午11:31:56
	 * @param cid
	 * @return
	 */
	CertificateNumSummVo getCertStaffSummaryInfo(Long cid);
	
	int getCertficateNumByCid(Long cid);

	/**
	 * 判断是否已经存在该名称的企业证书
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年7月18日-上午11:20:55
	 * @param nameId
	 * @param cid 
	 * @return
	 */
	Boolean haveThisName(Long nameId, Long cid);

	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年11月14日-上午11:43:15
	 * @param info
	 * @param staffid
	 * @param cid
	 */
	void deleWithHis(CertificateCompany info, Long staffid, Long cid);
}
